/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar;

import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.common.Clock;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.LongExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.FilteredExemplarReservoir;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.HistogramExemplarReservoir;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.NoopExemplarReservoir;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.RandomFixedSizeExemplarReservoir;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;

public interface ExemplarReservoir<T extends ExemplarData> {
    public static <T extends ExemplarData> ExemplarReservoir<T> filtered(ExemplarFilter exemplarFilter, ExemplarReservoir<T> exemplarReservoir) {
        return new FilteredExemplarReservoir<T>(exemplarFilter, exemplarReservoir);
    }

    public static ExemplarReservoir<DoubleExemplarData> doubleNoSamples() {
        return NoopExemplarReservoir.DOUBLE_INSTANCE;
    }

    public static ExemplarReservoir<LongExemplarData> longNoSamples() {
        return NoopExemplarReservoir.LONG_INSTANCE;
    }

    public static ExemplarReservoir<DoubleExemplarData> doubleFixedSizeReservoir(Clock clock, int n2, Supplier<Random> supplier) {
        return RandomFixedSizeExemplarReservoir.createDouble(clock, n2, supplier);
    }

    public static ExemplarReservoir<LongExemplarData> longFixedSizeReservoir(Clock clock, int n2, Supplier<Random> supplier) {
        return RandomFixedSizeExemplarReservoir.createLong(clock, n2, supplier);
    }

    public static ExemplarReservoir<DoubleExemplarData> histogramBucketReservoir(Clock clock, List<Double> list) {
        return new HistogramExemplarReservoir(clock, list);
    }

    public void offerDoubleMeasurement(double var1, Attributes var3, Context var4);

    public void offerLongMeasurement(long var1, Attributes var3, Context var4);

    public List<T> collectAndReset(Attributes var1);
}

