/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar;

import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.List;

class FilteredExemplarReservoir<T extends ExemplarData>
implements ExemplarReservoir<T> {
    private final ExemplarFilter filter;
    private final ExemplarReservoir<T> reservoir;

    FilteredExemplarReservoir(ExemplarFilter exemplarFilter, ExemplarReservoir<T> exemplarReservoir) {
        this.filter = exemplarFilter;
        this.reservoir = exemplarReservoir;
    }

    @Override
    public void offerDoubleMeasurement(double d2, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(d2, attributes, context)) {
            this.reservoir.offerDoubleMeasurement(d2, attributes, context);
        }
    }

    @Override
    public void offerLongMeasurement(long l2, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(l2, attributes, context)) {
            this.reservoir.offerLongMeasurement(l2, attributes, context);
        }
    }

    @Override
    public List<T> collectAndReset(Attributes attributes) {
        return this.reservoir.collectAndReset(attributes);
    }
}

