/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.view;

import com.contrastsecurity.thirdparty.iot.sdk.common.Clock;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.PointData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.DoubleExplicitBucketHistogramAggregator;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.List;

public final class ExplicitBucketHistogramAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation DEFAULT = new ExplicitBucketHistogramAggregation(ExplicitBucketHistogramUtils.DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES);
    private final List<Double> bucketBoundaries;
    private final double[] bucketBoundaryArray;

    public static Aggregation getDefault() {
        return DEFAULT;
    }

    public static Aggregation create(List<Double> list) {
        return new ExplicitBucketHistogramAggregation(list);
    }

    private ExplicitBucketHistogramAggregation(List<Double> list) {
        this.bucketBoundaries = list;
        this.bucketBoundaryArray = ExplicitBucketHistogramUtils.createBoundaryArray(list);
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        return new DoubleExplicitBucketHistogramAggregator(this.bucketBoundaryArray, () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.histogramBucketReservoir(Clock.getDefault(), this.bucketBoundaries)));
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case HISTOGRAM: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ExplicitBucketHistogramAggregation(" + this.bucketBoundaries.toString() + ")";
    }
}

