/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.trace;

import com.contrastsecurity.thirdparty.iot.api.trace.SpanBuilder;
import com.contrastsecurity.thirdparty.iot.api.trace.Tracer;
import com.contrastsecurity.thirdparty.iot.api.trace.TracerProvider;
import com.contrastsecurity.thirdparty.iot.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SdkSpanBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.trace.TracerSharedState;

final class SdkTracer
implements Tracer {
    static final String FALLBACK_SPAN_NAME = "<unspecified span name>";
    private final TracerSharedState sharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;

    SdkTracer(TracerSharedState tracerSharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        this.sharedState = tracerSharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
    }

    @Override
    public SpanBuilder spanBuilder(String string) {
        if (string == null || string.trim().isEmpty()) {
            string = FALLBACK_SPAN_NAME;
        }
        if (this.sharedState.hasBeenShutdown()) {
            Tracer tracer = TracerProvider.noop().get(this.instrumentationScopeInfo.getName());
            return tracer.spanBuilder(string);
        }
        return new SdkSpanBuilder(string, this.instrumentationScopeInfo, this.sharedState, this.sharedState.getSpanLimits());
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }
}

