/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.trace;

import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.trace.MultiSpanProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.trace.NoopSpanProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.trace.ReadWriteSpan;
import com.contrastsecurity.thirdparty.iot.sdk.trace.ReadableSpan;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface SpanProcessor
extends Closeable {
    public static SpanProcessor composite(SpanProcessor ... spanProcessorArray) {
        return SpanProcessor.composite(Arrays.asList(spanProcessorArray));
    }

    public static SpanProcessor composite(Iterable<SpanProcessor> iterable) {
        ArrayList<SpanProcessor> arrayList = new ArrayList<SpanProcessor>();
        for (SpanProcessor spanProcessor : iterable) {
            arrayList.add(spanProcessor);
        }
        if (arrayList.isEmpty()) {
            return NoopSpanProcessor.getInstance();
        }
        if (arrayList.size() == 1) {
            return (SpanProcessor)arrayList.get(0);
        }
        return MultiSpanProcessor.create(arrayList);
    }

    public void onStart(Context var1, ReadWriteSpan var2);

    public boolean isStartRequired();

    public void onEnd(ReadableSpan var1);

    public boolean isEndRequired();

    default public CompletableResultCode shutdown() {
        return this.forceFlush();
    }

    default public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

