/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.trace.export;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.iot.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.metrics.LongCounter;
import com.contrastsecurity.thirdparty.iot.api.metrics.Meter;
import com.contrastsecurity.thirdparty.iot.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.internal.DaemonThreadFactory;
import com.contrastsecurity.thirdparty.iot.sdk.internal.ThrowableUtil;
import com.contrastsecurity.thirdparty.iot.sdk.trace.ReadWriteSpan;
import com.contrastsecurity.thirdparty.iot.sdk.trace.ReadableSpan;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SpanProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.trace.data.SpanData;
import com.contrastsecurity.thirdparty.iot.sdk.trace.export.BatchSpanProcessorBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.trace.export.SpanExporter;
import com.contrastsecurity.thirdparty.iot.sdk.trace.internal.JcTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class BatchSpanProcessor
implements SpanProcessor {
    private static final e logger = e.a(BatchSpanProcessor.class.getName());
    private static final String WORKER_THREAD_NAME = BatchSpanProcessor.class.getSimpleName() + "_WorkerThread";
    private static final AttributeKey<String> SPAN_PROCESSOR_TYPE_LABEL = AttributeKey.stringKey("spanProcessorType");
    private static final AttributeKey<Boolean> SPAN_PROCESSOR_DROPPED_LABEL = AttributeKey.booleanKey("dropped");
    private static final String SPAN_PROCESSOR_TYPE_VALUE = BatchSpanProcessor.class.getSimpleName();
    private final Worker worker;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static BatchSpanProcessorBuilder builder(SpanExporter spanExporter) {
        return new BatchSpanProcessorBuilder(spanExporter);
    }

    BatchSpanProcessor(SpanExporter spanExporter, MeterProvider meterProvider, long l2, int n2, int n3, long l3) {
        this.worker = new Worker(spanExporter, meterProvider, l2, n3, l3, JcTools.newFixedSizeQueue(n2));
        Thread thread = new DaemonThreadFactory(WORKER_THREAD_NAME).newThread(this.worker);
        thread.start();
    }

    @Override
    public void onStart(Context context, ReadWriteSpan readWriteSpan) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan readableSpan) {
        if (readableSpan == null || !readableSpan.getSpanContext().isSampled()) {
            return;
        }
        this.worker.addSpan(readableSpan);
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        return this.worker.shutdown();
    }

    @Override
    public CompletableResultCode forceFlush() {
        return this.worker.forceFlush();
    }

    List<SpanData> getBatch() {
        return this.worker.batch;
    }

    Queue<ReadableSpan> getQueue() {
        return this.worker.queue;
    }

    public String toString() {
        return "BatchSpanProcessor{spanExporter=" + this.worker.spanExporter + ", scheduleDelayNanos=" + this.worker.scheduleDelayNanos + ", maxExportBatchSize=" + this.worker.maxExportBatchSize + ", exporterTimeoutNanos=" + this.worker.exporterTimeoutNanos + '}';
    }

    private static final class Worker
    implements Runnable {
        private final LongCounter processedSpansCounter;
        private final Attributes droppedAttrs;
        private final Attributes exportedAttrs;
        private final SpanExporter spanExporter;
        private final long scheduleDelayNanos;
        private final int maxExportBatchSize;
        private final long exporterTimeoutNanos;
        private long nextExportTime;
        private final Queue<ReadableSpan> queue;
        private final AtomicInteger spansNeeded = new AtomicInteger(Integer.MAX_VALUE);
        private final BlockingQueue<Boolean> signal;
        private final AtomicReference<CompletableResultCode> flushRequested = new AtomicReference();
        private volatile boolean continueWork = true;
        private final ArrayList<SpanData> batch;

        private Worker(SpanExporter spanExporter, MeterProvider meterProvider, long l2, int n2, long l3, Queue<ReadableSpan> queue) {
            this.spanExporter = spanExporter;
            this.scheduleDelayNanos = l2;
            this.maxExportBatchSize = n2;
            this.exporterTimeoutNanos = l3;
            this.queue = queue;
            this.signal = new ArrayBlockingQueue<Boolean>(1);
            Meter meter = meterProvider.meterBuilder("com.contrastsecurity.thirdparty.iot.sdk.trace").build();
            meter.gaugeBuilder("queueSize").ofLongs().setDescription("The number of spans queued").setUnit("1").buildWithCallback(observableLongMeasurement -> observableLongMeasurement.record(queue.size(), Attributes.of(SPAN_PROCESSOR_TYPE_LABEL, SPAN_PROCESSOR_TYPE_VALUE)));
            this.processedSpansCounter = meter.counterBuilder("processedSpans").setUnit("1").setDescription("The number of spans processed by the BatchSpanProcessor. [dropped=true if they were dropped due to high throughput]").build();
            this.droppedAttrs = Attributes.of(SPAN_PROCESSOR_TYPE_LABEL, SPAN_PROCESSOR_TYPE_VALUE, SPAN_PROCESSOR_DROPPED_LABEL, true);
            this.exportedAttrs = Attributes.of(SPAN_PROCESSOR_TYPE_LABEL, SPAN_PROCESSOR_TYPE_VALUE, SPAN_PROCESSOR_DROPPED_LABEL, false);
            this.batch = new ArrayList(this.maxExportBatchSize);
        }

        private void addSpan(ReadableSpan readableSpan) {
            if (!this.queue.offer(readableSpan)) {
                this.processedSpansCounter.add(1L, this.droppedAttrs);
            } else if (this.queue.size() >= this.spansNeeded.get()) {
                this.signal.offer(true);
            }
        }

        @Override
        public void run() {
            this.updateNextExportTime();
            while (this.continueWork) {
                if (this.flushRequested.get() != null) {
                    this.flush();
                }
                JcTools.drain(this.queue, this.maxExportBatchSize - this.batch.size(), readableSpan -> this.batch.add(readableSpan.toSpanData()));
                if (this.batch.size() >= this.maxExportBatchSize || System.nanoTime() >= this.nextExportTime) {
                    this.exportCurrentBatch();
                    this.updateNextExportTime();
                }
                if (!this.queue.isEmpty()) continue;
                try {
                    long l2 = this.nextExportTime - System.nanoTime();
                    if (l2 <= 0L) continue;
                    this.spansNeeded.set(this.maxExportBatchSize - this.batch.size());
                    this.signal.poll(l2, TimeUnit.NANOSECONDS);
                    this.spansNeeded.set(Integer.MAX_VALUE);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        private void flush() {
            Object object;
            for (int i2 = this.queue.size(); i2 > 0; --i2) {
                object = this.queue.poll();
                assert (object != null);
                this.batch.add(object.toSpanData());
                if (this.batch.size() < this.maxExportBatchSize) continue;
                this.exportCurrentBatch();
            }
            this.exportCurrentBatch();
            object = this.flushRequested.get();
            if (object != null) {
                ((CompletableResultCode)object).succeed();
                this.flushRequested.set(null);
            }
        }

        private void updateNextExportTime() {
            this.nextExportTime = System.nanoTime() + this.scheduleDelayNanos;
        }

        private CompletableResultCode shutdown() {
            CompletableResultCode completableResultCode = new CompletableResultCode();
            CompletableResultCode completableResultCode2 = this.forceFlush();
            completableResultCode2.whenComplete(() -> {
                this.continueWork = false;
                CompletableResultCode completableResultCode3 = this.spanExporter.shutdown();
                completableResultCode3.whenComplete(() -> {
                    if (!completableResultCode2.isSuccess() || !completableResultCode3.isSuccess()) {
                        completableResultCode.fail();
                    } else {
                        completableResultCode.succeed();
                    }
                });
            });
            return completableResultCode;
        }

        private CompletableResultCode forceFlush() {
            CompletableResultCode completableResultCode;
            CompletableResultCode completableResultCode2 = new CompletableResultCode();
            if (this.flushRequested.compareAndSet(null, completableResultCode2)) {
                this.signal.offer(true);
            }
            return (completableResultCode = this.flushRequested.get()) == null ? CompletableResultCode.ofSuccess() : completableResultCode;
        }

        private void exportCurrentBatch() {
            if (this.batch.isEmpty()) {
                return;
            }
            try {
                CompletableResultCode completableResultCode = this.spanExporter.export(Collections.unmodifiableList(this.batch));
                completableResultCode.join(this.exporterTimeoutNanos, TimeUnit.NANOSECONDS);
                if (completableResultCode.isSuccess()) {
                    this.processedSpansCounter.add(this.batch.size(), this.exportedAttrs);
                } else {
                    logger.a(e.a.f, "Exporter failed");
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                ThrowableUtil.propagateIfFatal(throwable2);
                logger.a(e.a.c, "Exporter threw an Exception", throwable2);
            }
            finally {
                this.batch.clear();
            }
        }
    }
}

