/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.trace.samplers;

import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.trace.TraceState;
import com.contrastsecurity.thirdparty.iot.sdk.trace.samplers.ImmutableSamplingResult;
import com.contrastsecurity.thirdparty.iot.sdk.trace.samplers.SamplingDecision;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface SamplingResult {
    public static SamplingResult create(SamplingDecision samplingDecision) {
        switch (samplingDecision) {
            case RECORD_AND_SAMPLE: {
                return ImmutableSamplingResult.EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
            }
            case RECORD_ONLY: {
                return ImmutableSamplingResult.EMPTY_RECORDED_SAMPLING_RESULT;
            }
            case DROP: {
                return ImmutableSamplingResult.EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
            }
        }
        throw new AssertionError((Object)"unrecognised samplingResult");
    }

    public static SamplingResult create(SamplingDecision samplingDecision, Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        return attributes.isEmpty() ? SamplingResult.create(samplingDecision) : ImmutableSamplingResult.createSamplingResult(samplingDecision, attributes);
    }

    public static SamplingResult recordAndSample() {
        return ImmutableSamplingResult.EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
    }

    public static SamplingResult recordOnly() {
        return ImmutableSamplingResult.EMPTY_RECORDED_SAMPLING_RESULT;
    }

    public static SamplingResult drop() {
        return ImmutableSamplingResult.EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
    }

    public SamplingDecision getDecision();

    public Attributes getAttributes();

    default public TraceState getUpdatedTraceState(TraceState traceState) {
        return traceState;
    }
}

