/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jrgx;

import com.contrastsecurity.thirdparty.jrgx.BackReference;
import com.contrastsecurity.thirdparty.jrgx.Branch;
import com.contrastsecurity.thirdparty.jrgx.CharacterClass;
import com.contrastsecurity.thirdparty.jrgx.ConditionalExpr;
import com.contrastsecurity.thirdparty.jrgx.Group;
import com.contrastsecurity.thirdparty.jrgx.IndependentGroup;
import com.contrastsecurity.thirdparty.jrgx.Iterator;
import com.contrastsecurity.thirdparty.jrgx.Lookahead;
import com.contrastsecurity.thirdparty.jrgx.Lookbehind;
import com.contrastsecurity.thirdparty.jrgx.Optimizer;
import com.contrastsecurity.thirdparty.jrgx.Pattern;
import com.contrastsecurity.thirdparty.jrgx.PatternSyntaxException;
import com.contrastsecurity.thirdparty.jrgx.Pretokenizer;
import com.contrastsecurity.thirdparty.jrgx.REFlags;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Term
implements REFlags {
    static final int CHAR = 0;
    static final int BITSET = 1;
    static final int BITSET2 = 2;
    static final int ANY_CHAR = 4;
    static final int ANY_CHAR_NE = 5;
    static final int REG = 6;
    static final int REG_I = 7;
    static final int FIND = 8;
    static final int FINDREG = 9;
    static final int SUCCESS = 10;
    static final int BOUNDARY = 11;
    static final int DIRECTION = 12;
    static final int UBOUNDARY = 13;
    static final int UDIRECTION = 14;
    static final int GROUP_IN = 15;
    static final int GROUP_OUT = 16;
    static final int VOID = 17;
    static final int START = 18;
    static final int END = 19;
    static final int END_EOL = 20;
    static final int LINE_START = 21;
    static final int LINE_END = 22;
    static final int LAST_MATCH_END = 23;
    static final int CNT_SET_0 = 24;
    static final int CNT_INC = 25;
    static final int CNT_GT_EQ = 26;
    static final int READ_CNT_LT = 27;
    static final int CRSTORE_CRINC = 28;
    static final int CR_SET_0 = 29;
    static final int CR_LT = 30;
    static final int CR_GT_EQ = 31;
    static final int BRANCH = 32;
    static final int BRANCH_STORE_CNT = 33;
    static final int BRANCH_STORE_CNT_AUX1 = 34;
    static final int PLOOKAHEAD_IN = 35;
    static final int PLOOKAHEAD_OUT = 36;
    static final int NLOOKAHEAD_IN = 37;
    static final int NLOOKAHEAD_OUT = 38;
    static final int PLOOKBEHIND_IN = 39;
    static final int PLOOKBEHIND_OUT = 40;
    static final int NLOOKBEHIND_IN = 41;
    static final int NLOOKBEHIND_OUT = 42;
    static final int INDEPENDENT_IN = 43;
    static final int INDEPENDENT_OUT = 44;
    static final int REPEAT_0_INF = 45;
    static final int REPEAT_MIN_INF = 46;
    static final int REPEAT_MIN_MAX = 47;
    static final int REPEAT_REG_MIN_INF = 48;
    static final int REPEAT_REG_MIN_MAX = 49;
    static final int BACKTRACK_0 = 50;
    static final int BACKTRACK_MIN = 51;
    static final int BACKTRACK_FIND_MIN = 52;
    static final int BACKTRACK_FINDREG_MIN = 53;
    static final int BACKTRACK_REG_MIN = 54;
    static final int MEMREG_CONDITION = 55;
    static final int LOOKAHEAD_CONDITION_IN = 56;
    static final int LOOKAHEAD_CONDITION_OUT = 57;
    static final int LOOKBEHIND_CONDITION_IN = 58;
    static final int LOOKBEHIND_CONDITION_OUT = 59;
    static final int FIRST_TRANSPARENT = 11;
    static final int LAST_TRANSPARENT = 31;
    static final int VARS_LENGTH = 4;
    private static final int MEMREG_COUNT = 0;
    private static final int CNTREG_COUNT = 1;
    private static final int DEPTH = 2;
    private static final int LOOKAHEAD_COUNT = 3;
    private static final int LIMITS_LENGTH = 3;
    private static final int LIMITS_PARSE_RESULT_INDEX = 2;
    private static final int LIMITS_OK = 1;
    private static final int LIMITS_FAILURE = 2;
    Term next;
    Term failNext;
    int type = 17;
    boolean inverse;
    char c;
    int distance;
    boolean eat;
    boolean[] bitset;
    boolean[][] bitset2;
    boolean[] categoryBitset;
    char[] brackets;
    int weight;
    int memreg = -1;
    int minCount;
    int maxCount;
    Term target;
    int cntreg = 0;
    int lookaheadId;
    protected Term prev;
    protected Term in;
    protected Term out;
    protected Term out1;
    protected Term first;
    protected Term current;
    protected Term branchOut;
    static int instances;
    int instanceNum = instances++;

    Term() {
        this.in = this.out = this;
    }

    Term(int n2) {
        this();
        this.type = n2;
    }

    static void makeTree(String string, int n2, Pattern pattern) throws PatternSyntaxException {
        char[] cArray = string.toCharArray();
        Term.makeTree(cArray, 0, cArray.length, n2, pattern);
    }

    static void makeTree(char[] cArray, int n2, int n3, int n4, Pattern pattern) throws PatternSyntaxException {
        Term term;
        int[] nArray = new int[]{1, 0, 0, 0};
        Vector vector = new Vector();
        Hashtable hashtable = new Hashtable();
        Pretokenizer pretokenizer = new Pretokenizer(cArray, n2, n3);
        Term term2 = Term.makeTree(pretokenizer, cArray, nArray, n4, new Group(), vector, hashtable);
        term2.out.type = 10;
        Term term3 = term = term2.next;
        Optimizer optimizer = Optimizer.find(term);
        if (optimizer != null) {
            term3 = optimizer.makeFirst(term);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Iterator iterator = (Iterator)enumeration.nextElement();
            iterator.optimize();
        }
        pattern.root = term3;
        pattern.root0 = term;
        pattern.memregs = nArray[0];
        pattern.counters = nArray[1];
        pattern.lookaheads = nArray[3];
        pattern.namedGroupMap = hashtable;
    }

    /*
     * Unable to fully structure code
     */
    private static Term makeTree(Pretokenizer var0, char[] var1_1, int[] var2_2, int var3_3, Term var4_4, Vector var5_5, Hashtable var6_6) throws PatternSyntaxException {
        if (var2_2.length != 4) {
            throw new IllegalArgumentException("vars.length should be 4, not " + var2_2.length);
        }
        block26: while (true) {
            var0.next();
            var4_4.append(var0.tOffset, var0.tOutside, var1_1, var2_2, var3_3, var5_5, var6_6);
            switch (var0.ttype) {
                case 11: {
                    var3_3 = var0.flags(var3_3);
                    continue block26;
                }
                case 12: {
                    var0.next();
                    var7_7 = new Term();
                    CharacterClass.parseGroup(var1_1, var0.tOffset, var0.tOutside, var7_7, (var3_3 & 1) > 0, (var3_3 & 8) > 0, (var3_3 & 16) > 0, (var3_3 & 32) > 0);
                    var4_4.append(var7_7);
                    continue block26;
                }
                case 3: {
                    var2_2[2] = var2_2[2] + 1;
                    var4_4.append(Term.makeTree(var0, var1_1, var2_2, var0.flags(var3_3), new Group(), var5_5, var6_6));
                    continue block26;
                }
                case 13: {
                    var8_8 = var0.groupName;
                    if (Character.isDigit(var8_8.charAt(0))) {
                        try {
                            var9_9 = Integer.parseInt(var8_8);
                        }
                        catch (NumberFormatException var10_11) {
                            throw new PatternSyntaxException("group name starts with digit but is not a number");
                        }
                        if (var6_6.contains(new Integer(var9_9)) && var0.groupDeclared) {
                            throw new PatternSyntaxException("group redeclaration: " + var8_8 + "; use ({=id}...) for multiple group assignments");
                        }
                        if (var2_2[0] <= var9_9) {
                            var2_2[0] = var9_9 + 1;
                        }
                    } else {
                        var10_10 = (Integer)var6_6.get(var8_8);
                        if (var10_10 == null) {
                            var2_2[0] = var2_2[0] + 1;
                            var6_6.put(var0.groupName, new Integer(var9_9));
                        } else {
                            if (var0.groupDeclared) {
                                throw new PatternSyntaxException("group redeclaration " + var8_8 + "; use ({=name}...) for group reassignments");
                            }
                            var9_9 = var10_10.intValue();
                        }
                    }
                    var2_2[2] = var2_2[2] + 1;
                    var4_4.append(Term.makeTree(var0, var1_1, var2_2, var3_3, new Group(var9_9), var5_5, var6_6));
                    continue block26;
                }
                case 40: {
                    var2_2[2] = var2_2[2] + 1;
                    v0 = var2_2[0];
                    var2_2[0] = v0 + 1;
                    var4_4.append(Term.makeTree(var0, var1_1, var2_2, var3_3, new Group(v0), var5_5, var6_6));
                    continue block26;
                }
                case 4: {
                    var2_2[2] = var2_2[2] + 1;
                    v1 = var2_2[3];
                    var2_2[3] = v1 + 1;
                    var4_4.append(Term.makeTree(var0, var1_1, var2_2, var3_3, new Lookahead(v1, true), var5_5, var6_6));
                    continue block26;
                }
                case 5: {
                    var2_2[2] = var2_2[2] + 1;
                    v2 = var2_2[3];
                    var2_2[3] = v2 + 1;
                    var4_4.append(Term.makeTree(var0, var1_1, var2_2, var3_3, new Lookahead(v2, false), var5_5, var6_6));
                    continue block26;
                }
                case 6: {
                    var2_2[2] = var2_2[2] + 1;
                    v3 = var2_2[3];
                    var2_2[3] = v3 + 1;
                    var4_4.append(Term.makeTree(var0, var1_1, var2_2, var3_3, new Lookbehind(v3, true), var5_5, var6_6));
                    continue block26;
                }
                case 7: {
                    var2_2[2] = var2_2[2] + 1;
                    v4 = var2_2[3];
                    var2_2[3] = v4 + 1;
                    var4_4.append(Term.makeTree(var0, var1_1, var2_2, var3_3, new Lookbehind(v4, false), var5_5, var6_6));
                    continue block26;
                }
                case 8: {
                    var2_2[2] = var2_2[2] + 1;
                    v5 = var2_2[3];
                    var2_2[3] = v5 + 1;
                    var4_4.append(Term.makeTree(var0, var1_1, var2_2, var3_3, new IndependentGroup(v5), var5_5, var6_6));
                    continue block26;
                }
                case 10: {
                    var2_2[2] = var2_2[2] + 1;
                    var0.next();
                    var10_10 = null;
                    var11_12 = true;
                    switch (var0.ttype) {
                        case 5: {
                            var11_12 = false;
                        }
                        case 4: {
                            var2_2[2] = var2_2[2] + 1;
                            v6 = var2_2[3];
                            var2_2[3] = v6 + 1;
                            var12_13 = new Lookahead(v6, var11_12);
                            Term.makeTree(var0, var1_1, var2_2, var3_3, var12_13, var5_5, var6_6);
                            var10_10 = new ConditionalExpr(var12_13);
                            break;
                        }
                        case 7: {
                            var11_12 = false;
                        }
                        case 6: {
                            var2_2[2] = var2_2[2] + 1;
                            v7 = var2_2[3];
                            var2_2[3] = v7 + 1;
                            var13_14 = new Lookbehind(v7, var11_12);
                            Term.makeTree(var0, var1_1, var2_2, var3_3, var13_14, var5_5, var6_6);
                            var10_10 = new ConditionalExpr(var13_14);
                            break;
                        }
                        case 40: {
                            var0.next();
                            if (var0.ttype != 41) {
                                throw new PatternSyntaxException("malformed condition");
                            }
                            if (Character.isDigit(var1_1[var0.tOffset])) {
                                var14_15 = Term.makeNumber(var0.tOffset, var0.tOutside, var1_1);
                            } else {
                                var15_16 = new String(var1_1, var0.tOffset, var0.tOutside - var0.tOffset);
                                var16_17 = (Integer)var6_6.get(var15_16);
                                if (var16_17 == null) {
                                    throw new PatternSyntaxException("unknown group name in conditional expr.: " + var15_16);
                                }
                                var14_15 = var16_17;
                            }
                            var10_10 = new ConditionalExpr(var14_15);
                            break;
                        }
                        default: {
                            throw new PatternSyntaxException("malformed conditional expression: " + var0.ttype + " '" + (char)var0.ttype + "'");
                        }
                    }
                    var4_4.append(Term.makeTree(var0, var1_1, var2_2, var3_3, (Term)var10_10, var5_5, var6_6));
                    continue block26;
                }
                case 124: {
                    var4_4.newBranch();
                    continue block26;
                }
                case 2: {
                    if (var2_2[2] > 0) {
                        throw new PatternSyntaxException("unbalanced parenthesis");
                    }
                    var4_4.close();
                    return var4_4;
                }
                case 41: {
                    if (var2_2[2] <= 0) {
                        throw new PatternSyntaxException("unbalanced parenthesis");
                    }
                    var4_4.close();
                    var2_2[2] = var2_2[2] - 1;
                    return var4_4;
                }
                case 9: {
                    while (true) {
                        if (var0.ttype != 41) ** break;
                        continue block26;
                        var0.next();
                    }
                }
            }
            break;
        }
        throw new PatternSyntaxException("unknown token type: " + var0.ttype);
    }

    static int makeNumber(int n2, int n3, char[] cArray) {
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            int n5 = cArray[i2] - 48;
            if (n5 < 0 || n5 > 9) {
                return -1;
            }
            n4 *= 10;
            n4 += n5;
        }
        return n4;
    }

    protected void append(int n2, int n3, char[] cArray, int[] nArray, int n4, Vector vector, Hashtable hashtable) throws PatternSyntaxException {
        int[] nArray2 = new int[3];
        int n5 = n2;
        Term term = this.current;
        block7: while (n5 < n3) {
            Term term2;
            char c2 = cArray[n5];
            boolean bl2 = true;
            switch (c2) {
                case '*': {
                    if (term == null) {
                        throw new PatternSyntaxException("missing term before *");
                    }
                    if (++n5 < n3 && cArray[n5] == '?') {
                        bl2 ^= true;
                        ++n5;
                    }
                    term2 = bl2 ? Term.makeGreedyStar(nArray, term, vector) : Term.makeLazyStar(nArray, term);
                    term = this.replaceCurrent(term2);
                    continue block7;
                }
                case '+': {
                    if (term == null) {
                        throw new PatternSyntaxException("missing term before +");
                    }
                    if (++n5 < n3 && cArray[n5] == '?') {
                        bl2 ^= true;
                        ++n5;
                    }
                    term2 = bl2 ? Term.makeGreedyPlus(nArray, term, vector) : Term.makeLazyPlus(nArray, term);
                    term = this.replaceCurrent(term2);
                    continue block7;
                }
                case '?': {
                    if (term == null) {
                        throw new PatternSyntaxException("missing term before ?");
                    }
                    if (++n5 < n3 && cArray[n5] == '?') {
                        bl2 ^= true;
                        ++n5;
                    }
                    term2 = bl2 ? Term.makeGreedyQMark(nArray, term) : Term.makeLazyQMark(nArray, term);
                    term = this.replaceCurrent(term2);
                    continue block7;
                }
                case '{': {
                    nArray2[0] = 0;
                    nArray2[1] = -1;
                    int n6 = Term.parseLimits(n5 + 1, n3, cArray, nArray2);
                    if (nArray2[2] == 1) {
                        if (term == null) {
                            throw new PatternSyntaxException("missing term before {}");
                        }
                        n5 = n6;
                        if (n5 < n3 && cArray[n5] == '?') {
                            bl2 ^= true;
                            ++n5;
                        }
                        term2 = bl2 ? Term.makeGreedyLimits(nArray, term, nArray2, vector) : Term.makeLazyLimits(nArray, term, nArray2);
                        term = this.replaceCurrent(term2);
                        continue block7;
                    }
                    if (cArray[n5 + 1] == '\\') {
                        int n7 = n5 + 2;
                        if (n7 == n3) {
                            throw new PatternSyntaxException("'group_id' expected");
                        }
                        while (Character.isWhitespace(cArray[n7])) {
                            if (++n7 != n3) continue;
                            throw new PatternSyntaxException("'group_id' expected");
                        }
                        BackReference backReference = new BackReference(-1, (n4 & 1) > 0);
                        n5 = Term.parseGroupId(cArray, n7, n3, backReference, hashtable);
                        term = this.append(backReference);
                        continue block7;
                    }
                    Term term3 = new Term();
                    n5 = CharacterClass.parseName(cArray, n5, n3, term3, false, (n4 & 8) > 0);
                    term = this.append(term3);
                    continue block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if ((n4 & 8) <= 0) break;
                    ++n5;
                    continue block7;
                }
            }
            term2 = new Term();
            n5 = this.parseTerm(cArray, n5, n3, term2, n4);
            if (term2.type == 19 && n5 < n3) {
                throw new PatternSyntaxException("'$' is not a last term in the group: <" + new String(cArray, n2, n3 - n2) + ">");
            }
            term = this.append(term2);
        }
    }

    private static int parseGroupId(char[] cArray, int n2, int n3, Term term, Hashtable hashtable) throws PatternSyntaxException {
        char c2;
        int n4;
        int n5 = n2;
        if (Character.isDigit(cArray[n2])) {
            while (Character.isDigit(cArray[n2])) {
                if (++n2 != n3) continue;
                throw new PatternSyntaxException("group_id expected");
            }
            n4 = Term.makeNumber(n5, n2, cArray);
        } else {
            while (Character.isJavaIdentifierPart(cArray[n2])) {
                if (++n2 != n3) continue;
                throw new PatternSyntaxException("group_id expected");
            }
            String string = new String(cArray, n5, n2 - n5);
            Integer n6 = (Integer)hashtable.get(string);
            if (n6 == null) {
                throw new PatternSyntaxException("backreference to unknown group: " + string);
            }
            n4 = n6;
        }
        while (Character.isWhitespace(cArray[n2])) {
            if (++n2 != n3) continue;
            throw new PatternSyntaxException("'}' expected");
        }
        if ((c2 = cArray[n2++]) != '}') {
            throw new PatternSyntaxException("'}' expected");
        }
        term.memreg = n4;
        return n2;
    }

    protected Term append(Term term) throws PatternSyntaxException {
        Term term2 = this.current;
        if (term2 == null) {
            this.in.next = term;
            term.prev = this.in;
            this.current = term;
            return term;
        }
        Term.link(term2, term);
        this.current = term;
        return term;
    }

    protected Term replaceCurrent(Term term) throws PatternSyntaxException {
        Term term2 = this.current.prev;
        if (term2 != null) {
            Term term3 = this.in;
            if (term2 == term3) {
                term3.next = term.in;
                term.in.prev = term3;
            } else {
                Term.link(term2, term);
            }
        }
        this.current = term;
        return term;
    }

    protected void newBranch() throws PatternSyntaxException {
        this.close();
        this.startNewBranch();
    }

    protected void close() throws PatternSyntaxException {
        Term term = this.current;
        if (term != null) {
            Term.linkd(term, this.out);
        } else {
            this.in.next = this.out;
        }
    }

    private static final void link(Term term, Term term2) {
        Term.linkd(term, term2.in);
        term2.prev = term;
    }

    private static final void linkd(Term term, Term term2) {
        Term term3;
        Term term4;
        Term term5 = term.out;
        if (term5 != null) {
            term5.next = term2;
        }
        if ((term4 = term.out1) != null) {
            term4.next = term2;
        }
        if ((term3 = term.branchOut) != null) {
            term3.failNext = term2;
        }
    }

    protected void startNewBranch() throws PatternSyntaxException {
        Term term = this.in.next;
        Branch branch = new Branch();
        this.in.next = branch;
        branch.next = term;
        branch.in = null;
        branch.out = null;
        branch.out1 = null;
        branch.branchOut = branch;
        this.current = branch;
    }

    private static final Term makeGreedyStar(int[] nArray, Term term, Vector vector) throws PatternSyntaxException {
        switch (term.type) {
            case 15: {
                Branch branch = new Branch();
                branch.next = term.in;
                term.out.next = branch;
                branch.in = branch;
                branch.out = null;
                branch.out1 = null;
                branch.branchOut = branch;
                return branch;
            }
        }
        Iterator iterator = new Iterator(term, 0, -1, vector);
        return iterator;
    }

    private static final Term makeLazyStar(int[] nArray, Term term) {
        switch (term.type) {
            case 15: {
                Branch branch = new Branch();
                branch.failNext = term.in;
                term.out.next = branch;
                branch.in = branch;
                branch.out = branch;
                branch.out1 = null;
                branch.branchOut = null;
                return branch;
            }
        }
        Branch branch = new Branch();
        branch.failNext = term;
        term.next = branch;
        branch.in = branch;
        branch.out = branch;
        branch.out1 = null;
        branch.branchOut = null;
        return branch;
    }

    private static final Term makeGreedyPlus(int[] nArray, Term term, Vector vector) throws PatternSyntaxException {
        switch (term.type) {
            case 15: 
            case 43: {
                Branch branch = new Branch();
                branch.next = term.in;
                term.out.next = branch;
                branch.in = term.in;
                branch.out = null;
                branch.out1 = null;
                branch.branchOut = branch;
                return branch;
            }
        }
        return new Iterator(term, 1, -1, vector);
    }

    private static final Term makeLazyPlus(int[] nArray, Term term) {
        switch (term.type) {
            case 15: {
                Branch branch = new Branch();
                term.out.next = branch;
                branch.failNext = term.in;
                branch.in = term.in;
                branch.out = branch;
                branch.out1 = null;
                branch.branchOut = null;
                return branch;
            }
        }
        Branch branch = new Branch();
        term.next = branch;
        branch.failNext = term;
        branch.in = term;
        branch.out = branch;
        branch.out1 = null;
        branch.branchOut = null;
        return branch;
    }

    private static final Term makeGreedyQMark(int[] nArray, Term term) {
        switch (term.type) {
            case 15: {
                Branch branch = new Branch();
                branch.next = term.in;
                branch.in = branch;
                branch.out = term.out;
                branch.out1 = null;
                branch.branchOut = branch;
                return branch;
            }
        }
        Branch branch = new Branch();
        branch.next = term;
        branch.in = branch;
        branch.out = term;
        branch.out1 = null;
        branch.branchOut = branch;
        return branch;
    }

    private static final Term makeLazyQMark(int[] nArray, Term term) {
        switch (term.type) {
            case 15: {
                Branch branch = new Branch();
                branch.failNext = term.in;
                branch.in = branch;
                branch.out = branch;
                branch.out1 = term.out;
                branch.branchOut = null;
                return branch;
            }
        }
        Branch branch = new Branch();
        branch.failNext = term;
        branch.in = branch;
        branch.out = branch;
        branch.out1 = term;
        branch.branchOut = null;
        return branch;
    }

    private static final Term makeGreedyLimits(int[] nArray, Term term, int[] nArray2, Vector vector) throws PatternSyntaxException {
        int n2 = nArray2[0];
        int n3 = nArray2[1];
        switch (term.type) {
            case 15: {
                Term term2;
                int n4 = nArray[1];
                nArray[1] = n4 + 1;
                int n5 = n4;
                Term term3 = new Term(29);
                term3.cntreg = n5;
                Term term4 = new Term(32);
                Term term5 = new Term(28);
                term5.cntreg = n5;
                term3.next = term4;
                if (n3 >= 0) {
                    term2 = new Term(30);
                    term2.cntreg = n5;
                    term2.maxCount = n3;
                    term4.next = term2;
                    term2.next = term.in;
                } else {
                    term4.next = term.in;
                }
                term.out.next = term5;
                term5.next = term4;
                if (n2 >= 0) {
                    term2 = new Term(31);
                    term2.cntreg = n5;
                    term2.maxCount = n2;
                    term4.failNext = term2;
                    term3.in = term3;
                    term3.out = term2;
                    term3.out1 = null;
                    term3.branchOut = null;
                } else {
                    term3.in = term3;
                    term3.out = null;
                    term3.out1 = null;
                    term3.branchOut = term4;
                }
                return term3;
            }
        }
        return new Iterator(term, nArray2[0], nArray2[1], vector);
    }

    private static final Term makeLazyLimits(int[] nArray, Term term, int[] nArray2) {
        Term term2;
        int n2 = nArray2[0];
        int n3 = nArray2[1];
        switch (term.type) {
            case 15: {
                Term term3;
                int n4 = nArray[1];
                nArray[1] = n4 + 1;
                int n5 = n4;
                Term term4 = new Term(29);
                term4.cntreg = n5;
                Term term5 = new Term(32);
                Term term6 = new Term(28);
                term6.cntreg = n5;
                term4.next = term5;
                if (n3 >= 0) {
                    term3 = new Term(30);
                    term3.cntreg = n5;
                    term3.maxCount = n3;
                    term5.failNext = term3;
                    term3.next = term.in;
                } else {
                    term5.failNext = term.in;
                }
                term.out.next = term6;
                term6.next = term5;
                if (n2 >= 0) {
                    term3 = new Term(31);
                    term3.cntreg = n5;
                    term3.maxCount = n2;
                    term5.next = term3;
                    term4.in = term4;
                    term4.out = term3;
                    term4.out1 = null;
                    term4.branchOut = null;
                    return term4;
                }
                term4.in = term4;
                term4.out = term5;
                term4.out1 = null;
                term4.branchOut = null;
                return term4;
            }
        }
        Term term7 = new Term(24);
        Branch branch = new Branch(33);
        Term term8 = new Term(25);
        term7.next = branch;
        if (n3 >= 0) {
            term2 = new Term(27);
            term2.maxCount = n3;
            branch.failNext = term2;
            term2.next = term;
            term.next = term8;
            term8.next = branch;
        } else {
            branch.next = term;
            term.next = term8;
            term8.next = term;
        }
        if (n2 >= 0) {
            term2 = new Term(26);
            term2.maxCount = n2;
            branch.next = term2;
            term7.in = term7;
            term7.out = term2;
            term7.out1 = null;
            term7.branchOut = null;
            return term7;
        }
        term7.in = term7;
        term7.out = branch;
        term7.out1 = null;
        term7.branchOut = null;
        return term7;
    }

    private final int parseTerm(char[] cArray, int n2, int n3, Term term, int n4) throws PatternSyntaxException {
        int n5 = cArray[n2++];
        boolean bl2 = false;
        switch (n5) {
            case 91: {
                return CharacterClass.parseClass(cArray, n2, n3, term, (n4 & 1) > 0, (n4 & 8) > 0, (n4 & 0x10) > 0, (n4 & 0x20) > 0);
            }
            case 46: {
                term.type = (n4 & 4) > 0 ? 4 : 5;
                break;
            }
            case 36: {
                term.type = (n4 & 2) > 0 ? 22 : 20;
                break;
            }
            case 94: {
                term.type = (n4 & 2) > 0 ? 21 : 18;
                break;
            }
            case 92: {
                if (n2 >= n3) {
                    throw new PatternSyntaxException("Escape without a character");
                }
                n5 = cArray[n2++];
                switch (n5) {
                    case 102: {
                        n5 = 12;
                        break;
                    }
                    case 110: {
                        n5 = 10;
                        break;
                    }
                    case 114: {
                        n5 = 13;
                        break;
                    }
                    case 116: {
                        n5 = 9;
                        break;
                    }
                    case 117: {
                        n5 = (char)((CharacterClass.toHexDigit(cArray[n2++]) << 12) + (CharacterClass.toHexDigit(cArray[n2++]) << 8) + (CharacterClass.toHexDigit(cArray[n2++]) << 4) + CharacterClass.toHexDigit(cArray[n2++]));
                        break;
                    }
                    case 118: {
                        n5 = (char)((CharacterClass.toHexDigit(cArray[n2++]) << 24) + (CharacterClass.toHexDigit(cArray[n2++]) << 16) + (CharacterClass.toHexDigit(cArray[n2++]) << 12) + (CharacterClass.toHexDigit(cArray[n2++]) << 8) + (CharacterClass.toHexDigit(cArray[n2++]) << 4) + CharacterClass.toHexDigit(cArray[n2++]));
                        break;
                    }
                    case 120: {
                        int n6 = 0;
                        char c2 = cArray[n2++];
                        if (c2 == '{') {
                            while ((c2 = cArray[n2++]) != '}') {
                                if ((n6 = (n6 << 4) + CharacterClass.toHexDigit(c2)) <= 65535) continue;
                                throw new PatternSyntaxException("\\x{<out of range>}");
                            }
                        } else {
                            n6 = (CharacterClass.toHexDigit(c2) << 4) + CharacterClass.toHexDigit(cArray[n2++]);
                        }
                        n5 = (char)n6;
                        break;
                    }
                    case 48: 
                    case 111: {
                        char c3;
                        int n7 = 0;
                        while ((c3 = cArray[n2++]) >= '0' && c3 <= '7') {
                            n7 *= 8;
                            if ((n7 += c3 - 48) <= 65535) continue;
                            break;
                        }
                        n5 = (char)n7;
                        break;
                    }
                    case 109: {
                        char c4;
                        int n8 = 0;
                        while ((c4 = cArray[n2++]) >= '0' && c4 <= '9') {
                            n8 *= 10;
                            if ((n8 += c4 - 48) <= 65535) continue;
                            break;
                        }
                        n5 = (char)n8;
                        break;
                    }
                    case 99: {
                        n5 = (char)(cArray[n2++] & 0x1F);
                        break;
                    }
                    case 68: {
                        bl2 = true;
                    }
                    case 100: {
                        CharacterClass.makeDigit(term, bl2, (n4 & 0x10) > 0);
                        return n2;
                    }
                    case 83: {
                        bl2 = true;
                    }
                    case 115: {
                        CharacterClass.makeSpace(term, bl2, (n4 & 0x10) > 0);
                        return n2;
                    }
                    case 87: {
                        bl2 = true;
                    }
                    case 119: {
                        CharacterClass.makeWordChar(term, bl2, (n4 & 0x10) > 0);
                        return n2;
                    }
                    case 66: {
                        bl2 = true;
                    }
                    case 98: {
                        CharacterClass.makeWordBoundary(term, bl2, (n4 & 0x10) > 0);
                        return n2;
                    }
                    case 60: {
                        CharacterClass.makeWordStart(term, (n4 & 0x10) > 0);
                        return n2;
                    }
                    case 62: {
                        CharacterClass.makeWordEnd(term, (n4 & 0x10) > 0);
                        return n2;
                    }
                    case 65: {
                        term.type = 18;
                        return n2;
                    }
                    case 90: {
                        term.type = 20;
                        return n2;
                    }
                    case 122: {
                        term.type = 19;
                        return n2;
                    }
                    case 71: {
                        term.type = 23;
                        return n2;
                    }
                    case 80: {
                        bl2 = true;
                    }
                    case 112: {
                        n2 = CharacterClass.parseName(cArray, n2, n3, term, bl2, (n4 & 8) > 0);
                        return n2;
                    }
                    default: {
                        if (n5 < 49 || n5 > 57) break;
                        int n9 = n5 - 48;
                        while (n2 < n3 && (n5 = cArray[n2]) >= 48 && n5 <= 57) {
                            n9 = n9 * 10 + n5 - 48;
                            ++n2;
                        }
                        term.type = (n4 & 1) > 0 ? 7 : 6;
                        term.memreg = n9;
                        return n2;
                    }
                }
                term.type = 0;
                term.c = (char)n5;
                break;
            }
            default: {
                if ((n4 & 1) == 0) {
                    term.type = 0;
                    term.c = n5;
                    break;
                }
                CharacterClass.makeICase(term, (char)n5);
            }
        }
        return n2;
    }

    protected static final int parseLimits(int n2, int n3, char[] cArray, int[] nArray) throws PatternSyntaxException {
        if (nArray.length != 3) {
            throw new IllegalArgumentException("maxTimess.length=" + nArray.length + ", should be 2");
        }
        nArray[2] = 1;
        int n4 = 0;
        int n5 = 0;
        block5: while (n2 < n3) {
            char c2 = cArray[n2++];
            switch (c2) {
                case ' ': {
                    continue block5;
                }
                case ',': {
                    if (n4 > 0) {
                        throw new PatternSyntaxException("illegal construction: {.. , , ..}");
                    }
                    nArray[n4++] = n5;
                    n5 = -1;
                    continue block5;
                }
                case '}': {
                    nArray[n4] = n5;
                    if (n4 == 0) {
                        nArray[1] = n5;
                    }
                    return n2;
                }
            }
            if (c2 > '9' || c2 < '0') {
                nArray[2] = 2;
                return n2;
            }
            if (n5 < 0) {
                n5 = 0;
            }
            n5 = n5 * 10 + (c2 - 48);
        }
        throw new PatternSyntaxException("malformed quantifier");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.instanceNum);
        stringBuffer.append(": ");
        if (this.inverse) {
            stringBuffer.append('^');
        }
        switch (this.type) {
            case 17: {
                stringBuffer.append("[]");
                stringBuffer.append(" , ");
                break;
            }
            case 0: {
                stringBuffer.append(CharacterClass.stringValue(this.c));
                stringBuffer.append(" , ");
                break;
            }
            case 4: {
                stringBuffer.append("dotall, ");
                break;
            }
            case 5: {
                stringBuffer.append("dot-eols, ");
                break;
            }
            case 1: {
                stringBuffer.append('[');
                stringBuffer.append(CharacterClass.stringValue0(this.bitset));
                stringBuffer.append(']');
                stringBuffer.append(" , weight=");
                stringBuffer.append(this.weight);
                stringBuffer.append(" , ");
                break;
            }
            case 2: {
                stringBuffer.append('[');
                stringBuffer.append(CharacterClass.stringValue2(this.bitset2));
                stringBuffer.append(']');
                stringBuffer.append(" , weight=");
                stringBuffer.append(this.weight);
                stringBuffer.append(" , ");
                break;
            }
            case 18: {
                stringBuffer.append("abs.start");
                break;
            }
            case 19: {
                stringBuffer.append("abs.end");
                break;
            }
            case 20: {
                stringBuffer.append("abs.end-eol");
                break;
            }
            case 21: {
                stringBuffer.append("line start");
                break;
            }
            case 22: {
                stringBuffer.append("line end");
                break;
            }
            case 23: {
                if (this.inverse) {
                    stringBuffer.append("non-");
                }
                stringBuffer.append("BOUNDARY");
                break;
            }
            case 11: {
                if (this.inverse) {
                    stringBuffer.append("non-");
                }
                stringBuffer.append("BOUNDARY");
                break;
            }
            case 13: {
                if (this.inverse) {
                    stringBuffer.append("non-");
                }
                stringBuffer.append("UBOUNDARY");
                break;
            }
            case 12: {
                stringBuffer.append("DIRECTION");
                break;
            }
            case 14: {
                stringBuffer.append("UDIRECTION");
                break;
            }
            case 8: {
                stringBuffer.append(">>>{");
                stringBuffer.append(this.target);
                stringBuffer.append("}, <<");
                stringBuffer.append(this.distance);
                if (this.eat) {
                    stringBuffer.append(",eat");
                }
                stringBuffer.append(", ");
                break;
            }
            case 45: {
                stringBuffer.append("rpt{");
                stringBuffer.append(this.target);
                stringBuffer.append(",0,inf}");
                if (this.failNext == null) break;
                stringBuffer.append(", =>");
                stringBuffer.append(this.failNext.instanceNum);
                stringBuffer.append(", ");
                break;
            }
            case 46: {
                stringBuffer.append("rpt{");
                stringBuffer.append(this.target);
                stringBuffer.append(",");
                stringBuffer.append(this.minCount);
                stringBuffer.append(",inf}");
                if (this.failNext == null) break;
                stringBuffer.append(", =>");
                stringBuffer.append(this.failNext.instanceNum);
                stringBuffer.append(", ");
                break;
            }
            case 47: {
                stringBuffer.append("rpt{");
                stringBuffer.append(this.target);
                stringBuffer.append(",");
                stringBuffer.append(this.minCount);
                stringBuffer.append(",");
                stringBuffer.append(this.maxCount);
                stringBuffer.append("}");
                if (this.failNext == null) break;
                stringBuffer.append(", =>");
                stringBuffer.append(this.failNext.instanceNum);
                stringBuffer.append(", ");
                break;
            }
            case 48: {
                stringBuffer.append("rpt{$");
                stringBuffer.append(this.memreg);
                stringBuffer.append(',');
                stringBuffer.append(this.minCount);
                stringBuffer.append(",inf}");
                if (this.failNext == null) break;
                stringBuffer.append(", =>");
                stringBuffer.append(this.failNext.instanceNum);
                stringBuffer.append(", ");
                break;
            }
            case 49: {
                stringBuffer.append("rpt{$");
                stringBuffer.append(this.memreg);
                stringBuffer.append(',');
                stringBuffer.append(this.minCount);
                stringBuffer.append(',');
                stringBuffer.append(this.maxCount);
                stringBuffer.append("}");
                if (this.failNext == null) break;
                stringBuffer.append(", =>");
                stringBuffer.append(this.failNext.instanceNum);
                stringBuffer.append(", ");
                break;
            }
            case 50: {
                stringBuffer.append("back(0)");
                break;
            }
            case 51: {
                stringBuffer.append("back(");
                stringBuffer.append(this.minCount);
                stringBuffer.append(")");
                break;
            }
            case 54: {
                stringBuffer.append("back");
                stringBuffer.append("_$");
                stringBuffer.append(this.memreg);
                stringBuffer.append("(");
                stringBuffer.append(this.minCount);
                stringBuffer.append(")");
                break;
            }
            case 15: {
                stringBuffer.append('(');
                if (this.memreg > 0) {
                    stringBuffer.append(this.memreg);
                }
                stringBuffer.append('-');
                stringBuffer.append(" , ");
                break;
            }
            case 16: {
                stringBuffer.append('-');
                if (this.memreg > 0) {
                    stringBuffer.append(this.memreg);
                }
                stringBuffer.append(')');
                stringBuffer.append(" , ");
                break;
            }
            case 35: {
                stringBuffer.append('(');
                stringBuffer.append("=");
                stringBuffer.append(this.lookaheadId);
                stringBuffer.append(" , ");
                break;
            }
            case 36: {
                stringBuffer.append('=');
                stringBuffer.append(this.lookaheadId);
                stringBuffer.append(')');
                stringBuffer.append(" , ");
                break;
            }
            case 37: {
                stringBuffer.append("(!");
                stringBuffer.append(this.lookaheadId);
                stringBuffer.append(" , ");
                if (this.failNext == null) break;
                stringBuffer.append(", =>");
                stringBuffer.append(this.failNext.instanceNum);
                stringBuffer.append(", ");
                break;
            }
            case 38: {
                stringBuffer.append('!');
                stringBuffer.append(this.lookaheadId);
                stringBuffer.append(')');
                stringBuffer.append(" , ");
                break;
            }
            case 39: {
                stringBuffer.append('(');
                stringBuffer.append("<=");
                stringBuffer.append(this.lookaheadId);
                stringBuffer.append(" , dist=");
                stringBuffer.append(this.distance);
                stringBuffer.append(" , ");
                break;
            }
            case 40: {
                stringBuffer.append("<=");
                stringBuffer.append(this.lookaheadId);
                stringBuffer.append(')');
                stringBuffer.append(" , ");
                break;
            }
            case 41: {
                stringBuffer.append("(<!");
                stringBuffer.append(this.lookaheadId);
                stringBuffer.append(" , dist=");
                stringBuffer.append(this.distance);
                stringBuffer.append(" , ");
                if (this.failNext == null) break;
                stringBuffer.append(", =>");
                stringBuffer.append(this.failNext.instanceNum);
                stringBuffer.append(", ");
                break;
            }
            case 42: {
                stringBuffer.append("<!");
                stringBuffer.append(this.lookaheadId);
                stringBuffer.append(')');
                stringBuffer.append(" , ");
                break;
            }
            case 55: {
                stringBuffer.append("(reg");
                stringBuffer.append(this.memreg);
                stringBuffer.append("?)");
                if (this.failNext == null) break;
                stringBuffer.append(", =>");
                stringBuffer.append(this.failNext.instanceNum);
                stringBuffer.append(", ");
                break;
            }
            case 56: {
                stringBuffer.append("(cond");
                stringBuffer.append(this.lookaheadId);
                stringBuffer.append(((Lookahead)this).isPositive ? (char)'=' : '!');
                stringBuffer.append(" , ");
                if (this.failNext == null) break;
                stringBuffer.append(", =>");
                stringBuffer.append(this.failNext.instanceNum);
                stringBuffer.append(", ");
                break;
            }
            case 57: {
                stringBuffer.append("cond");
                stringBuffer.append(this.lookaheadId);
                stringBuffer.append(")");
                if (this.failNext == null) break;
                stringBuffer.append(", =>");
                stringBuffer.append(this.failNext.instanceNum);
                stringBuffer.append(", ");
                break;
            }
            case 6: {
                stringBuffer.append("$");
                stringBuffer.append(this.memreg);
                stringBuffer.append(", ");
                break;
            }
            case 10: {
                stringBuffer.append("END");
                break;
            }
            case 34: {
                stringBuffer.append("(aux1)");
            }
            case 33: {
                stringBuffer.append("(cnt)");
            }
            case 32: {
                stringBuffer.append("=>");
                if (this.failNext != null) {
                    stringBuffer.append(this.failNext.instanceNum);
                } else {
                    stringBuffer.append("null");
                }
                stringBuffer.append(" , ");
                break;
            }
            default: {
                stringBuffer.append('[');
                switch (this.type) {
                    case 24: {
                        stringBuffer.append("cnt=0");
                        break;
                    }
                    case 25: {
                        stringBuffer.append("cnt++");
                        break;
                    }
                    case 26: {
                        stringBuffer.append("cnt>=" + this.maxCount);
                        break;
                    }
                    case 27: {
                        stringBuffer.append("->cnt<" + this.maxCount);
                        break;
                    }
                    case 28: {
                        stringBuffer.append("M(" + this.memreg + ")->,Cr(" + this.cntreg + ")->,Cr(" + this.cntreg + ")++");
                        break;
                    }
                    case 29: {
                        stringBuffer.append("Cr(" + this.cntreg + ")=0");
                        break;
                    }
                    case 30: {
                        stringBuffer.append("Cr(" + this.cntreg + ")<" + this.maxCount);
                        break;
                    }
                    case 31: {
                        stringBuffer.append("Cr(" + this.cntreg + ")>=" + this.maxCount);
                        break;
                    }
                    default: {
                        stringBuffer.append("unknown type: " + this.type);
                    }
                }
                stringBuffer.append("] , ");
            }
        }
        if (this.next != null) {
            stringBuffer.append("->");
            stringBuffer.append(this.next.instanceNum);
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String toStringAll() {
        return this.toStringAll(new Vector());
    }

    public String toStringAll(Vector vector) {
        vector.addElement(new Integer(this.instanceNum));
        String string = this.toString();
        if (this.next != null && !vector.contains(new Integer(this.next.instanceNum))) {
            string = string + "\r\n";
            string = string + this.next.toStringAll(vector);
        }
        if (this.failNext != null && !vector.contains(new Integer(this.failNext.instanceNum))) {
            string = string + "\r\n";
            string = string + this.failNext.toStringAll(vector);
        }
        return string;
    }
}

