/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.codec.language;

import com.contrastsecurity.thirdparty.oa4j.commons.codec.EncoderException;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.StringEncoder;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.language.SoundexUtils;

public class Soundex
implements StringEncoder {
    public static final char SILENT_MARKER = '-';
    public static final String US_ENGLISH_MAPPING_STRING = "01230120022455012623010202";
    private static final char[] US_ENGLISH_MAPPING = "01230120022455012623010202".toCharArray();
    public static final Soundex US_ENGLISH = new Soundex();
    public static final Soundex US_ENGLISH_SIMPLIFIED = new Soundex("01230120022455012623010202", false);
    public static final Soundex US_ENGLISH_GENEALOGY = new Soundex("-123-12--22455-12623-1-2-2");
    @Deprecated
    private int maxLength = 4;
    private final char[] soundexMapping;
    private final boolean specialCaseHW;

    public Soundex() {
        this.soundexMapping = US_ENGLISH_MAPPING;
        this.specialCaseHW = true;
    }

    public Soundex(char[] cArray) {
        this.soundexMapping = new char[cArray.length];
        System.arraycopy(cArray, 0, this.soundexMapping, 0, cArray.length);
        this.specialCaseHW = !this.hasMarker(this.soundexMapping);
    }

    private boolean hasMarker(char[] cArray) {
        for (char c2 : cArray) {
            if (c2 != '-') continue;
            return true;
        }
        return false;
    }

    public Soundex(String string) {
        this.soundexMapping = string.toCharArray();
        this.specialCaseHW = !this.hasMarker(this.soundexMapping);
    }

    public Soundex(String string, boolean bl2) {
        this.soundexMapping = string.toCharArray();
        this.specialCaseHW = bl2;
    }

    public int difference(String string, String string2) throws EncoderException {
        return SoundexUtils.difference(this, string, string2);
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to Soundex encode is not of type java.lang.String");
        }
        return this.soundex((String)object);
    }

    @Override
    public String encode(String string) {
        return this.soundex(string);
    }

    @Deprecated
    public int getMaxLength() {
        return this.maxLength;
    }

    private char map(char c2) {
        int n2 = c2 - 65;
        if (n2 < 0 || n2 >= this.soundexMapping.length) {
            throw new IllegalArgumentException("The character is not mapped: " + c2 + " (index=" + n2 + ")");
        }
        return this.soundexMapping[n2];
    }

    @Deprecated
    public void setMaxLength(int n2) {
        this.maxLength = n2;
    }

    public String soundex(String string) {
        if (string == null) {
            return null;
        }
        if ((string = SoundexUtils.clean(string)).length() == 0) {
            return string;
        }
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 0;
        char c2 = string.charAt(0);
        cArray[n2++] = c2;
        char c3 = this.map(c2);
        for (int i2 = 1; i2 < string.length() && n2 < cArray.length; ++i2) {
            char c4;
            char c5 = string.charAt(i2);
            if (this.specialCaseHW && (c5 == 'H' || c5 == 'W') || (c4 = this.map(c5)) == '-') continue;
            if (c4 != '0' && c4 != c3) {
                cArray[n2++] = c4;
            }
            c3 = c4;
        }
        return new String(cArray);
    }
}

