/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.io.input;

import com.contrastsecurity.thirdparty.oa4j.commons.io.ByteOrderMark;
import com.contrastsecurity.thirdparty.oa4j.commons.io.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class BOMInputStream
extends ProxyInputStream {
    private final boolean include;
    private final List<ByteOrderMark> boms;
    private ByteOrderMark byteOrderMark;
    private int[] firstBytes;
    private int fbLength;
    private int fbIndex;
    private int markFbIndex;
    private boolean markedAtStart;
    private static final Comparator<ByteOrderMark> ByteOrderMarkLengthComparator = new Comparator<ByteOrderMark>(){

        @Override
        public int compare(ByteOrderMark byteOrderMark, ByteOrderMark byteOrderMark2) {
            int n2;
            int n3 = byteOrderMark.length();
            if (n3 > (n2 = byteOrderMark2.length())) {
                return -1;
            }
            if (n2 > n3) {
                return 1;
            }
            return 0;
        }
    };

    public BOMInputStream(InputStream inputStream) {
        this(inputStream, false, ByteOrderMark.UTF_8);
    }

    public BOMInputStream(InputStream inputStream, boolean bl2) {
        this(inputStream, bl2, ByteOrderMark.UTF_8);
    }

    public BOMInputStream(InputStream inputStream, ByteOrderMark ... byteOrderMarkArray) {
        this(inputStream, false, byteOrderMarkArray);
    }

    public BOMInputStream(InputStream inputStream, boolean bl2, ByteOrderMark ... byteOrderMarkArray) {
        super(inputStream);
        if (byteOrderMarkArray == null || byteOrderMarkArray.length == 0) {
            throw new IllegalArgumentException("No BOMs specified");
        }
        this.include = bl2;
        Arrays.sort(byteOrderMarkArray, ByteOrderMarkLengthComparator);
        this.boms = Arrays.asList(byteOrderMarkArray);
    }

    public boolean hasBOM() throws IOException {
        return this.getBOM() != null;
    }

    public boolean hasBOM(ByteOrderMark byteOrderMark) throws IOException {
        if (!this.boms.contains(byteOrderMark)) {
            throw new IllegalArgumentException("Stream not configure to detect " + byteOrderMark);
        }
        return this.byteOrderMark != null && this.getBOM().equals(byteOrderMark);
    }

    public ByteOrderMark getBOM() throws IOException {
        if (this.firstBytes == null) {
            this.fbLength = 0;
            int n2 = this.boms.get(0).length();
            this.firstBytes = new int[n2];
            for (int i2 = 0; i2 < this.firstBytes.length; ++i2) {
                this.firstBytes[i2] = this.in.read();
                ++this.fbLength;
                if (this.firstBytes[i2] < 0) break;
            }
            this.byteOrderMark = this.find();
            if (this.byteOrderMark != null && !this.include) {
                if (this.byteOrderMark.length() < this.firstBytes.length) {
                    this.fbIndex = this.byteOrderMark.length();
                } else {
                    this.fbLength = 0;
                }
            }
        }
        return this.byteOrderMark;
    }

    public String getBOMCharsetName() throws IOException {
        this.getBOM();
        return this.byteOrderMark == null ? null : this.byteOrderMark.getCharsetName();
    }

    private int readFirstBytes() throws IOException {
        this.getBOM();
        return this.fbIndex < this.fbLength ? this.firstBytes[this.fbIndex++] : -1;
    }

    private ByteOrderMark find() {
        for (ByteOrderMark byteOrderMark : this.boms) {
            if (!this.matches(byteOrderMark)) continue;
            return byteOrderMark;
        }
        return null;
    }

    private boolean matches(ByteOrderMark byteOrderMark) {
        for (int i2 = 0; i2 < byteOrderMark.length(); ++i2) {
            if (byteOrderMark.get(i2) == this.firstBytes[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.readFirstBytes();
        return n2 >= 0 ? n2 : this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        while (n3 > 0 && n5 >= 0) {
            n5 = this.readFirstBytes();
            if (n5 < 0) continue;
            byArray[n2++] = (byte)(n5 & 0xFF);
            --n3;
            ++n4;
        }
        int n6 = this.in.read(byArray, n2, n3);
        return n6 < 0 ? (n4 > 0 ? n4 : -1) : n4 + n6;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void mark(int n2) {
        this.markFbIndex = this.fbIndex;
        this.markedAtStart = this.firstBytes == null;
        this.in.mark(n2);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.fbIndex = this.markFbIndex;
        if (this.markedAtStart) {
            this.firstBytes = null;
        }
        this.in.reset();
    }

    @Override
    public long skip(long l2) throws IOException {
        int n2 = 0;
        while (l2 > (long)n2 && this.readFirstBytes() >= 0) {
            ++n2;
        }
        return this.in.skip(l2 - (long)n2) + (long)n2;
    }
}

