/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.lang3;

import com.contrastsecurity.thirdparty.oa4j.commons.lang3.CachedRandomBits;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.RandomUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.exception.UncheckedException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class RandomStringUtils {
    private static final ThreadLocal<SecureRandom> RANDOM = ThreadLocal.withInitial(() -> {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UncheckedException(noSuchAlgorithmException);
        }
    });
    private static final char[] ALPHANUMERICAL_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    static SecureRandom random() {
        return RANDOM.get();
    }

    public static String random(int n2) {
        return RandomStringUtils.random(n2, false, false);
    }

    public static String random(int n2, boolean bl2, boolean bl3) {
        return RandomStringUtils.random(n2, 0, 0, bl2, bl3);
    }

    public static String random(int n2, char ... cArray) {
        if (cArray == null) {
            return RandomStringUtils.random(n2, 0, 0, false, false, null, RandomStringUtils.random());
        }
        return RandomStringUtils.random(n2, 0, cArray.length, false, false, cArray, RandomStringUtils.random());
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        return RandomStringUtils.random(n2, n3, n4, bl2, bl3, null, RandomStringUtils.random());
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3, char ... cArray) {
        return RandomStringUtils.random(n2, n3, n4, bl2, bl3, cArray, RandomStringUtils.random());
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3, char[] cArray, Random random) {
        if (n2 == 0) {
            return "";
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Requested random string length " + n2 + " is less than 0.");
        }
        if (cArray != null && cArray.length == 0) {
            throw new IllegalArgumentException("The chars array must not be empty");
        }
        if (n3 == 0 && n4 == 0) {
            if (cArray != null) {
                n4 = cArray.length;
            } else if (!bl2 && !bl3) {
                n4 = 0x10FFFF;
            } else {
                n4 = 123;
                n3 = 32;
            }
        } else if (n4 <= n3) {
            throw new IllegalArgumentException("Parameter end (" + n4 + ") must be greater than start (" + n3 + ")");
        }
        if (n4 > 0x10FFFF) {
            n4 = 0x10FFFF;
        }
        if (cArray == null && bl2 && bl3 && n3 <= 48 && n4 >= 123) {
            return RandomStringUtils.random(n2, 0, 0, false, false, ALPHANUMERICAL_CHARS, random);
        }
        if (cArray == null) {
            if (bl2 && bl3) {
                n3 = Math.max(48, n3);
                n4 = Math.min(123, n4);
            } else if (bl3) {
                n3 = Math.max(48, n3);
                n4 = Math.min(58, n4);
            } else if (bl2) {
                n3 = Math.max(65, n3);
                n4 = Math.min(123, n4);
            }
        }
        int n5 = 48;
        int n6 = 65;
        if (cArray == null && (bl3 && n4 <= 48 || bl2 && n4 <= 65)) {
            throw new IllegalArgumentException("Parameter end (" + n4 + ") must be greater then (" + 48 + ") for generating digits or greater then (" + 65 + ") for generating letters.");
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n7 = n4 - n3;
        int n8 = 32 - Integer.numberOfLeadingZeros(n7);
        CachedRandomBits cachedRandomBits = new CachedRandomBits((n2 * n8 + 3) / 5 + 10, random);
        block3: while (n2-- != 0) {
            int n9;
            int n10 = cachedRandomBits.nextBits(n8) + n3;
            if (n10 >= n4) {
                ++n2;
                continue;
            }
            if (cArray == null) {
                n9 = n10;
                switch (Character.getType(n9)) {
                    case 0: 
                    case 18: 
                    case 19: {
                        ++n2;
                        continue block3;
                    }
                }
            } else {
                n9 = cArray[n10];
            }
            int n11 = Character.charCount(n9);
            if (n2 == 0 && n11 > 1) {
                ++n2;
                continue;
            }
            if (bl2 && Character.isLetter(n9) || bl3 && Character.isDigit(n9) || !bl2 && !bl3) {
                stringBuilder.appendCodePoint(n9);
                if (n11 != 2) continue;
                --n2;
                continue;
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String random(int n2, String string) {
        if (string == null) {
            return RandomStringUtils.random(n2, 0, 0, false, false, null, RandomStringUtils.random());
        }
        return RandomStringUtils.random(n2, string.toCharArray());
    }

    public static String randomAlphabetic(int n2) {
        return RandomStringUtils.random(n2, true, false);
    }

    public static String randomAlphabetic(int n2, int n3) {
        return RandomStringUtils.randomAlphabetic(RandomUtils.nextInt(n2, n3));
    }

    public static String randomAlphanumeric(int n2) {
        return RandomStringUtils.random(n2, true, true);
    }

    public static String randomAlphanumeric(int n2, int n3) {
        return RandomStringUtils.randomAlphanumeric(RandomUtils.nextInt(n2, n3));
    }

    public static String randomAscii(int n2) {
        return RandomStringUtils.random(n2, 32, 127, false, false);
    }

    public static String randomAscii(int n2, int n3) {
        return RandomStringUtils.randomAscii(RandomUtils.nextInt(n2, n3));
    }

    public static String randomGraph(int n2) {
        return RandomStringUtils.random(n2, 33, 126, false, false);
    }

    public static String randomGraph(int n2, int n3) {
        return RandomStringUtils.randomGraph(RandomUtils.nextInt(n2, n3));
    }

    public static String randomNumeric(int n2) {
        return RandomStringUtils.random(n2, false, true);
    }

    public static String randomNumeric(int n2, int n3) {
        return RandomStringUtils.randomNumeric(RandomUtils.nextInt(n2, n3));
    }

    public static String randomPrint(int n2) {
        return RandomStringUtils.random(n2, 32, 126, false, false);
    }

    public static String randomPrint(int n2, int n3) {
        return RandomStringUtils.randomPrint(RandomUtils.nextInt(n2, n3));
    }

    @Deprecated
    public RandomStringUtils() {
    }
}

