/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public class Range<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> comparator;
    private transient int hashCode;
    private final T maximum;
    private final T minimum;
    private transient String toString;

    @Deprecated
    public static <T extends Comparable<? super T>> Range<T> between(T t2, T t3) {
        return Range.of(t2, t3, null);
    }

    @Deprecated
    public static <T> Range<T> between(T t2, T t3, Comparator<T> comparator) {
        return new Range<T>(t2, t3, comparator);
    }

    public static <T extends Comparable<? super T>> Range<T> is(T t2) {
        return Range.of(t2, t2, null);
    }

    public static <T> Range<T> is(T t2, Comparator<T> comparator) {
        return Range.of(t2, t2, comparator);
    }

    public static <T extends Comparable<? super T>> Range<T> of(T t2, T t3) {
        return Range.of(t2, t3, null);
    }

    public static <T> Range<T> of(T t2, T t3, Comparator<T> comparator) {
        return new Range<T>(t2, t3, comparator);
    }

    Range(T t2, T t3, Comparator<T> comparator) {
        Objects.requireNonNull(t2, "element1");
        Objects.requireNonNull(t3, "element2");
        this.comparator = comparator == null ? ComparableComparator.INSTANCE : comparator;
        if (this.comparator.compare(t2, t3) < 1) {
            this.minimum = t2;
            this.maximum = t3;
        } else {
            this.minimum = t3;
            this.maximum = t2;
        }
    }

    public boolean contains(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.comparator.compare(t2, this.minimum) > -1 && this.comparator.compare(t2, this.maximum) < 1;
    }

    public boolean containsRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.contains(range.minimum) && this.contains(range.maximum);
    }

    public int elementCompareTo(T t2) {
        Objects.requireNonNull(t2, "element");
        if (this.isAfter(t2)) {
            return -1;
        }
        if (this.isBefore(t2)) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Range range = (Range)object;
        return this.minimum.equals(range.minimum) && this.maximum.equals(range.maximum);
    }

    public T fit(T t2) {
        Objects.requireNonNull(t2, "element");
        if (this.isAfter(t2)) {
            return this.minimum;
        }
        if (this.isBefore(t2)) {
            return this.maximum;
        }
        return t2;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public T getMaximum() {
        return this.maximum;
    }

    public T getMinimum() {
        return this.minimum;
    }

    public int hashCode() {
        int n2 = this.hashCode;
        if (this.hashCode == 0) {
            n2 = 17;
            n2 = 37 * n2 + this.getClass().hashCode();
            n2 = 37 * n2 + this.minimum.hashCode();
            this.hashCode = n2 = 37 * n2 + this.maximum.hashCode();
        }
        return n2;
    }

    public Range<T> intersectionWith(Range<T> range) {
        if (!this.isOverlappedBy(range)) {
            throw new IllegalArgumentException(String.format("Cannot calculate intersection with non-overlapping range %s", range));
        }
        if (this.equals(range)) {
            return this;
        }
        T t2 = this.getComparator().compare(this.minimum, range.minimum) < 0 ? range.minimum : this.minimum;
        T t3 = this.getComparator().compare(this.maximum, range.maximum) < 0 ? this.maximum : range.maximum;
        return Range.of(t2, t3, this.getComparator());
    }

    public boolean isAfter(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.comparator.compare(t2, this.minimum) < 0;
    }

    public boolean isAfterRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.isAfter(range.maximum);
    }

    public boolean isBefore(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.comparator.compare(t2, this.maximum) > 0;
    }

    public boolean isBeforeRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.isBefore(range.minimum);
    }

    public boolean isEndedBy(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.comparator.compare(t2, this.maximum) == 0;
    }

    public boolean isNaturalOrdering() {
        return this.comparator == ComparableComparator.INSTANCE;
    }

    public boolean isOverlappedBy(Range<T> range) {
        if (range == null) {
            return false;
        }
        return range.contains(this.minimum) || range.contains(this.maximum) || this.contains(range.minimum);
    }

    public boolean isStartedBy(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.comparator.compare(t2, this.minimum) == 0;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "[" + this.minimum + ".." + this.maximum + "]";
        }
        return this.toString;
    }

    public String toString(String string) {
        return String.format(string, this.minimum, this.maximum, this.comparator);
    }

    private static enum ComparableComparator implements Comparator
    {
        INSTANCE;


        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    }
}

