/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.lang3;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ClassUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ObjectUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;

public class SerializationUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T clone(T t2) {
        if (t2 == null) {
            return null;
        }
        byte[] byArray = SerializationUtils.serialize(t2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Class<T> clazz = ObjectUtils.getClass(t2);
        try {
            T t3;
            ClassLoaderAwareObjectInputStream classLoaderAwareObjectInputStream = new ClassLoaderAwareObjectInputStream(byteArrayInputStream, clazz.getClassLoader());
            try {
                t3 = clazz.cast(classLoaderAwareObjectInputStream.readObject());
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                try {
                    classLoaderAwareObjectInputStream.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Throwables.throwIfCritical(throwable3);
                    Throwable throwable4 = throwable3;
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            classLoaderAwareObjectInputStream.close();
            return t3;
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new SerializationException(String.format("%s while reading cloned object data", exception.getClass().getSimpleName()), exception);
        }
    }

    public static <T> T deserialize(byte[] byArray) {
        Objects.requireNonNull(byArray, "objectData");
        return SerializationUtils.deserialize(new ByteArrayInputStream(byArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        try {
            Object object2;
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            try {
                Object object;
                object2 = object = objectInputStream.readObject();
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                try {
                    objectInputStream.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Throwables.throwIfCritical(throwable3);
                    Throwable throwable4 = throwable3;
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            objectInputStream.close();
            return (T)object2;
        }
        catch (IOException | ClassNotFoundException | NegativeArraySizeException exception) {
            throw new SerializationException(exception);
        }
    }

    public static <T extends Serializable> T roundtrip(T t2) {
        return (T)((Serializable)SerializationUtils.deserialize(SerializationUtils.serialize(t2)));
    }

    public static byte[] serialize(Serializable serializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void serialize(Serializable serializable, OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            try {
                objectOutputStream.writeObject(serializable);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                try {
                    objectOutputStream.close();
                }
                catch (Throwable throwable3) {
                    Throwables.throwIfCritical(throwable3);
                    Throwable throwable4 = throwable3;
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    @Deprecated
    public SerializationUtils() {
    }

    static final class ClassLoaderAwareObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        ClassLoaderAwareObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
            super(inputStream);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            String string = objectStreamClass.getName();
            try {
                return Class.forName(string, false, this.classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    return Class.forName(string, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    Class<?> clazz = ClassUtils.getPrimitiveClass(string);
                    if (clazz != null) {
                        return clazz;
                    }
                    throw classNotFoundException2;
                }
            }
        }
    }
}

