/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.client;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.commons.logging.Log;
import com.contrastsecurity.thirdparty.oa4j.commons.logging.LogFactory;
import com.contrastsecurity.thirdparty.oa4j.http.HttpHost;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequest;
import com.contrastsecurity.thirdparty.oa4j.http.HttpResponse;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.client.HttpClient;
import com.contrastsecurity.thirdparty.oa4j.http.client.ResponseHandler;
import com.contrastsecurity.thirdparty.oa4j.http.client.ServiceUnavailableRetryStrategy;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpUriRequest;
import com.contrastsecurity.thirdparty.oa4j.http.conn.ClientConnectionManager;
import com.contrastsecurity.thirdparty.oa4j.http.impl.client.DefaultHttpClient;
import com.contrastsecurity.thirdparty.oa4j.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import com.contrastsecurity.thirdparty.oa4j.http.params.HttpParams;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import com.contrastsecurity.thirdparty.oa4j.http.util.EntityUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class AutoRetryHttpClient
implements HttpClient {
    private final HttpClient backend;
    private final ServiceUnavailableRetryStrategy retryStrategy;
    private final Log log = LogFactory.getLog(this.getClass());

    public AutoRetryHttpClient(HttpClient httpClient, ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        Args.notNull(httpClient, "HttpClient");
        Args.notNull(serviceUnavailableRetryStrategy, "ServiceUnavailableRetryStrategy");
        this.backend = httpClient;
        this.retryStrategy = serviceUnavailableRetryStrategy;
    }

    public AutoRetryHttpClient() {
        this(new DefaultHttpClient(), new DefaultServiceUnavailableRetryStrategy());
    }

    public AutoRetryHttpClient(ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        this(new DefaultHttpClient(), serviceUnavailableRetryStrategy);
    }

    public AutoRetryHttpClient(HttpClient httpClient) {
        this(httpClient, new DefaultServiceUnavailableRetryStrategy());
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        HttpContext httpContext = null;
        return this.execute(httpHost, httpRequest, httpContext);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(httpHost, httpRequest, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException {
        HttpResponse httpResponse = this.execute(httpHost, httpRequest, httpContext);
        return responseHandler.handleResponse(httpResponse);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException {
        HttpContext httpContext = null;
        return this.execute(httpUriRequest, httpContext);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) throws IOException {
        URI uRI = httpUriRequest.getURI();
        HttpHost httpHost = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
        return this.execute(httpHost, (HttpRequest)httpUriRequest, httpContext);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(httpUriRequest, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException {
        HttpResponse httpResponse = this.execute(httpUriRequest, httpContext);
        return responseHandler.handleResponse(httpResponse);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        int n2 = 1;
        while (true) {
            block8: {
                HttpResponse httpResponse = this.backend.execute(httpHost, httpRequest, httpContext);
                try {
                    if (this.retryStrategy.retryRequest(httpResponse, n2, httpContext)) {
                        EntityUtils.consume(httpResponse.getEntity());
                        long l2 = this.retryStrategy.getRetryInterval();
                        try {
                            this.log.trace("Wait for " + l2);
                            Thread.sleep(l2);
                            break block8;
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                    return httpResponse;
                }
                catch (RuntimeException runtimeException) {
                    Throwables.throwIfCritical(runtimeException);
                    RuntimeException runtimeException2 = runtimeException;
                    try {
                        EntityUtils.consume(httpResponse.getEntity());
                    }
                    catch (IOException iOException) {
                        this.log.warn("I/O error consuming response content", iOException);
                    }
                    throw runtimeException2;
                }
            }
            ++n2;
        }
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    @Override
    public HttpParams getParams() {
        return this.backend.getParams();
    }
}

