/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.client;

import com.contrastsecurity.thirdparty.oa4j.http.HttpHost;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.auth.AuthScope;
import com.contrastsecurity.thirdparty.oa4j.http.auth.Credentials;
import com.contrastsecurity.thirdparty.oa4j.http.auth.NTCredentials;
import com.contrastsecurity.thirdparty.oa4j.http.auth.UsernamePasswordCredentials;
import com.contrastsecurity.thirdparty.oa4j.http.client.CredentialsProvider;
import com.contrastsecurity.thirdparty.oa4j.http.impl.client.BasicCredentialsProvider;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Contract(threading=ThreadingBehavior.SAFE)
public class SystemDefaultCredentialsProvider
implements CredentialsProvider {
    private static final Map<String, String> SCHEME_MAP = new ConcurrentHashMap<String, String>();
    private final BasicCredentialsProvider internal = new BasicCredentialsProvider();

    private static String translateScheme(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SCHEME_MAP.get(string);
        return string2 != null ? string2 : string;
    }

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        this.internal.setCredentials(authScope, credentials);
    }

    private static PasswordAuthentication getSystemCreds(String string, AuthScope authScope, Authenticator.RequestorType requestorType) {
        return Authenticator.requestPasswordAuthentication(authScope.getHost(), null, authScope.getPort(), string, null, SystemDefaultCredentialsProvider.translateScheme(authScope.getScheme()), null, requestorType);
    }

    @Override
    public Credentials getCredentials(AuthScope authScope) {
        Args.notNull(authScope, "Auth scope");
        Credentials credentials = this.internal.getCredentials(authScope);
        if (credentials != null) {
            return credentials;
        }
        String string = authScope.getHost();
        if (string != null) {
            HttpHost httpHost = authScope.getOrigin();
            String string2 = httpHost != null ? httpHost.getSchemeName() : (authScope.getPort() == 443 ? "https" : "http");
            PasswordAuthentication passwordAuthentication = SystemDefaultCredentialsProvider.getSystemCreds(string2, authScope, Authenticator.RequestorType.SERVER);
            if (passwordAuthentication == null) {
                passwordAuthentication = SystemDefaultCredentialsProvider.getSystemCreds(string2, authScope, Authenticator.RequestorType.PROXY);
            }
            if (passwordAuthentication == null && (passwordAuthentication = SystemDefaultCredentialsProvider.getProxyCredentials("http", authScope)) == null) {
                passwordAuthentication = SystemDefaultCredentialsProvider.getProxyCredentials("https", authScope);
            }
            if (passwordAuthentication != null) {
                String string3 = System.getProperty("http.auth.ntlm.domain");
                if (string3 != null) {
                    return new NTCredentials(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()), null, string3);
                }
                return "NTLM".equalsIgnoreCase(authScope.getScheme()) ? new NTCredentials(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()), null, null) : new UsernamePasswordCredentials(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()));
            }
        }
        return null;
    }

    private static PasswordAuthentication getProxyCredentials(String string, AuthScope authScope) {
        String string2 = System.getProperty(string + ".proxyHost");
        if (string2 == null) {
            return null;
        }
        String string3 = System.getProperty(string + ".proxyPort");
        if (string3 == null) {
            return null;
        }
        try {
            AuthScope authScope2 = new AuthScope(string2, Integer.parseInt(string3));
            if (authScope.match(authScope2) >= 0) {
                String string4 = System.getProperty(string + ".proxyUser");
                if (string4 == null) {
                    return null;
                }
                String string5 = System.getProperty(string + ".proxyPassword");
                return new PasswordAuthentication(string4, string5 != null ? string5.toCharArray() : new char[]{});
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void clear() {
        this.internal.clear();
    }

    static {
        SCHEME_MAP.put("Basic".toUpperCase(Locale.ROOT), "Basic");
        SCHEME_MAP.put("Digest".toUpperCase(Locale.ROOT), "Digest");
        SCHEME_MAP.put("NTLM".toUpperCase(Locale.ROOT), "NTLM");
        SCHEME_MAP.put("Negotiate".toUpperCase(Locale.ROOT), "SPNEGO");
        SCHEME_MAP.put("Kerberos".toUpperCase(Locale.ROOT), "Kerberos");
    }
}

