/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.conn;

import com.contrastsecurity.thirdparty.oa4j.http.impl.conn.Wire;
import java.io.IOException;
import java.io.InputStream;

class LoggingInputStream
extends InputStream {
    private final InputStream in;
    private final Wire wire;

    public LoggingInputStream(InputStream inputStream, Wire wire) {
        this.in = inputStream;
        this.wire = wire;
    }

    @Override
    public int read() throws IOException {
        try {
            int n2 = this.in.read();
            if (n2 == -1) {
                this.wire.input("end of stream");
            } else {
                this.wire.input(n2);
            }
            return n2;
        }
        catch (IOException iOException) {
            this.wire.input("[read] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        try {
            int n2 = this.in.read(byArray);
            if (n2 == -1) {
                this.wire.input("end of stream");
            } else if (n2 > 0) {
                this.wire.input(byArray, 0, n2);
            }
            return n2;
        }
        catch (IOException iOException) {
            this.wire.input("[read] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            int n4 = this.in.read(byArray, n2, n3);
            if (n4 == -1) {
                this.wire.input("end of stream");
            } else if (n4 > 0) {
                this.wire.input(byArray, n2, n4);
            }
            return n4;
        }
        catch (IOException iOException) {
            this.wire.input("[read] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        try {
            return super.skip(l2);
        }
        catch (IOException iOException) {
            this.wire.input("[skip] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.in.available();
        }
        catch (IOException iOException) {
            this.wire.input("[available] I/O error : " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public void mark(int n2) {
        super.mark(n2);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            this.wire.input("[close] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }
}

