/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.cookie;

import com.contrastsecurity.thirdparty.oa4j.http.HeaderElement;
import com.contrastsecurity.thirdparty.oa4j.http.NameValuePair;
import com.contrastsecurity.thirdparty.oa4j.http.ParseException;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.message.BasicHeaderElement;
import com.contrastsecurity.thirdparty.oa4j.http.message.BasicNameValuePair;
import com.contrastsecurity.thirdparty.oa4j.http.message.ParserCursor;
import com.contrastsecurity.thirdparty.oa4j.http.message.TokenParser;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import com.contrastsecurity.thirdparty.oa4j.http.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.BitSet;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class NetscapeDraftHeaderParser {
    public static final NetscapeDraftHeaderParser DEFAULT = new NetscapeDraftHeaderParser();
    private static final char PARAM_DELIMITER = ';';
    private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET(61, 59);
    private static final BitSet VALUE_DELIMS = TokenParser.INIT_BITSET(59);
    private final TokenParser tokenParser = TokenParser.INSTANCE;

    public HeaderElement parseHeader(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) throws ParseException {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        NameValuePair nameValuePair = this.parseNameValuePair(charArrayBuffer, parserCursor);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        while (!parserCursor.atEnd()) {
            NameValuePair nameValuePair2 = this.parseNameValuePair(charArrayBuffer, parserCursor);
            arrayList.add(nameValuePair2);
        }
        return new BasicHeaderElement(nameValuePair.getName(), nameValuePair.getValue(), arrayList.toArray(new NameValuePair[arrayList.size()]));
    }

    private NameValuePair parseNameValuePair(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        String string = this.tokenParser.parseToken(charArrayBuffer, parserCursor, TOKEN_DELIMS);
        if (parserCursor.atEnd()) {
            return new BasicNameValuePair(string, null);
        }
        char c2 = charArrayBuffer.charAt(parserCursor.getPos());
        parserCursor.updatePos(parserCursor.getPos() + 1);
        if (c2 != '=') {
            return new BasicNameValuePair(string, null);
        }
        String string2 = this.tokenParser.parseToken(charArrayBuffer, parserCursor, VALUE_DELIMS);
        if (!parserCursor.atEnd()) {
            parserCursor.updatePos(parserCursor.getPos() + 1);
        }
        return new BasicNameValuePair(string, string2);
    }
}

