/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.cookie;

import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CommonCookieAttributeHandler;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.Cookie;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CookieOrigin;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CookieRestrictionViolationException;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.MalformedCookieException;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.SetCookie;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.AbstractCookieAttributeHandler;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (string.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            setCookie.setVersion(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCookieException("Invalid version: " + numberFormatException.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

