/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.cookie;

import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.conn.util.PublicSuffixMatcher;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.Cookie;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CookieOrigin;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CookieSpec;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CookieSpecProvider;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.MalformedCookieException;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.BasicDomainHandler;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.BasicExpiresHandler;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.BasicMaxAgeHandler;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.BasicPathHandler;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.BasicSecureHandler;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.LaxExpiresHandler;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.LaxMaxAgeHandler;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.PublicSuffixDomainFilter;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.RFC6265LaxSpec;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.RFC6265StrictSpec;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RFC6265CookieSpecProvider
implements CookieSpecProvider {
    private final CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private volatile CookieSpec cookieSpec;

    public RFC6265CookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this.compatibilityLevel = compatibilityLevel != null ? compatibilityLevel : CompatibilityLevel.RELAXED;
        this.publicSuffixMatcher = publicSuffixMatcher;
    }

    public RFC6265CookieSpecProvider(PublicSuffixMatcher publicSuffixMatcher) {
        this(CompatibilityLevel.RELAXED, publicSuffixMatcher);
    }

    public RFC6265CookieSpecProvider() {
        this(CompatibilityLevel.RELAXED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CookieSpec create(HttpContext httpContext) {
        if (this.cookieSpec == null) {
            RFC6265CookieSpecProvider rFC6265CookieSpecProvider = this;
            synchronized (rFC6265CookieSpecProvider) {
                if (this.cookieSpec == null) {
                    switch (this.compatibilityLevel) {
                        case STRICT: {
                            this.cookieSpec = new RFC6265StrictSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        case IE_MEDIUM_SECURITY: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(){

                                @Override
                                public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
                                }
                            }, PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        default: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new LaxMaxAgeHandler(), new BasicSecureHandler(), new LaxExpiresHandler());
                        }
                    }
                }
            }
        }
        return this.cookieSpec;
    }

    public static enum CompatibilityLevel {
        STRICT,
        RELAXED,
        IE_MEDIUM_SECURITY;

    }
}

