/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.protocol;

import com.contrastsecurity.thirdparty.oa4j.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequest;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequestInterceptor;
import com.contrastsecurity.thirdparty.oa4j.http.HttpResponse;
import com.contrastsecurity.thirdparty.oa4j.http.HttpResponseInterceptor;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpProcessor;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpRequestInterceptorList;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpResponseInterceptorList;
import java.io.IOException;
import java.util.List;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public final class ImmutableHttpProcessor
implements HttpProcessor {
    private final HttpRequestInterceptor[] requestInterceptors;
    private final HttpResponseInterceptor[] responseInterceptors;

    public ImmutableHttpProcessor(HttpRequestInterceptor[] httpRequestInterceptorArray, HttpResponseInterceptor[] httpResponseInterceptorArray) {
        int n2;
        if (httpRequestInterceptorArray != null) {
            n2 = httpRequestInterceptorArray.length;
            this.requestInterceptors = new HttpRequestInterceptor[n2];
            System.arraycopy(httpRequestInterceptorArray, 0, this.requestInterceptors, 0, n2);
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (httpResponseInterceptorArray != null) {
            n2 = httpResponseInterceptorArray.length;
            this.responseInterceptors = new HttpResponseInterceptor[n2];
            System.arraycopy(httpResponseInterceptorArray, 0, this.responseInterceptors, 0, n2);
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    public ImmutableHttpProcessor(List<HttpRequestInterceptor> list, List<HttpResponseInterceptor> list2) {
        int n2;
        if (list != null) {
            n2 = list.size();
            this.requestInterceptors = list.toArray(new HttpRequestInterceptor[n2]);
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (list2 != null) {
            n2 = list2.size();
            this.responseInterceptors = list2.toArray(new HttpResponseInterceptor[n2]);
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    @Deprecated
    public ImmutableHttpProcessor(HttpRequestInterceptorList httpRequestInterceptorList, HttpResponseInterceptorList httpResponseInterceptorList) {
        int n2;
        int n3;
        if (httpRequestInterceptorList != null) {
            n3 = httpRequestInterceptorList.getRequestInterceptorCount();
            this.requestInterceptors = new HttpRequestInterceptor[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.requestInterceptors[n2] = httpRequestInterceptorList.getRequestInterceptor(n2);
            }
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (httpResponseInterceptorList != null) {
            n3 = httpResponseInterceptorList.getResponseInterceptorCount();
            this.responseInterceptors = new HttpResponseInterceptor[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.responseInterceptors[n2] = httpResponseInterceptorList.getResponseInterceptor(n2);
            }
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    public ImmutableHttpProcessor(HttpRequestInterceptor ... httpRequestInterceptorArray) {
        this(httpRequestInterceptorArray, (HttpResponseInterceptor[])null);
    }

    public ImmutableHttpProcessor(HttpResponseInterceptor ... httpResponseInterceptorArray) {
        this((HttpRequestInterceptor[])null, httpResponseInterceptorArray);
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws IOException, HttpException {
        for (HttpRequestInterceptor httpRequestInterceptor : this.requestInterceptors) {
            httpRequestInterceptor.process(httpRequest, httpContext);
        }
    }

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws IOException, HttpException {
        for (HttpResponseInterceptor httpResponseInterceptor : this.responseInterceptors) {
            httpResponseInterceptor.process(httpResponse, httpContext);
        }
    }
}

