/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.HttpManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.ConfigurationException;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.ssl.SslConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;

public class HttpURLConnectionManager
extends HttpManager {
    private static final Charset CHARSET = Charset.forName("US-ASCII");
    private final URL url;
    private final boolean isHttps;
    private final String method;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final Property[] headers;
    private final SslConfiguration sslConfiguration;
    private final boolean verifyHostname;

    public HttpURLConnectionManager(Configuration configuration, LoggerContext loggerContext, String string, URL uRL, String string2, int n2, int n3, Property[] propertyArray, SslConfiguration sslConfiguration, boolean bl2) {
        super(configuration, loggerContext, string);
        this.url = uRL;
        if (!uRL.getProtocol().equalsIgnoreCase("http") && !uRL.getProtocol().equalsIgnoreCase("https")) {
            throw new ConfigurationException("URL must have scheme http or https");
        }
        this.isHttps = this.url.getProtocol().equalsIgnoreCase("https");
        this.method = Objects.requireNonNull(string2, "method");
        this.connectTimeoutMillis = n2;
        this.readTimeoutMillis = n3;
        this.headers = propertyArray != null ? propertyArray : Property.EMPTY_ARRAY;
        this.sslConfiguration = sslConfiguration;
        if (this.sslConfiguration != null && !this.isHttps) {
            throw new ConfigurationException("SSL configuration can only be specified with URL scheme https");
        }
        this.verifyHostname = bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void send(Layout<?> layout, LogEvent logEvent) throws IOException {
        Object iOException;
        Object object;
        HttpURLConnection httpURLConnection;
        block39: {
            block40: {
                httpURLConnection = (HttpURLConnection)this.url.openConnection();
                httpURLConnection.setAllowUserInteraction(false);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setRequestMethod(this.method);
                if (this.connectTimeoutMillis > 0) {
                    httpURLConnection.setConnectTimeout(this.connectTimeoutMillis);
                }
                if (this.readTimeoutMillis > 0) {
                    httpURLConnection.setReadTimeout(this.readTimeoutMillis);
                }
                if (layout.getContentType() != null) {
                    httpURLConnection.setRequestProperty("Content-Type", layout.getContentType());
                }
                for (Property property : this.headers) {
                    httpURLConnection.setRequestProperty(property.getName(), property.evaluate(this.getConfiguration().getStrSubstitutor()));
                }
                if (this.sslConfiguration != null) {
                    ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.sslConfiguration.getSslSocketFactory());
                }
                if (this.isHttps && !this.verifyHostname) {
                    ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
                }
                byte[] byArray = layout.toByteArray(logEvent);
                httpURLConnection.setFixedLengthStreamingMode(byArray.length);
                httpURLConnection.connect();
                object = httpURLConnection.getOutputStream();
                iOException = null;
                try {
                    ((OutputStream)object).write(byArray);
                    if (object == null) break block39;
                    if (iOException == null) break block40;
                }
                catch (Throwable throwable) {
                    try {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable3 = throwable;
                        iOException = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (object == null) throw throwable4;
                        if (iOException == null) {
                            ((OutputStream)object).close();
                            throw throwable4;
                        }
                        try {
                            ((OutputStream)object).close();
                            throw throwable4;
                        }
                        catch (Throwable throwable2) {
                            Throwables.throwIfCritical(throwable2);
                            Throwable throwable6 = throwable2;
                            ((Throwable)iOException).addSuppressed(throwable6);
                            throw throwable4;
                        }
                    }
                }
                try {
                    ((OutputStream)object).close();
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    ((Throwable)iOException).addSuppressed(throwable2);
                }
                break block39;
            }
            ((OutputStream)object).close();
        }
        object = new byte[1024];
        try {
            block41: {
                iOException = httpURLConnection.getInputStream();
                Throwable throwable = null;
                try {
                    while (-1 != ((InputStream)iOException).read((byte[])object)) {
                    }
                    if (iOException == null) return;
                    if (throwable == null) break block41;
                }
                catch (Throwable throwable3) {
                    try {
                        Throwable throwable10;
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable11 = throwable10 = throwable3;
                        throw throwable10;
                    }
                    catch (Throwable throwable12) {
                        if (iOException == null) throw throwable12;
                        if (throwable == null) {
                            ((InputStream)iOException).close();
                            throw throwable12;
                        }
                        try {
                            ((InputStream)iOException).close();
                            throw throwable12;
                        }
                        catch (Throwable throwable4) {
                            Throwables.throwIfCritical(throwable4);
                            Throwable throwable14 = throwable4;
                            throwable.addSuppressed(throwable14);
                            throw throwable12;
                        }
                    }
                }
                try {
                    ((InputStream)iOException).close();
                    return;
                }
                catch (Throwable throwable5) {
                    Throwables.throwIfCritical(throwable5);
                    Throwable throwable8 = throwable5;
                    throwable.addSuppressed(throwable8);
                    return;
                }
            }
            ((InputStream)iOException).close();
            return;
        }
        catch (IOException iOException2) {
            StringBuilder stringBuilder;
            block42: {
                InputStream inputStream;
                block43: {
                    stringBuilder = new StringBuilder();
                    inputStream = httpURLConnection.getErrorStream();
                    Throwable throwable = null;
                    try {
                        stringBuilder.append(httpURLConnection.getResponseCode());
                        if (httpURLConnection.getResponseMessage() != null) {
                            stringBuilder.append(' ').append(httpURLConnection.getResponseMessage());
                        }
                        if (inputStream != null) {
                            int n2;
                            stringBuilder.append(" - ");
                            while (-1 != (n2 = inputStream.read((byte[])object))) {
                                stringBuilder.append(new String((byte[])object, 0, n2, CHARSET));
                            }
                        }
                        if (inputStream == null) break block42;
                        if (throwable == null) break block43;
                    }
                    catch (Throwable throwable6) {
                        try {
                            Throwable throwable18;
                            Throwables.throwIfCritical(throwable6);
                            throwable = throwable18 = throwable6;
                            throw throwable18;
                        }
                        catch (Throwable throwable19) {
                            if (inputStream == null) throw throwable19;
                            if (throwable == null) {
                                inputStream.close();
                                throw throwable19;
                            }
                            try {
                                inputStream.close();
                                throw throwable19;
                            }
                            catch (Throwable throwable7) {
                                Throwables.throwIfCritical(throwable7);
                                Throwable throwable21 = throwable7;
                                throwable.addSuppressed(throwable21);
                                throw throwable19;
                            }
                        }
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable8) {
                        Throwables.throwIfCritical(throwable8);
                        Throwable throwable16 = throwable8;
                        throwable.addSuppressed(throwable16);
                    }
                    break block42;
                }
                inputStream.close();
            }
            if (httpURLConnection.getResponseCode() <= -1) throw iOException2;
            throw new IOException(stringBuilder.toString());
        }
    }
}

