/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AbstractManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AppenderLoggingException;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.ConfigurationFactoryData;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.OutputStreamManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.FileUtils;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.NullOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class RandomAccessFileManager
extends OutputStreamManager {
    static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final RandomAccessFileManagerFactory FACTORY = new RandomAccessFileManagerFactory();
    private final String advertiseURI;
    private final RandomAccessFile randomAccessFile;

    protected RandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile randomAccessFile, String string, OutputStream outputStream, int n2, String string2, Layout<? extends Serializable> layout, boolean bl2) {
        super(loggerContext, outputStream, string, false, layout, bl2, ByteBuffer.wrap(new byte[n2]));
        this.randomAccessFile = randomAccessFile;
        this.advertiseURI = string2;
    }

    public static RandomAccessFileManager getFileManager(String string, boolean bl2, boolean bl3, int n2, String string2, Layout<? extends Serializable> layout, Configuration configuration) {
        return RandomAccessFileManager.narrow(RandomAccessFileManager.class, RandomAccessFileManager.getManager(string, new FactoryData(bl2, bl3, n2, string2, layout, configuration), FACTORY));
    }

    @Deprecated
    public Boolean isEndOfBatch() {
        return Boolean.FALSE;
    }

    @Deprecated
    public void setEndOfBatch(boolean bl2) {
    }

    @Override
    protected void writeToDestination(byte[] byArray, int n2, int n3) {
        try {
            this.randomAccessFile.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            String string = "Error writing to RandomAccessFile " + this.getName();
            throw new AppenderLoggingException(string, iOException);
        }
    }

    @Override
    public synchronized void flush() {
        this.flushBuffer(this.byteBuffer);
    }

    @Override
    public synchronized boolean closeOutputStream() {
        this.flush();
        try {
            this.randomAccessFile.close();
            return true;
        }
        catch (IOException iOException) {
            this.logError("Unable to close RandomAccessFile", iOException);
            return false;
        }
    }

    public String getFileName() {
        return this.getName();
    }

    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>(super.getContentFormat());
        hashMap.put("fileURI", this.advertiseURI);
        return hashMap;
    }

    private static class RandomAccessFileManagerFactory
    implements ManagerFactory<RandomAccessFileManager, FactoryData> {
        private RandomAccessFileManagerFactory() {
        }

        @Override
        public RandomAccessFileManager createManager(String string, FactoryData factoryData) {
            File file = new File(string);
            if (!factoryData.append) {
                file.delete();
            }
            boolean bl2 = !factoryData.append || !file.exists();
            NullOutputStream nullOutputStream = NullOutputStream.getInstance();
            try {
                FileUtils.makeParentDirs(file);
                RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
                if (factoryData.append) {
                    randomAccessFile.seek(randomAccessFile.length());
                } else {
                    randomAccessFile.setLength(0L);
                }
                return new RandomAccessFileManager(factoryData.getLoggerContext(), randomAccessFile, string, nullOutputStream, factoryData.bufferSize, factoryData.advertiseURI, factoryData.layout, bl2);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                AbstractManager.LOGGER.error("RandomAccessFileManager (" + string + ") " + exception2, (Throwable)exception2);
                return null;
            }
        }
    }

    private static class FactoryData
    extends ConfigurationFactoryData {
        private final boolean append;
        private final boolean immediateFlush;
        private final int bufferSize;
        private final String advertiseURI;
        private final Layout<? extends Serializable> layout;

        public FactoryData(boolean bl2, boolean bl3, int n2, String string, Layout<? extends Serializable> layout, Configuration configuration) {
            super(configuration);
            this.append = bl2;
            this.immediateFlush = bl3;
            this.bufferSize = n2;
            this.advertiseURI = string;
            this.layout = layout;
        }
    }
}

