/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AbstractOutputStreamAppender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.RolloverStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.TriggeringPolicy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.filter.AbstractFilterable;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.Advertiser;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Booleans;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Integers;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

@Plugin(name="RollingRandomAccessFile", category="Core", elementType="appender", printObject=true)
public final class RollingRandomAccessFileAppender
extends AbstractOutputStreamAppender<RollingRandomAccessFileManager> {
    private final String fileName;
    private final String filePattern;
    private final Object advertisement;
    private final Advertiser advertiser;

    private RollingRandomAccessFileAppender(String string, Layout<? extends Serializable> layout, Filter filter, RollingRandomAccessFileManager rollingRandomAccessFileManager, String string2, String string3, boolean bl2, boolean bl3, int n2, Advertiser advertiser, Property[] propertyArray) {
        super(string, layout, filter, bl2, bl3, propertyArray, rollingRandomAccessFileManager);
        if (advertiser != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(layout.getContentFormat());
            hashMap.put("contentType", layout.getContentType());
            hashMap.put("name", string);
            this.advertisement = advertiser.advertise(hashMap);
        } else {
            this.advertisement = null;
        }
        this.fileName = string2;
        this.filePattern = string3;
        this.advertiser = advertiser;
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l2, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    @Override
    public void append(LogEvent logEvent) {
        RollingRandomAccessFileManager rollingRandomAccessFileManager = (RollingRandomAccessFileManager)this.getManager();
        rollingRandomAccessFileManager.checkRollover(logEvent);
        super.append(logEvent);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public int getBufferSize() {
        return ((RollingRandomAccessFileManager)this.getManager()).getBufferSize();
    }

    @Deprecated
    public static <B extends Builder<B>> RollingRandomAccessFileAppender createAppender(String string, String string2, String string3, String string4, String string5, String string6, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, Layout<? extends Serializable> layout, Filter filter, String string7, String string8, String string9, Configuration configuration) {
        boolean bl2 = Booleans.parseBoolean(string3, true);
        boolean bl3 = Booleans.parseBoolean(string7, true);
        boolean bl4 = Booleans.parseBoolean(string5, true);
        boolean bl5 = Boolean.parseBoolean(string8);
        int n2 = Integers.parseInt(string6, 262144);
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((AbstractFilterable.Builder)((Builder)((Builder)((Builder)((AbstractOutputStreamAppender.Builder)((Builder)((Builder)((Builder)RollingRandomAccessFileAppender.newBuilder()).withAdvertise(bl5)).withAdvertiseURI(string9)).withAppend(bl2)).withBufferSize(n2)).setConfiguration(configuration)).withFileName(string)).withFilePattern(string2)).setFilter(filter)).setIgnoreExceptions(bl3)).withImmediateFlush(bl4)).setLayout(layout)).setName(string4)).withPolicy(triggeringPolicy)).withStrategy(rolloverStrategy)).build();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<RollingRandomAccessFileAppender> {
        @PluginBuilderAttribute(value="fileName")
        private String fileName;
        @PluginBuilderAttribute(value="filePattern")
        private String filePattern;
        @PluginBuilderAttribute(value="append")
        private boolean append = true;
        @PluginElement(value="Policy")
        private TriggeringPolicy policy;
        @PluginElement(value="Strategy")
        private RolloverStrategy strategy;
        @PluginBuilderAttribute(value="advertise")
        private boolean advertise;
        @PluginBuilderAttribute(value="advertiseURI")
        private String advertiseURI;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        public Builder() {
            this.withBufferSize(262144);
            this.setIgnoreExceptions(true);
            this.withImmediateFlush(true);
        }

        @Override
        public RollingRandomAccessFileAppender build() {
            int n2;
            String string = this.getName();
            if (string == null) {
                LOGGER.error("No name provided for FileAppender");
                return null;
            }
            if (this.strategy == null) {
                this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build();
            } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
                LOGGER.error("RollingFileAppender '{}': When no file name is provided a DirectFileRolloverStrategy must be configured");
                return null;
            }
            if (this.filePattern == null) {
                LOGGER.error("No filename pattern provided for FileAppender with name " + string);
                return null;
            }
            if (this.policy == null) {
                LOGGER.error("A TriggeringPolicy must be provided");
                return null;
            }
            Layout<Serializable> layout = this.getOrCreateLayout();
            boolean bl2 = this.isImmediateFlush();
            RollingRandomAccessFileManager rollingRandomAccessFileManager = RollingRandomAccessFileManager.getRollingRandomAccessFileManager(this.fileName, this.filePattern, this.append, bl2, n2 = this.getBufferSize(), this.policy, this.strategy, this.advertiseURI, layout, this.filePermissions, this.fileOwner, this.fileGroup, this.getConfiguration());
            if (rollingRandomAccessFileManager == null) {
                return null;
            }
            rollingRandomAccessFileManager.initialize();
            return new RollingRandomAccessFileAppender(string, layout, this.getFilter(), rollingRandomAccessFileManager, this.fileName, this.filePattern, this.isIgnoreExceptions(), bl2, n2, this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }

        public B withFileName(String string) {
            this.fileName = string;
            return (B)((Builder)this.asBuilder());
        }

        public B withFilePattern(String string) {
            this.filePattern = string;
            return (B)((Builder)this.asBuilder());
        }

        public B withAppend(boolean bl2) {
            this.append = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B withPolicy(TriggeringPolicy triggeringPolicy) {
            this.policy = triggeringPolicy;
            return (B)((Builder)this.asBuilder());
        }

        public B withStrategy(RolloverStrategy rolloverStrategy) {
            this.strategy = rolloverStrategy;
            return (B)((Builder)this.asBuilder());
        }

        public B withAdvertise(boolean bl2) {
            this.advertise = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B withAdvertiseURI(String string) {
            this.advertiseURI = string;
            return (B)((Builder)this.asBuilder());
        }

        public B withFilePermissions(String string) {
            this.filePermissions = string;
            return (B)((Builder)this.asBuilder());
        }

        public B withFileOwner(String string) {
            this.fileOwner = string;
            return (B)((Builder)this.asBuilder());
        }

        public B withFileGroup(String string) {
            this.fileGroup = string;
            return (B)((Builder)this.asBuilder());
        }
    }
}

