/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.mom.jeromq;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.LogManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AbstractManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Cancellable;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.ShutdownCallbackRegistry;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.zeromq.ZMQ;

public class JeroMqManager
extends AbstractManager {
    public static final String SYS_PROPERTY_ENABLE_SHUTDOWN_HOOK = "com.contrastsecurity.thirdparty.log4j.jeromq.enableShutdownHook";
    public static final String SYS_PROPERTY_IO_THREADS = "com.contrastsecurity.thirdparty.log4j.jeromq.ioThreads";
    private static final JeroMqManagerFactory FACTORY = new JeroMqManagerFactory();
    private static final ZMQ.Context CONTEXT;
    private static final Cancellable SHUTDOWN_HOOK;
    private final ZMQ.Socket publisher = CONTEXT.socket(1);

    private JeroMqManager(String string, JeroMqConfiguration jeroMqConfiguration) {
        super(null, string);
        this.publisher.setAffinity(jeroMqConfiguration.affinity);
        this.publisher.setBacklog(jeroMqConfiguration.backlog);
        this.publisher.setDelayAttachOnConnect(jeroMqConfiguration.delayAttachOnConnect);
        if (jeroMqConfiguration.identity != null) {
            this.publisher.setIdentity(jeroMqConfiguration.identity);
        }
        this.publisher.setIPv4Only(jeroMqConfiguration.ipv4Only);
        this.publisher.setLinger(jeroMqConfiguration.linger);
        this.publisher.setMaxMsgSize(jeroMqConfiguration.maxMsgSize);
        this.publisher.setRcvHWM(jeroMqConfiguration.rcvHwm);
        this.publisher.setReceiveBufferSize(jeroMqConfiguration.receiveBufferSize);
        this.publisher.setReceiveTimeOut(jeroMqConfiguration.receiveTimeOut);
        this.publisher.setReconnectIVL(jeroMqConfiguration.reconnectIVL);
        this.publisher.setReconnectIVLMax(jeroMqConfiguration.reconnectIVLMax);
        this.publisher.setSendBufferSize(jeroMqConfiguration.sendBufferSize);
        this.publisher.setSendTimeOut(jeroMqConfiguration.sendTimeOut);
        this.publisher.setSndHWM(jeroMqConfiguration.sndHwm);
        this.publisher.setTCPKeepAlive(jeroMqConfiguration.tcpKeepAlive);
        this.publisher.setTCPKeepAliveCount(jeroMqConfiguration.tcpKeepAliveCount);
        this.publisher.setTCPKeepAliveIdle(jeroMqConfiguration.tcpKeepAliveIdle);
        this.publisher.setTCPKeepAliveInterval(jeroMqConfiguration.tcpKeepAliveInterval);
        this.publisher.setXpubVerbose(jeroMqConfiguration.xpubVerbose);
        for (String string2 : jeroMqConfiguration.endpoints) {
            this.publisher.bind(string2);
        }
        LOGGER.debug("Created JeroMqManager with {}", (Object)jeroMqConfiguration);
    }

    public boolean send(byte[] byArray) {
        return this.publisher.send(byArray);
    }

    @Override
    protected boolean releaseSub(long l2, TimeUnit timeUnit) {
        this.publisher.close();
        return true;
    }

    public static JeroMqManager getJeroMqManager(String string, long l2, long l3, boolean bl2, byte[] byArray, boolean bl3, long l4, long l5, long l6, long l7, int n2, long l8, long l9, long l10, int n3, long l11, int n4, long l12, long l13, long l14, boolean bl4, List<String> list) {
        return JeroMqManager.getManager(string, FACTORY, new JeroMqConfiguration(l2, l3, bl2, byArray, bl3, l4, l5, l6, l7, n2, l8, l9, l10, n3, l11, n4, l12, l13, l14, bl4, list));
    }

    public static ZMQ.Context getContext() {
        return CONTEXT;
    }

    static {
        LOGGER.trace("JeroMqManager using ZMQ version {}", (Object)ZMQ.getVersionString());
        int n2 = PropertiesUtil.getProperties().getIntegerProperty(SYS_PROPERTY_IO_THREADS, 1);
        LOGGER.trace("JeroMqManager creating ZMQ context with ioThreads = {}", (Object)n2);
        CONTEXT = ZMQ.context((int)n2);
        boolean bl2 = PropertiesUtil.getProperties().getBooleanProperty(SYS_PROPERTY_ENABLE_SHUTDOWN_HOOK, true);
        SHUTDOWN_HOOK = bl2 && LogManager.getFactory() instanceof ShutdownCallbackRegistry ? ((ShutdownCallbackRegistry)((Object)LogManager.getFactory())).addShutdownCallback(() -> ((ZMQ.Context)CONTEXT).close()) : null;
    }

    private static class JeroMqManagerFactory
    implements ManagerFactory<JeroMqManager, JeroMqConfiguration> {
        private JeroMqManagerFactory() {
        }

        @Override
        public JeroMqManager createManager(String string, JeroMqConfiguration jeroMqConfiguration) {
            return new JeroMqManager(string, jeroMqConfiguration);
        }
    }

    private static class JeroMqConfiguration {
        private final long affinity;
        private final long backlog;
        private final boolean delayAttachOnConnect;
        private final byte[] identity;
        private final boolean ipv4Only;
        private final long linger;
        private final long maxMsgSize;
        private final long rcvHwm;
        private final long receiveBufferSize;
        private final int receiveTimeOut;
        private final long reconnectIVL;
        private final long reconnectIVLMax;
        private final long sendBufferSize;
        private final int sendTimeOut;
        private final long sndHwm;
        private final int tcpKeepAlive;
        private final long tcpKeepAliveCount;
        private final long tcpKeepAliveIdle;
        private final long tcpKeepAliveInterval;
        private final boolean xpubVerbose;
        private final List<String> endpoints;

        private JeroMqConfiguration(long l2, long l3, boolean bl2, byte[] byArray, boolean bl3, long l4, long l5, long l6, long l7, int n2, long l8, long l9, long l10, int n3, long l11, int n4, long l12, long l13, long l14, boolean bl4, List<String> list) {
            this.affinity = l2;
            this.backlog = l3;
            this.delayAttachOnConnect = bl2;
            this.identity = byArray;
            this.ipv4Only = bl3;
            this.linger = l4;
            this.maxMsgSize = l5;
            this.rcvHwm = l6;
            this.receiveBufferSize = l7;
            this.receiveTimeOut = n2;
            this.reconnectIVL = l8;
            this.reconnectIVLMax = l9;
            this.sendBufferSize = l10;
            this.sendTimeOut = n3;
            this.sndHwm = l11;
            this.tcpKeepAlive = n4;
            this.tcpKeepAliveCount = l12;
            this.tcpKeepAliveIdle = l13;
            this.tcpKeepAliveInterval = l14;
            this.xpubVerbose = bl4;
            this.endpoints = list;
        }

        public String toString() {
            return "JeroMqConfiguration{affinity=" + this.affinity + ", backlog=" + this.backlog + ", delayAttachOnConnect=" + this.delayAttachOnConnect + ", identity=" + Arrays.toString(this.identity) + ", ipv4Only=" + this.ipv4Only + ", linger=" + this.linger + ", maxMsgSize=" + this.maxMsgSize + ", rcvHwm=" + this.rcvHwm + ", receiveBufferSize=" + this.receiveBufferSize + ", receiveTimeOut=" + this.receiveTimeOut + ", reconnectIVL=" + this.reconnectIVL + ", reconnectIVLMax=" + this.reconnectIVLMax + ", sendBufferSize=" + this.sendBufferSize + ", sendTimeOut=" + this.sendTimeOut + ", sndHwm=" + this.sndHwm + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpKeepAliveCount=" + this.tcpKeepAliveCount + ", tcpKeepAliveIdle=" + this.tcpKeepAliveIdle + ", tcpKeepAliveInterval=" + this.tcpKeepAliveInterval + ", xpubVerbose=" + this.xpubVerbose + ", endpoints=" + this.endpoints + '}';
        }
    }
}

