/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.mom.kafka;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.AbstractLifeCycle;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.mom.kafka.KafkaManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.SerializedLayout;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

@Plugin(name="Kafka", category="Core", elementType="appender", printObject=true)
public final class KafkaAppender
extends AbstractAppender {
    private static final String[] KAFKA_CLIENT_PACKAGES = new String[]{"com.contrastsecurity.thirdparty.oa4j.kafka.common", "com.contrastsecurity.thirdparty.oa4j.kafka.clients"};
    private final Integer retryCount;
    private final KafkaManager manager;

    @Deprecated
    public static KafkaAppender createAppender(Layout<? extends Serializable> layout, Filter filter, String string, boolean bl2, String string2, Property[] propertyArray, Configuration configuration, String string3) {
        if (layout == null) {
            AbstractLifeCycle.LOGGER.error("No layout provided for KafkaAppender");
            return null;
        }
        KafkaManager kafkaManager = KafkaManager.getManager(configuration.getLoggerContext(), string, string2, true, propertyArray, string3);
        return new KafkaAppender(string, layout, filter, bl2, kafkaManager, null, null);
    }

    private static boolean isRecursive(LogEvent logEvent) {
        return Stream.of(KAFKA_CLIENT_PACKAGES).anyMatch(string -> logEvent.getLoggerName().startsWith((String)string));
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private KafkaAppender(String string, Layout<? extends Serializable> layout, Filter filter, boolean bl2, KafkaManager kafkaManager, Property[] propertyArray, Integer n2) {
        super(string, filter, layout, bl2, propertyArray);
        this.manager = Objects.requireNonNull(kafkaManager, "manager");
        this.retryCount = n2;
    }

    @Override
    public void append(LogEvent logEvent) {
        if (logEvent.getLoggerName() != null && KafkaAppender.isRecursive(logEvent)) {
            LOGGER.warn("Recursive logging from [{}] for appender [{}].", (Object)logEvent.getLoggerName(), (Object)this.getName());
        } else {
            try {
                this.tryAppend(logEvent);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                if (this.retryCount != null) {
                    for (int i2 = 0; i2 < this.retryCount; ++i2) {
                        try {
                            this.tryAppend(logEvent);
                            break;
                        }
                        catch (Exception exception3) {
                            Throwables.throwIfCritical(exception3);
                            Exception exception4 = exception3;
                            continue;
                        }
                    }
                }
                this.error("Unable to write to Kafka in appender [" + this.getName() + "]", logEvent, exception2);
            }
        }
    }

    @Override
    public void start() {
        super.start();
        this.manager.startup();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        boolean bl2 = super.stop(l2, timeUnit, false);
        this.setStopped();
        return bl2 &= this.manager.stop(l2, timeUnit);
    }

    @Override
    public String toString() {
        return "KafkaAppender{name=" + this.getName() + ", state=" + (Object)((Object)this.getState()) + ", topic=" + this.manager.getTopic() + '}';
    }

    private void tryAppend(LogEvent logEvent) throws ExecutionException, InterruptedException, TimeoutException {
        byte[] byArray;
        Layout<? extends Serializable> layout = this.getLayout();
        if (layout instanceof SerializedLayout) {
            byte[] byArray2 = layout.getHeader();
            byte[] byArray3 = layout.toByteArray(logEvent);
            byArray = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
        } else {
            byArray = layout.toByteArray(logEvent);
        }
        this.manager.send(byArray);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<KafkaAppender> {
        @PluginAttribute(value="retryCount")
        private String retryCount;
        @PluginAttribute(value="topic")
        private String topic;
        @PluginAttribute(value="key")
        private String key;
        @PluginAttribute(value="syncSend", defaultBoolean=true)
        private boolean syncSend;

        @Override
        public KafkaAppender build() {
            Layout<Serializable> layout = this.getLayout();
            if (layout == null) {
                LOGGER.error("No layout provided for KafkaAppender");
                return null;
            }
            KafkaManager kafkaManager = KafkaManager.getManager(this.getConfiguration().getLoggerContext(), this.getName(), this.topic, this.syncSend, this.getPropertyArray(), this.key);
            return new KafkaAppender(this.getName(), layout, this.getFilter(), this.isIgnoreExceptions(), kafkaManager, this.getPropertyArray(), this.getRetryCount());
        }

        public Integer getRetryCount() {
            Integer n2 = null;
            try {
                n2 = Integer.valueOf(this.retryCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return n2;
        }

        public String getTopic() {
            return this.topic;
        }

        public boolean isSyncSend() {
            return this.syncSend;
        }

        public B setKey(String string) {
            this.key = string;
            return (B)((Builder)this.asBuilder());
        }

        public B setSyncSend(boolean bl2) {
            this.syncSend = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setTopic(String string) {
            this.topic = string;
            return (B)((Builder)this.asBuilder());
        }
    }
}

