/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rewrite;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Appender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rewrite.RewritePolicy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AppenderControl;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AppenderRef;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Booleans;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Plugin(name="Rewrite", category="Core", elementType="appender", printObject=true)
public final class RewriteAppender
extends AbstractAppender {
    private final Configuration config;
    private final ConcurrentMap<String, AppenderControl> appenders = new ConcurrentHashMap<String, AppenderControl>();
    private final RewritePolicy rewritePolicy;
    private final AppenderRef[] appenderRefs;

    private RewriteAppender(String string, Filter filter, boolean bl2, AppenderRef[] appenderRefArray, RewritePolicy rewritePolicy, Configuration configuration, Property[] propertyArray) {
        super(string, filter, null, bl2, propertyArray);
        this.config = configuration;
        this.rewritePolicy = rewritePolicy;
        this.appenderRefs = appenderRefArray;
    }

    @Override
    public void start() {
        for (AppenderRef appenderRef : this.appenderRefs) {
            String string = appenderRef.getRef();
            Object t2 = this.config.getAppender(string);
            if (t2 != null) {
                Filter filter = t2 instanceof AbstractAppender ? ((AbstractAppender)t2).getFilter() : null;
                this.appenders.put(string, new AppenderControl((Appender)t2, appenderRef.getLevel(), filter));
                continue;
            }
            LOGGER.error("Appender " + appenderRef + " cannot be located. Reference ignored");
        }
        super.start();
    }

    @Override
    public void append(LogEvent logEvent) {
        if (this.rewritePolicy != null) {
            logEvent = this.rewritePolicy.rewrite(logEvent);
        }
        for (AppenderControl appenderControl : this.appenders.values()) {
            appenderControl.callAppender(logEvent);
        }
    }

    @PluginFactory
    public static RewriteAppender createAppender(@PluginAttribute(value="name") String string, @PluginAttribute(value="ignoreExceptions") String string2, @PluginElement(value="AppenderRef") AppenderRef[] appenderRefArray, @PluginConfiguration Configuration configuration, @PluginElement(value="RewritePolicy") RewritePolicy rewritePolicy, @PluginElement(value="Filter") Filter filter) {
        boolean bl2 = Booleans.parseBoolean(string2, true);
        if (string == null) {
            LOGGER.error("No name provided for RewriteAppender");
            return null;
        }
        if (appenderRefArray == null) {
            LOGGER.error("No appender references defined for RewriteAppender");
            return null;
        }
        return new RewriteAppender(string, filter, bl2, appenderRefArray, rewritePolicy, configuration, null);
    }
}

