/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.action;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.action.AbstractAction;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.action.AbstractPathAction;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.action.PathCondition;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.validation.constraints.Required;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.lookup.StrSubstitutor;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.FileUtils;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Set;

@Plugin(name="PosixViewAttribute", category="Core", printObject=true)
public class PosixViewAttributeAction
extends AbstractPathAction {
    private final Set<PosixFilePermission> filePermissions;
    private final String fileOwner;
    private final String fileGroup;

    private PosixViewAttributeAction(String string, boolean bl2, int n2, PathCondition[] pathConditionArray, StrSubstitutor strSubstitutor, Set<PosixFilePermission> set, String string2, String string3) {
        super(string, bl2, n2, pathConditionArray, strSubstitutor);
        this.filePermissions = set;
        this.fileOwner = string2;
        this.fileGroup = string3;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    protected FileVisitor<Path> createFileVisitor(final Path path, final List<PathCondition> list) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                for (PathCondition pathCondition : list) {
                    Path path2;
                    if (pathCondition.accept(path, path2 = path.relativize(path3), basicFileAttributes)) continue;
                    AbstractAction.LOGGER.trace("Not defining POSIX attribute base={}, relative={}", (Object)path, (Object)path2);
                    return FileVisitResult.CONTINUE;
                }
                FileUtils.defineFilePosixAttributeView(path3, PosixViewAttributeAction.this.filePermissions, PosixViewAttributeAction.this.fileOwner, PosixViewAttributeAction.this.fileGroup);
                return FileVisitResult.CONTINUE;
            }
        };
    }

    public Set<PosixFilePermission> getFilePermissions() {
        return this.filePermissions;
    }

    public String getFileOwner() {
        return this.fileOwner;
    }

    public String getFileGroup() {
        return this.fileGroup;
    }

    @Override
    public String toString() {
        return "PosixViewAttributeAction [filePermissions=" + this.filePermissions + ", fileOwner=" + this.fileOwner + ", fileGroup=" + this.fileGroup + ", getBasePath()=" + this.getBasePath() + ", getMaxDepth()=" + this.getMaxDepth() + ", getPathConditions()=" + this.getPathConditions() + "]";
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<PosixViewAttributeAction> {
        @PluginConfiguration
        private Configuration configuration;
        private StrSubstitutor subst;
        @PluginBuilderAttribute
        @Required(message="No base path provided")
        private String basePath;
        @PluginBuilderAttribute
        private boolean followLinks = false;
        @PluginBuilderAttribute
        private int maxDepth = 1;
        @PluginElement(value="PathConditions")
        private PathCondition[] pathConditions;
        @PluginBuilderAttribute(value="filePermissions")
        private String filePermissionsString;
        private Set<PosixFilePermission> filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        @Override
        public PosixViewAttributeAction build() {
            if (Strings.isEmpty(this.basePath)) {
                AbstractAction.LOGGER.error("Posix file attribute view action not valid because base path is empty.");
                return null;
            }
            if (this.filePermissions == null && Strings.isEmpty(this.filePermissionsString) && Strings.isEmpty(this.fileOwner) && Strings.isEmpty(this.fileGroup)) {
                AbstractAction.LOGGER.error("Posix file attribute view not valid because nor permissions, user or group defined.");
                return null;
            }
            if (!FileUtils.isFilePosixAttributeViewSupported()) {
                AbstractAction.LOGGER.warn("Posix file attribute view defined but it is not supported by this files system.");
                return null;
            }
            return new PosixViewAttributeAction(this.basePath, this.followLinks, this.maxDepth, this.pathConditions, this.subst != null ? this.subst : this.configuration.getStrSubstitutor(), this.filePermissions != null ? this.filePermissions : (this.filePermissionsString != null ? PosixFilePermissions.fromString(this.filePermissionsString) : null), this.fileOwner, this.fileGroup);
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder withSubst(StrSubstitutor strSubstitutor) {
            this.subst = strSubstitutor;
            return this;
        }

        public Builder withBasePath(String string) {
            this.basePath = string;
            return this;
        }

        public Builder withFollowLinks(boolean bl2) {
            this.followLinks = bl2;
            return this;
        }

        public Builder withMaxDepth(int n2) {
            this.maxDepth = n2;
            return this;
        }

        public Builder withPathConditions(PathCondition[] pathConditionArray) {
            this.pathConditions = pathConditionArray;
            return this;
        }

        public Builder withFilePermissionsString(String string) {
            this.filePermissionsString = string;
            return this;
        }

        public Builder withFilePermissions(Set<PosixFilePermission> set) {
            this.filePermissions = set;
            return this;
        }

        public Builder withFileOwner(String string) {
            this.fileOwner = string;
            return this;
        }

        public Builder withFileGroup(String string) {
            this.fileGroup = string;
            return this;
        }
    }
}

