/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncQueueFullMessageUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.EventRoute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AppenderRef;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.LoggerConfig;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.validation.constraints.Required;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.jmx.RingBufferAdmin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Booleans;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.AbstractLogger;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Plugin(name="asyncLogger", category="Core", printObject=true)
public class AsyncLoggerConfig
extends LoggerConfig {
    private static final ThreadLocal<Boolean> ASYNC_LOGGER_ENTERED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final AsyncLoggerConfigDelegate delegate;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newAsyncBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    protected AsyncLoggerConfig(String string, List<AppenderRef> list, Filter filter, Level level, boolean bl2, Property[] propertyArray, Configuration configuration, boolean bl3) {
        super(string, list, filter, level, bl2, propertyArray, configuration, bl3);
        this.delegate = configuration.getAsyncLoggerConfigDelegate();
        this.delegate.setLogEventFactory(this.getLogEventFactory());
    }

    AsyncLoggerConfigDelegate getAsyncLoggerConfigDelegate() {
        return this.delegate;
    }

    @Override
    protected void log(LogEvent logEvent, LoggerConfig.LoggerConfigPredicate loggerConfigPredicate) {
        if (loggerConfigPredicate == LoggerConfig.LoggerConfigPredicate.ALL && ASYNC_LOGGER_ENTERED.get() == Boolean.FALSE && this.hasAppenders()) {
            ASYNC_LOGGER_ENTERED.set(Boolean.TRUE);
            try {
                super.log(logEvent, LoggerConfig.LoggerConfigPredicate.SYNCHRONOUS_ONLY);
                this.logToAsyncDelegate(logEvent);
            }
            finally {
                ASYNC_LOGGER_ENTERED.set(Boolean.FALSE);
            }
        } else {
            super.log(logEvent, loggerConfigPredicate);
        }
    }

    @Override
    protected void callAppenders(LogEvent logEvent) {
        super.callAppenders(logEvent);
    }

    private void logToAsyncDelegate(LogEvent logEvent) {
        if (!this.isFiltered(logEvent)) {
            this.populateLazilyInitializedFields(logEvent);
            if (!this.delegate.tryEnqueue(logEvent, this)) {
                this.handleQueueFull(logEvent);
            }
        }
    }

    private void handleQueueFull(LogEvent logEvent) {
        if (AbstractLogger.getRecursionDepth() > 1) {
            AsyncQueueFullMessageUtil.logWarningToStatusLogger();
            this.logToAsyncLoggerConfigsOnCurrentThread(logEvent);
        } else {
            EventRoute eventRoute = this.delegate.getEventRoute(logEvent.getLevel());
            eventRoute.logMessage(this, logEvent);
        }
    }

    private void populateLazilyInitializedFields(LogEvent logEvent) {
        logEvent.getSource();
        logEvent.getThreadName();
    }

    void logInBackgroundThread(LogEvent logEvent) {
        this.delegate.enqueueEvent(logEvent, this);
    }

    void logToAsyncLoggerConfigsOnCurrentThread(LogEvent logEvent) {
        this.log(logEvent, LoggerConfig.LoggerConfigPredicate.ASYNCHRONOUS_ONLY);
    }

    private String displayName() {
        return "".equals(this.getName()) ? "root" : this.getName();
    }

    @Override
    public void start() {
        LOGGER.trace("AsyncLoggerConfig[{}] starting...", (Object)this.displayName());
        super.start();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l2, timeUnit, false);
        LOGGER.trace("AsyncLoggerConfig[{}] stopping...", (Object)this.displayName());
        this.setStopped();
        return true;
    }

    public RingBufferAdmin createRingBufferAdmin(String string) {
        return this.delegate.createRingBufferAdmin(string, this.getName());
    }

    @Deprecated
    public static LoggerConfig createLogger(String string, String string2, String string3, String string4, AppenderRef[] appenderRefArray, Property[] propertyArray, Configuration configuration, Filter filter) {
        Object object;
        Level level;
        if (string3 == null) {
            LOGGER.error("Loggers cannot be configured without a name");
            return null;
        }
        List<AppenderRef> list = Arrays.asList(appenderRefArray);
        try {
            level = Level.toLevel(string2, Level.ERROR);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            object = exception;
            LOGGER.error("Invalid Log level specified: {}. Defaulting to Error", (Object)string2);
            level = Level.ERROR;
        }
        object = string3.equals("root") ? "" : string3;
        boolean bl2 = Booleans.parseBoolean(string, true);
        return new AsyncLoggerConfig((String)object, list, filter, level, bl2, propertyArray, configuration, AsyncLoggerConfig.includeLocation(string4));
    }

    @Deprecated
    public static LoggerConfig createLogger(@PluginAttribute(value="additivity", defaultBoolean=true) boolean bl2, @PluginAttribute(value="level") Level level, @Required(message="Loggers cannot be configured without a name") @PluginAttribute(value="name") String string, @PluginAttribute(value="includeLocation") String string2, @PluginElement(value="AppenderRef") AppenderRef[] appenderRefArray, @PluginElement(value="Properties") Property[] propertyArray, @PluginConfiguration Configuration configuration, @PluginElement(value="Filter") Filter filter) {
        String string3 = string.equals("root") ? "" : string;
        return new AsyncLoggerConfig(string3, Arrays.asList(appenderRefArray), filter, level, bl2, propertyArray, configuration, AsyncLoggerConfig.includeLocation(string2));
    }

    protected static boolean includeLocation(String string) {
        return Boolean.parseBoolean(string);
    }

    @Plugin(name="asyncRoot", category="Core", printObject=true)
    public static class RootLogger
    extends LoggerConfig {
        @PluginBuilderFactory
        public static <B extends Builder<B>> B newAsyncRootBuilder() {
            return (B)((Builder)new Builder().asBuilder());
        }

        @Deprecated
        public static LoggerConfig createLogger(String string, String string2, String string3, AppenderRef[] appenderRefArray, Property[] propertyArray, Configuration configuration, Filter filter) {
            List<AppenderRef> list = Arrays.asList(appenderRefArray);
            Level level = null;
            try {
                level = Level.toLevel(string2, Level.ERROR);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                LOGGER.error("Invalid Log level specified: {}. Defaulting to Error", (Object)string2);
                level = Level.ERROR;
            }
            boolean bl2 = Booleans.parseBoolean(string, true);
            return new AsyncLoggerConfig("", list, filter, level, bl2, propertyArray, configuration, AsyncLoggerConfig.includeLocation(string3));
        }

        @Deprecated
        public static LoggerConfig createLogger(@PluginAttribute(value="additivity") String string, @PluginAttribute(value="level") Level level, @PluginAttribute(value="includeLocation") String string2, @PluginElement(value="AppenderRef") AppenderRef[] appenderRefArray, @PluginElement(value="Properties") Property[] propertyArray, @PluginConfiguration Configuration configuration, @PluginElement(value="Filter") Filter filter) {
            List<AppenderRef> list = Arrays.asList(appenderRefArray);
            Level level2 = level == null ? Level.ERROR : level;
            boolean bl2 = Booleans.parseBoolean(string, true);
            return new AsyncLoggerConfig("", list, filter, level2, bl2, propertyArray, configuration, AsyncLoggerConfig.includeLocation(string2));
        }

        public static class Builder<B extends Builder<B>>
        extends LoggerConfig.RootLogger.Builder<B> {
            @Override
            public LoggerConfig build() {
                LoggerConfig.LevelAndRefs levelAndRefs = RootLogger.getLevelAndRefs(this.getLevel(), this.getRefs(), this.getLevelAndRefs(), this.getConfig());
                return new AsyncLoggerConfig("", levelAndRefs.refs, this.getFilter(), levelAndRefs.level, this.isAdditivity(), this.getProperties(), this.getConfig(), RootLogger.includeLocation(this.getIncludeLocation()));
            }
        }
    }

    public static class Builder<B extends Builder<B>>
    extends LoggerConfig.Builder<B> {
        @Override
        public LoggerConfig build() {
            String string = this.getLoggerName().equals("root") ? "" : this.getLoggerName();
            LoggerConfig.LevelAndRefs levelAndRefs = AsyncLoggerConfig.getLevelAndRefs(this.getLevel(), this.getRefs(), this.getLevelAndRefs(), this.getConfig());
            return new AsyncLoggerConfig(string, levelAndRefs.refs, this.getFilter(), levelAndRefs.level, this.isAdditivity(), this.getProperties(), this.getConfig(), AsyncLoggerConfig.includeLocation(this.getIncludeLocation()));
        }
    }
}

