/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AwaitCompletionReliabilityStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AwaitUnconditionallyReliabilityStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.LockingReliabilityStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.LoggerConfig;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.ReliabilityStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesUtil;

public final class ReliabilityStrategyFactory {
    private ReliabilityStrategyFactory() {
    }

    public static ReliabilityStrategy getReliabilityStrategy(LoggerConfig loggerConfig) {
        String string = PropertiesUtil.getProperties().getStringProperty("com.contrastsecurity.thirdparty.log4j.ReliabilityStrategy", "AwaitCompletion");
        if ("AwaitCompletion".equals(string)) {
            return new AwaitCompletionReliabilityStrategy(loggerConfig);
        }
        if ("AwaitUnconditionally".equals(string)) {
            return new AwaitUnconditionallyReliabilityStrategy(loggerConfig);
        }
        if ("Locking".equals(string)) {
            return new LockingReliabilityStrategy(loggerConfig);
        }
        try {
            Class<ReliabilityStrategy> clazz = Loader.loadClass(string).asSubclass(ReliabilityStrategy.class);
            return clazz.getConstructor(LoggerConfig.class).newInstance(loggerConfig);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            StatusLogger.getLogger().warn("Could not create ReliabilityStrategy for '{}', using default AwaitCompletionReliabilityStrategy: {}", (Object)string, (Object)exception2);
            return new AwaitCompletionReliabilityStrategy(loggerConfig);
        }
    }
}

