/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.arbiters;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AbstractConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Node;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.arbiters.Arbiter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginNode;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.util.PluginType;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.script.AbstractScript;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.script.ScriptRef;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import java.util.Map;
import javax.script.SimpleBindings;

@Plugin(name="ScriptArbiter", category="Core", elementType="Arbiter", deferChildren=true, printObject=true)
public class ScriptArbiter
implements Arbiter {
    private final AbstractScript script;
    private final Configuration configuration;

    private ScriptArbiter(Configuration configuration, AbstractScript abstractScript) {
        this.configuration = configuration;
        this.script = abstractScript;
    }

    @Override
    public boolean isCondition() {
        SimpleBindings simpleBindings = new SimpleBindings();
        simpleBindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        simpleBindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), simpleBindings);
        return Boolean.parseBoolean(object.toString());
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<ScriptArbiter> {
        private static final Logger LOGGER = StatusLogger.getLogger();
        @PluginConfiguration
        private AbstractConfiguration configuration;
        @PluginNode
        private Node node;

        public Builder setConfiguration(AbstractConfiguration abstractConfiguration) {
            this.configuration = abstractConfiguration;
            return this.asBuilder();
        }

        public Builder setNode(Node node) {
            this.node = node;
            return this.asBuilder();
        }

        public Builder asBuilder() {
            return this;
        }

        @Override
        public ScriptArbiter build() {
            AbstractScript abstractScript = null;
            for (Node node : this.node.getChildren()) {
                PluginType<?> pluginType = node.getType();
                if (pluginType == null) {
                    LOGGER.error("Node {} is missing a Plugintype", (Object)node.getName());
                    continue;
                }
                if (!AbstractScript.class.isAssignableFrom(pluginType.getPluginClass())) continue;
                abstractScript = (AbstractScript)this.configuration.createPluginObject(pluginType, node);
                this.node.getChildren().remove(node);
                break;
            }
            if (abstractScript == null) {
                LOGGER.error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptFilter");
                return null;
            }
            if (this.configuration.getScriptManager() == null) {
                LOGGER.error("Script support is not enabled");
                return null;
            }
            if (abstractScript instanceof ScriptRef) {
                if (this.configuration.getScriptManager().getScript(abstractScript.getName()) == null) {
                    LOGGER.error("No script with name {} has been declared.", (Object)abstractScript.getName());
                    return null;
                }
            } else if (!this.configuration.getScriptManager().addScript(abstractScript)) {
                return null;
            }
            return new ScriptArbiter(this.configuration, abstractScript);
        }
    }
}

