/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.json;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.cfx.jackson.core.JsonParser;
import com.contrastsecurity.thirdparty.cfx.jackson.databind.JsonNode;
import com.contrastsecurity.thirdparty.cfx.jackson.databind.ObjectMapper;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AbstractConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.ConfigurationSource;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Node;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Reconfigurable;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.util.PluginType;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.util.ResolverUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.status.StatusConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Patterns;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonConfiguration
extends AbstractConfiguration
implements Reconfigurable {
    private static final String[] VERBOSE_CLASSES = new String[]{ResolverUtil.class.getName()};
    private final List<Status> status = new ArrayList<Status>();
    private JsonNode root;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonConfiguration(LoggerContext loggerContext, ConfigurationSource configurationSource) {
        super(loggerContext, configurationSource);
        File file = configurationSource.getFile();
        try {
            byte[] byArray;
            Object object;
            InputStream inputStream;
            block23: {
                block24: {
                    inputStream = configurationSource.getInputStream();
                    object = null;
                    try {
                        byArray = JsonConfiguration.toByteArray(inputStream);
                        if (inputStream == null) break block23;
                        if (object == null) break block24;
                    }
                    catch (Throwable throwable) {
                        try {
                            Throwables.throwIfCritical(throwable);
                            Throwable throwable3 = throwable;
                            object = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (inputStream == null) throw throwable4;
                            if (object == null) {
                                inputStream.close();
                                throw throwable4;
                            }
                            try {
                                inputStream.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable2) {
                                Throwables.throwIfCritical(throwable2);
                                Throwable throwable6 = throwable2;
                                ((Throwable)object).addSuppressed(throwable6);
                                throw throwable4;
                            }
                        }
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable2 = throwable;
                        ((Throwable)object).addSuppressed(throwable2);
                    }
                    break block23;
                }
                inputStream.close();
            }
            inputStream = new ByteArrayInputStream(byArray);
            this.root = this.getObjectMapper().readTree(inputStream);
            if (this.root.size() == 1) {
                for (Throwable throwable2 : this.root) {
                    this.root = throwable2;
                }
            }
            this.processAttributes(this.rootNode, this.root);
            object = new StatusConfiguration().withVerboseClasses(VERBOSE_CLASSES).withStatus(this.getDefaultStatus());
            int n2 = 0;
            Iterator<Map.Entry<String, String>> iterator = this.rootNode.getAttributes().entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.initializeWatchers(this, configurationSource, n2);
                    ((StatusConfiguration)object).initialize();
                    if (this.getName() != null) return;
                    this.setName(configurationSource.getLocation());
                    return;
                }
                Map.Entry<String, String> entry = iterator.next();
                String string = entry.getKey();
                String string2 = this.getConfigurationStrSubstitutor().replace(entry.getValue());
                if ("status".equalsIgnoreCase(string)) {
                    ((StatusConfiguration)object).withStatus(string2);
                    continue;
                }
                if ("dest".equalsIgnoreCase(string)) {
                    ((StatusConfiguration)object).withDestination(string2);
                    continue;
                }
                if ("shutdownHook".equalsIgnoreCase(string)) {
                    this.isShutdownHookEnabled = !"disable".equalsIgnoreCase(string2);
                    continue;
                }
                if ("shutdownTimeout".equalsIgnoreCase(string)) {
                    this.shutdownTimeoutMillis = Long.parseLong(string2);
                    continue;
                }
                if ("verbose".equalsIgnoreCase(entry.getKey())) {
                    ((StatusConfiguration)object).withVerbosity(string2);
                    continue;
                }
                if ("packages".equalsIgnoreCase(string)) {
                    this.pluginPackages.addAll(Arrays.asList(string2.split(Patterns.COMMA_SEPARATOR)));
                    continue;
                }
                if ("name".equalsIgnoreCase(string)) {
                    this.setName(string2);
                    continue;
                }
                if ("monitorInterval".equalsIgnoreCase(string)) {
                    n2 = Integers.parseInt(string2);
                    continue;
                }
                if (!"advertiser".equalsIgnoreCase(string)) continue;
                this.createAdvertiser(string2, configurationSource, byArray, "application/json");
            }
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.error("Error parsing " + configurationSource.getLocation(), (Throwable)exception2);
        }
    }

    protected ObjectMapper getObjectMapper() {
        return new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }

    @Override
    public void setup() {
        Iterator iterator = this.root.fields();
        List<Node> list = this.rootNode.getChildren();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            JsonNode object = (JsonNode)entry.getValue();
            if (object.isObject()) {
                LOGGER.debug("Processing node for object {}", entry.getKey());
                list.add(this.constructNode((String)entry.getKey(), this.rootNode, object));
                continue;
            }
            if (!object.isArray()) continue;
            LOGGER.error("Arrays are not supported at the root configuration.");
        }
        LOGGER.debug("Completed parsing configuration");
        if (this.status.size() > 0) {
            for (Status status : this.status) {
                LOGGER.error("Error processing element {}: {}", (Object)status.name, (Object)status.errorType);
            }
        }
    }

    @Override
    public Configuration reconfigure() {
        try {
            ConfigurationSource configurationSource = this.getConfigurationSource().resetInputStream();
            if (configurationSource == null) {
                return null;
            }
            return new JsonConfiguration(this.getLoggerContext(), configurationSource);
        }
        catch (IOException iOException) {
            LOGGER.error("Cannot locate file {}", (Object)this.getConfigurationSource(), (Object)iOException);
            return null;
        }
    }

    private Node constructNode(String string, Node node, JsonNode jsonNode) {
        Object object;
        Object object2;
        PluginType<?> pluginType = this.pluginManager.getPluginType(string);
        Node node2 = new Node(node, string, pluginType);
        this.processAttributes(node2, jsonNode);
        Iterator iterator = jsonNode.fields();
        List<Node> list = node2.getChildren();
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            object = (JsonNode)object2.getValue();
            if (object.isArray() || object.isObject()) {
                if (pluginType == null) {
                    this.status.add(new Status(string, (JsonNode)object, ErrorType.CLASS_NOT_FOUND));
                }
                if (object.isArray()) {
                    LOGGER.debug("Processing node for array {}", object2.getKey());
                    for (int i2 = 0; i2 < object.size(); ++i2) {
                        String string2 = this.getType(object.get(i2), (String)object2.getKey());
                        PluginType<?> pluginType2 = this.pluginManager.getPluginType(string2);
                        Node node3 = new Node(node2, (String)object2.getKey(), pluginType2);
                        this.processAttributes(node3, object.get(i2));
                        if (string2.equals(object2.getKey())) {
                            LOGGER.debug("Processing {}[{}]", object2.getKey(), (Object)i2);
                        } else {
                            LOGGER.debug("Processing {} {}[{}]", (Object)string2, object2.getKey(), (Object)i2);
                        }
                        Iterator iterator2 = object.get(i2).fields();
                        List<Node> list2 = node3.getChildren();
                        while (iterator2.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator2.next();
                            if (((JsonNode)entry.getValue()).isObject()) {
                                LOGGER.debug("Processing node for object {}", entry.getKey());
                                list2.add(this.constructNode((String)entry.getKey(), node3, (JsonNode)entry.getValue()));
                                continue;
                            }
                            if (!((JsonNode)entry.getValue()).isArray()) continue;
                            JsonNode jsonNode2 = (JsonNode)entry.getValue();
                            String string3 = (String)entry.getKey();
                            LOGGER.debug("Processing array for object {}", (Object)string3);
                            for (int i3 = 0; i3 < jsonNode2.size(); ++i3) {
                                list2.add(this.constructNode(string3, node3, jsonNode2.get(i3)));
                            }
                        }
                        list.add(node3);
                    }
                    continue;
                }
                LOGGER.debug("Processing node for object {}", object2.getKey());
                list.add(this.constructNode((String)object2.getKey(), node2, (JsonNode)object));
                continue;
            }
            LOGGER.debug("Node {} is of type {}", object2.getKey(), (Object)object.getNodeType());
        }
        object2 = pluginType == null ? "null" : pluginType.getElementName() + ':' + pluginType.getPluginClass();
        object = node2.getParent() == null ? "null" : (node2.getParent().getName() == null ? "root" : node2.getParent().getName());
        LOGGER.debug("Returning {} with parent {} of type {}", (Object)node2.getName(), object, object2);
        return node2;
    }

    private String getType(JsonNode jsonNode, String string) {
        Iterator iterator = jsonNode.fields();
        while (iterator.hasNext()) {
            JsonNode jsonNode2;
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!((String)entry.getKey()).equalsIgnoreCase("type") || !(jsonNode2 = (JsonNode)entry.getValue()).isValueNode()) continue;
            return jsonNode2.asText();
        }
        return string;
    }

    private void processAttributes(Node node, JsonNode jsonNode) {
        Map<String, String> map = node.getAttributes();
        Iterator iterator = jsonNode.fields();
        while (iterator.hasNext()) {
            JsonNode jsonNode2;
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((String)entry.getKey()).equalsIgnoreCase("type") || !(jsonNode2 = (JsonNode)entry.getValue()).isValueNode()) continue;
            map.put((String)entry.getKey(), jsonNode2.asText());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[location=" + this.getConfigurationSource() + "]";
    }

    private static class Status {
        private final JsonNode node;
        private final String name;
        private final ErrorType errorType;

        public Status(String string, JsonNode jsonNode, ErrorType errorType) {
            this.name = string;
            this.node = jsonNode;
            this.errorType = errorType;
        }

        public String toString() {
            return "Status [name=" + this.name + ", errorType=" + (Object)((Object)this.errorType) + ", node=" + this.node + "]";
        }
    }

    private static enum ErrorType {
        CLASS_NOT_FOUND;

    }
}

