/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.processor;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.processor.PluginEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;

public class PluginCache {
    private final Map<String, Map<String, PluginEntry>> categories = new TreeMap<String, Map<String, PluginEntry>>();

    public Map<String, Map<String, PluginEntry>> getAllCategories() {
        return this.categories;
    }

    public Map<String, PluginEntry> getCategory(String string2) {
        String string3 = string2.toLowerCase();
        return this.categories.computeIfAbsent(string3, string -> new TreeMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeCache(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream;
        block11: {
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
            Throwable throwable = null;
            try {
                dataOutputStream.writeInt(this.categories.size());
                for (Map.Entry<String, Map<String, PluginEntry>> entry : this.categories.entrySet()) {
                    dataOutputStream.writeUTF(entry.getKey());
                    Map<String, PluginEntry> map = entry.getValue();
                    dataOutputStream.writeInt(map.size());
                    for (Map.Entry<String, PluginEntry> entry2 : map.entrySet()) {
                        PluginEntry pluginEntry = entry2.getValue();
                        dataOutputStream.writeUTF(pluginEntry.getKey());
                        dataOutputStream.writeUTF(pluginEntry.getClassName());
                        dataOutputStream.writeUTF(pluginEntry.getName());
                        dataOutputStream.writeBoolean(pluginEntry.isPrintable());
                        dataOutputStream.writeBoolean(pluginEntry.isDefer());
                    }
                }
                if (dataOutputStream == null) return;
                if (throwable == null) break block11;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable5;
                    Throwables.throwIfCritical(throwable2);
                    throwable = throwable5 = throwable2;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (dataOutputStream == null) throw throwable6;
                    if (throwable == null) {
                        dataOutputStream.close();
                        throw throwable6;
                    }
                    try {
                        dataOutputStream.close();
                        throw throwable6;
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable8 = throwable3;
                        throwable.addSuppressed(throwable8);
                        throw throwable6;
                    }
                }
            }
            try {
                dataOutputStream.close();
                return;
            }
            catch (Throwable throwable4) {
                Throwables.throwIfCritical(throwable4);
                Throwable throwable3 = throwable4;
                throwable.addSuppressed(throwable3);
                return;
            }
        }
        dataOutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadCacheFiles(Enumeration<URL> enumeration) throws IOException {
        this.categories.clear();
        while (enumeration.hasMoreElements()) {
            DataInputStream dataInputStream;
            block12: {
                URL uRL = enumeration.nextElement();
                dataInputStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
                Throwable throwable = null;
                try {
                    int n2 = dataInputStream.readInt();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = dataInputStream.readUTF();
                        Map<String, PluginEntry> map = this.getCategory(string);
                        int n3 = dataInputStream.readInt();
                        for (int i3 = 0; i3 < n3; ++i3) {
                            String string2 = dataInputStream.readUTF();
                            String string3 = dataInputStream.readUTF();
                            String string5 = dataInputStream.readUTF();
                            boolean bl2 = dataInputStream.readBoolean();
                            boolean bl3 = dataInputStream.readBoolean();
                            map.computeIfAbsent(string2, string4 -> {
                                PluginEntry pluginEntry = new PluginEntry();
                                pluginEntry.setKey((String)string4);
                                pluginEntry.setClassName(string3);
                                pluginEntry.setName(string5);
                                pluginEntry.setPrintable(bl2);
                                pluginEntry.setDefer(bl3);
                                pluginEntry.setCategory(string);
                                return pluginEntry;
                            });
                        }
                    }
                    if (dataInputStream == null) continue;
                    if (throwable == null) break block12;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable5;
                        Throwables.throwIfCritical(throwable2);
                        throwable = throwable5 = throwable2;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (dataInputStream == null) throw throwable6;
                        if (throwable == null) {
                            dataInputStream.close();
                            throw throwable6;
                        }
                        try {
                            dataInputStream.close();
                            throw throwable6;
                        }
                        catch (Throwable throwable3) {
                            Throwables.throwIfCritical(throwable3);
                            Throwable throwable8 = throwable3;
                            throwable.addSuppressed(throwable8);
                            throw throwable6;
                        }
                    }
                }
                try {
                    dataInputStream.close();
                }
                catch (Throwable throwable4) {
                    Throwables.throwIfCritical(throwable4);
                    Throwable throwable3 = throwable4;
                    throwable.addSuppressed(throwable3);
                }
                continue;
            }
            dataInputStream.close();
        }
    }

    public int size() {
        return this.categories.size();
    }
}

