/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Marker;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.ThreadContext;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.ContextDataInjector;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.RingBufferLogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.ContextDataFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.ContextDataInjectorFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.MementoMessage;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.MutableLogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.ThrowableProxy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.time.Instant;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.time.MutableInstant;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Clock;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.ClockFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.DummyNanoClock;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.NanoClock;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.LoggerNameAwareMessage;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.Message;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.ReusableMessage;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.SimpleMessage;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.TimestampMessage;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.ReadOnlyStringMap;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.StackLocatorUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.StringMap;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Log4jLogEvent
implements LogEvent {
    private static final long serialVersionUID = -8393305700508709443L;
    private static final Clock CLOCK = ClockFactory.getClock();
    private static volatile NanoClock nanoClock = new DummyNanoClock();
    private static final ContextDataInjector CONTEXT_DATA_INJECTOR = ContextDataInjectorFactory.createInjector();
    private final String loggerFqcn;
    private final Marker marker;
    private final Level level;
    private final String loggerName;
    private Message message;
    private final MutableInstant instant = new MutableInstant();
    private final transient Throwable thrown;
    private ThrowableProxy thrownProxy;
    private final StringMap contextData;
    private final ThreadContext.ContextStack contextStack;
    private long threadId;
    private String threadName;
    private int threadPriority;
    private StackTraceElement source;
    private boolean includeLocation;
    private boolean endOfBatch = false;
    private final transient long nanoTime;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Log4jLogEvent() {
        this("", null, "", null, null, null, null, null, null, 0L, null, 0, null, CLOCK, nanoClock.nanoTime());
    }

    @Deprecated
    public Log4jLogEvent(long l2) {
        this("", null, "", null, null, null, null, null, null, 0L, null, 0, null, l2, 0, nanoClock.nanoTime());
    }

    @Deprecated
    public Log4jLogEvent(String string, Marker marker, String string2, Level level, Message message, Throwable throwable) {
        this(string, marker, string2, level, message, null, throwable);
    }

    public Log4jLogEvent(String string, Marker marker, String string2, Level level, Message message, List<Property> list, Throwable throwable) {
        this(string, marker, string2, level, message, throwable, null, Log4jLogEvent.createContextData(list), ThreadContext.getDepth() == 0 ? null : ThreadContext.cloneStack(), 0L, null, 0, null, CLOCK, nanoClock.nanoTime());
    }

    public Log4jLogEvent(String string, Marker marker, String string2, StackTraceElement stackTraceElement, Level level, Message message, List<Property> list, Throwable throwable) {
        this(string, marker, string2, level, message, throwable, null, Log4jLogEvent.createContextData(list), ThreadContext.getDepth() == 0 ? null : ThreadContext.cloneStack(), 0L, null, 0, stackTraceElement, CLOCK, nanoClock.nanoTime());
    }

    @Deprecated
    public Log4jLogEvent(String string, Marker marker, String string2, Level level, Message message, Throwable throwable, Map<String, String> map, ThreadContext.ContextStack contextStack, String string3, StackTraceElement stackTraceElement, long l2) {
        this(string, marker, string2, level, message, throwable, null, Log4jLogEvent.createContextData(map), contextStack, 0L, string3, 0, stackTraceElement, l2, 0, nanoClock.nanoTime());
    }

    @Deprecated
    public static Log4jLogEvent createEvent(String string, Marker marker, String string2, Level level, Message message, Throwable throwable, ThrowableProxy throwableProxy, Map<String, String> map, ThreadContext.ContextStack contextStack, String string3, StackTraceElement stackTraceElement, long l2) {
        Log4jLogEvent log4jLogEvent = new Log4jLogEvent(string, marker, string2, level, message, throwable, throwableProxy, Log4jLogEvent.createContextData(map), contextStack, 0L, string3, 0, stackTraceElement, l2, 0, nanoClock.nanoTime());
        return log4jLogEvent;
    }

    private Log4jLogEvent(String string, Marker marker, String string2, Level level, Message message, Throwable throwable, ThrowableProxy throwableProxy, StringMap stringMap, ThreadContext.ContextStack contextStack, long l2, String string3, int n2, StackTraceElement stackTraceElement, long l3, int n3, long l4) {
        this(string, marker, string2, level, message, throwable, throwableProxy, stringMap, contextStack, l2, string3, n2, stackTraceElement, l4);
        long l5 = message instanceof TimestampMessage ? ((TimestampMessage)((Object)message)).getTimestamp() : l3;
        this.instant.initFromEpochMilli(l5, n3);
    }

    private Log4jLogEvent(String string, Marker marker, String string2, Level level, Message message, Throwable throwable, ThrowableProxy throwableProxy, StringMap stringMap, ThreadContext.ContextStack contextStack, long l2, String string3, int n2, StackTraceElement stackTraceElement, Clock clock, long l3) {
        this(string, marker, string2, level, message, throwable, throwableProxy, stringMap, contextStack, l2, string3, n2, stackTraceElement, l3);
        if (message instanceof TimestampMessage) {
            this.instant.initFromEpochMilli(((TimestampMessage)((Object)message)).getTimestamp(), 0);
        } else {
            this.instant.initFrom(clock);
        }
    }

    private Log4jLogEvent(String string, Marker marker, String string2, Level level, Message message, Throwable throwable, ThrowableProxy throwableProxy, StringMap stringMap, ThreadContext.ContextStack contextStack, long l2, String string3, int n2, StackTraceElement stackTraceElement, long l3) {
        this.loggerName = string;
        this.marker = marker;
        this.loggerFqcn = string2;
        this.level = level == null ? Level.OFF : level;
        this.message = message;
        this.thrown = throwable;
        this.thrownProxy = throwableProxy;
        this.contextData = stringMap == null ? ContextDataFactory.createContextData() : stringMap;
        this.contextStack = contextStack == null ? ThreadContext.EMPTY_STACK : contextStack;
        this.threadId = l2;
        this.threadName = string3;
        this.threadPriority = n2;
        this.source = stackTraceElement;
        if (message instanceof LoggerNameAwareMessage) {
            ((LoggerNameAwareMessage)((Object)message)).setLoggerName(string);
        }
        this.nanoTime = l3;
    }

    private static StringMap createContextData(Map<String, String> map) {
        StringMap stringMap = ContextDataFactory.createContextData();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringMap.putValue(entry.getKey(), entry.getValue());
            }
        }
        return stringMap;
    }

    private static StringMap createContextData(List<Property> list) {
        StringMap stringMap = ContextDataFactory.createContextData();
        return CONTEXT_DATA_INJECTOR.injectContextData(list, stringMap);
    }

    public static NanoClock getNanoClock() {
        return nanoClock;
    }

    public static void setNanoClock(NanoClock nanoClock) {
        Log4jLogEvent.nanoClock = Objects.requireNonNull(nanoClock, "NanoClock must be non-null");
        StatusLogger.getLogger().trace("Using {} for nanosecond timestamps.", (Object)nanoClock.getClass().getSimpleName());
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    @Override
    public Log4jLogEvent toImmutable() {
        if (this.getMessage() instanceof ReusableMessage) {
            this.makeMessageImmutable();
        }
        return this;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    public void makeMessageImmutable() {
        this.message = new MementoMessage(this.message.getFormattedMessage(), this.message.getFormat(), this.message.getParameters());
    }

    @Override
    public long getThreadId() {
        if (this.threadId == 0L) {
            this.threadId = Thread.currentThread().getId();
        }
        return this.threadId;
    }

    @Override
    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    @Override
    public int getThreadPriority() {
        if (this.threadPriority == 0) {
            this.threadPriority = Thread.currentThread().getPriority();
        }
        return this.threadPriority;
    }

    @Override
    public long getTimeMillis() {
        return this.instant.getEpochMillisecond();
    }

    @Override
    public Instant getInstant() {
        return this.instant;
    }

    @Override
    public Throwable getThrown() {
        return this.thrown;
    }

    @Override
    public ThrowableProxy getThrownProxy() {
        if (this.thrownProxy == null && this.thrown != null) {
            this.thrownProxy = new ThrowableProxy(this.thrown);
        }
        return this.thrownProxy;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    @Override
    public String getLoggerFqcn() {
        return this.loggerFqcn;
    }

    @Override
    public ReadOnlyStringMap getContextData() {
        return this.contextData;
    }

    @Override
    public Map<String, String> getContextMap() {
        return this.contextData.toMap();
    }

    @Override
    public ThreadContext.ContextStack getContextStack() {
        return this.contextStack;
    }

    @Override
    public StackTraceElement getSource() {
        if (this.source != null) {
            return this.source;
        }
        if (this.loggerFqcn == null || !this.includeLocation) {
            return null;
        }
        this.source = StackLocatorUtil.calcLocation(this.loggerFqcn);
        return this.source;
    }

    @Override
    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    @Override
    public void setIncludeLocation(boolean bl2) {
        this.includeLocation = bl2;
    }

    @Override
    public boolean isEndOfBatch() {
        return this.endOfBatch;
    }

    @Override
    public void setEndOfBatch(boolean bl2) {
        this.endOfBatch = bl2;
    }

    @Override
    public long getNanoTime() {
        return this.nanoTime;
    }

    protected Object writeReplace() {
        this.getThrownProxy();
        return new LogEventProxy(this, this.includeLocation);
    }

    public static Serializable serialize(LogEvent logEvent, boolean bl2) {
        if (logEvent instanceof Log4jLogEvent) {
            logEvent.getThrownProxy();
            return new LogEventProxy((Log4jLogEvent)logEvent, bl2);
        }
        return new LogEventProxy(logEvent, bl2);
    }

    public static Serializable serialize(Log4jLogEvent log4jLogEvent, boolean bl2) {
        log4jLogEvent.getThrownProxy();
        return new LogEventProxy(log4jLogEvent, bl2);
    }

    public static boolean canDeserialize(Serializable serializable) {
        return serializable instanceof LogEventProxy;
    }

    public static Log4jLogEvent deserialize(Serializable serializable) {
        Objects.requireNonNull(serializable, "Event cannot be null");
        if (serializable instanceof LogEventProxy) {
            LogEventProxy logEventProxy = (LogEventProxy)serializable;
            Log4jLogEvent log4jLogEvent = new Log4jLogEvent(logEventProxy.loggerName, logEventProxy.marker, logEventProxy.loggerFQCN, logEventProxy.level, logEventProxy.message, logEventProxy.thrown, logEventProxy.thrownProxy, logEventProxy.contextData, logEventProxy.contextStack, logEventProxy.threadId, logEventProxy.threadName, logEventProxy.threadPriority, logEventProxy.source, logEventProxy.timeMillis, logEventProxy.nanoOfMillisecond, logEventProxy.nanoTime);
            log4jLogEvent.setEndOfBatch(logEventProxy.isEndOfBatch);
            log4jLogEvent.setIncludeLocation(logEventProxy.isLocationRequired);
            return log4jLogEvent;
        }
        throw new IllegalArgumentException("Event is not a serialized LogEvent: " + serializable.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public static LogEvent createMemento(LogEvent logEvent) {
        return new Builder(logEvent).build();
    }

    public static Log4jLogEvent createMemento(LogEvent logEvent, boolean bl2) {
        return Log4jLogEvent.deserialize(Log4jLogEvent.serialize(logEvent, bl2));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.loggerName.isEmpty() ? "root" : this.loggerName;
        stringBuilder.append("Logger=").append(string);
        stringBuilder.append(" Level=").append(this.level.name());
        stringBuilder.append(" Message=").append(this.message == null ? null : this.message.getFormattedMessage());
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Log4jLogEvent log4jLogEvent = (Log4jLogEvent)object;
        if (this.endOfBatch != log4jLogEvent.endOfBatch) {
            return false;
        }
        if (this.includeLocation != log4jLogEvent.includeLocation) {
            return false;
        }
        if (!this.instant.equals(log4jLogEvent.instant)) {
            return false;
        }
        if (this.nanoTime != log4jLogEvent.nanoTime) {
            return false;
        }
        if (this.loggerFqcn != null ? !this.loggerFqcn.equals(log4jLogEvent.loggerFqcn) : log4jLogEvent.loggerFqcn != null) {
            return false;
        }
        if (this.level != null ? !this.level.equals(log4jLogEvent.level) : log4jLogEvent.level != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(log4jLogEvent.source) : log4jLogEvent.source != null) {
            return false;
        }
        if (this.marker != null ? !this.marker.equals(log4jLogEvent.marker) : log4jLogEvent.marker != null) {
            return false;
        }
        if (this.contextData != null ? !this.contextData.equals(log4jLogEvent.contextData) : log4jLogEvent.contextData != null) {
            return false;
        }
        if (!this.message.equals(log4jLogEvent.message)) {
            return false;
        }
        if (!this.loggerName.equals(log4jLogEvent.loggerName)) {
            return false;
        }
        if (this.contextStack != null ? !this.contextStack.equals(log4jLogEvent.contextStack) : log4jLogEvent.contextStack != null) {
            return false;
        }
        if (this.threadId != log4jLogEvent.threadId) {
            return false;
        }
        if (this.threadName != null ? !this.threadName.equals(log4jLogEvent.threadName) : log4jLogEvent.threadName != null) {
            return false;
        }
        if (this.threadPriority != log4jLogEvent.threadPriority) {
            return false;
        }
        if (this.thrown != null ? !this.thrown.equals(log4jLogEvent.thrown) : log4jLogEvent.thrown != null) {
            return false;
        }
        return !(this.thrownProxy != null ? !this.thrownProxy.equals(log4jLogEvent.thrownProxy) : log4jLogEvent.thrownProxy != null);
    }

    public int hashCode() {
        int n2 = this.loggerFqcn != null ? this.loggerFqcn.hashCode() : 0;
        n2 = 31 * n2 + (this.marker != null ? this.marker.hashCode() : 0);
        n2 = 31 * n2 + (this.level != null ? this.level.hashCode() : 0);
        n2 = 31 * n2 + this.loggerName.hashCode();
        n2 = 31 * n2 + this.message.hashCode();
        n2 = 31 * n2 + this.instant.hashCode();
        n2 = 31 * n2 + (int)(this.nanoTime ^ this.nanoTime >>> 32);
        n2 = 31 * n2 + (this.thrown != null ? this.thrown.hashCode() : 0);
        n2 = 31 * n2 + (this.thrownProxy != null ? this.thrownProxy.hashCode() : 0);
        n2 = 31 * n2 + (this.contextData != null ? this.contextData.hashCode() : 0);
        n2 = 31 * n2 + (this.contextStack != null ? this.contextStack.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.threadId ^ this.threadId >>> 32);
        n2 = 31 * n2 + (this.threadName != null ? this.threadName.hashCode() : 0);
        n2 = 31 * n2 + (this.threadPriority ^ this.threadPriority >>> 32);
        n2 = 31 * n2 + (this.source != null ? this.source.hashCode() : 0);
        n2 = 31 * n2 + (this.includeLocation ? 1 : 0);
        n2 = 31 * n2 + (this.endOfBatch ? 1 : 0);
        return n2;
    }

    static /* synthetic */ StringMap access$000(List list) {
        return Log4jLogEvent.createContextData(list);
    }

    static class LogEventProxy
    implements Serializable {
        private static final long serialVersionUID = -8634075037355293699L;
        private final String loggerFQCN;
        private final Marker marker;
        private final Level level;
        private final String loggerName;
        private final transient Message message;
        private MarshalledObject<Message> marshalledMessage;
        private String messageString;
        private final long timeMillis;
        private final int nanoOfMillisecond;
        private final transient Throwable thrown;
        private final ThrowableProxy thrownProxy;
        private final StringMap contextData;
        private final ThreadContext.ContextStack contextStack;
        private final long threadId;
        private final String threadName;
        private final int threadPriority;
        private final StackTraceElement source;
        private final boolean isLocationRequired;
        private final boolean isEndOfBatch;
        private final transient long nanoTime;

        public LogEventProxy(Log4jLogEvent log4jLogEvent, boolean bl2) {
            this.loggerFQCN = log4jLogEvent.loggerFqcn;
            this.marker = log4jLogEvent.marker;
            this.level = log4jLogEvent.level;
            this.loggerName = log4jLogEvent.loggerName;
            this.message = log4jLogEvent.message instanceof ReusableMessage ? LogEventProxy.memento((ReusableMessage)log4jLogEvent.message) : log4jLogEvent.message;
            this.timeMillis = log4jLogEvent.instant.getEpochMillisecond();
            this.nanoOfMillisecond = log4jLogEvent.instant.getNanoOfMillisecond();
            this.thrown = log4jLogEvent.thrown;
            this.thrownProxy = log4jLogEvent.thrownProxy;
            this.contextData = log4jLogEvent.contextData;
            this.contextStack = log4jLogEvent.contextStack;
            this.source = bl2 ? log4jLogEvent.getSource() : null;
            this.threadId = log4jLogEvent.getThreadId();
            this.threadName = log4jLogEvent.getThreadName();
            this.threadPriority = log4jLogEvent.getThreadPriority();
            this.isLocationRequired = bl2;
            this.isEndOfBatch = log4jLogEvent.endOfBatch;
            this.nanoTime = log4jLogEvent.nanoTime;
        }

        public LogEventProxy(LogEvent logEvent, boolean bl2) {
            this.loggerFQCN = logEvent.getLoggerFqcn();
            this.marker = logEvent.getMarker();
            this.level = logEvent.getLevel();
            this.loggerName = logEvent.getLoggerName();
            Message message = logEvent.getMessage();
            this.message = message instanceof ReusableMessage ? LogEventProxy.memento((ReusableMessage)message) : message;
            this.timeMillis = logEvent.getInstant().getEpochMillisecond();
            this.nanoOfMillisecond = logEvent.getInstant().getNanoOfMillisecond();
            this.thrown = logEvent.getThrown();
            this.thrownProxy = logEvent.getThrownProxy();
            this.contextData = LogEventProxy.memento(logEvent.getContextData());
            this.contextStack = logEvent.getContextStack();
            this.source = bl2 ? logEvent.getSource() : null;
            this.threadId = logEvent.getThreadId();
            this.threadName = logEvent.getThreadName();
            this.threadPriority = logEvent.getThreadPriority();
            this.isLocationRequired = bl2;
            this.isEndOfBatch = logEvent.isEndOfBatch();
            this.nanoTime = logEvent.getNanoTime();
        }

        private static Message memento(ReusableMessage reusableMessage) {
            return reusableMessage.memento();
        }

        private static StringMap memento(ReadOnlyStringMap readOnlyStringMap) {
            StringMap stringMap = ContextDataFactory.createContextData();
            stringMap.putAll(readOnlyStringMap);
            return stringMap;
        }

        private static MarshalledObject<Message> marshall(Message message) {
            try {
                return new MarshalledObject<Message>(message);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                return null;
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.messageString = this.message.getFormattedMessage();
            this.marshalledMessage = LogEventProxy.marshall(this.message);
            objectOutputStream.defaultWriteObject();
        }

        protected Object readResolve() {
            Log4jLogEvent log4jLogEvent = new Log4jLogEvent(this.loggerName, this.marker, this.loggerFQCN, this.level, this.message(), this.thrown, this.thrownProxy, this.contextData, this.contextStack, this.threadId, this.threadName, this.threadPriority, this.source, this.timeMillis, this.nanoOfMillisecond, this.nanoTime);
            log4jLogEvent.setEndOfBatch(this.isEndOfBatch);
            log4jLogEvent.setIncludeLocation(this.isLocationRequired);
            return log4jLogEvent;
        }

        private Message message() {
            if (this.marshalledMessage != null) {
                try {
                    return this.marshalledMessage.get();
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                }
            }
            return new SimpleMessage(this.messageString);
        }
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<LogEvent> {
        private String loggerFqcn;
        private Marker marker;
        private Level level;
        private String loggerName;
        private Message message;
        private Throwable thrown;
        private final MutableInstant instant = new MutableInstant();
        private ThrowableProxy thrownProxy;
        private StringMap contextData = Log4jLogEvent.access$000(null);
        private ThreadContext.ContextStack contextStack = ThreadContext.getImmutableStack();
        private long threadId;
        private String threadName;
        private int threadPriority;
        private StackTraceElement source;
        private boolean includeLocation;
        private boolean endOfBatch = false;
        private long nanoTime;

        public Builder() {
        }

        public Builder(LogEvent logEvent) {
            Objects.requireNonNull(logEvent);
            if (logEvent instanceof RingBufferLogEvent) {
                ((RingBufferLogEvent)logEvent).initializeBuilder(this);
                return;
            }
            if (logEvent instanceof MutableLogEvent) {
                ((MutableLogEvent)logEvent).initializeBuilder(this);
                return;
            }
            this.loggerFqcn = logEvent.getLoggerFqcn();
            this.marker = logEvent.getMarker();
            this.level = logEvent.getLevel();
            this.loggerName = logEvent.getLoggerName();
            this.message = logEvent.getMessage();
            this.instant.initFrom(logEvent.getInstant());
            this.thrown = logEvent.getThrown();
            this.contextStack = logEvent.getContextStack();
            this.includeLocation = logEvent.isIncludeLocation();
            this.endOfBatch = logEvent.isEndOfBatch();
            this.nanoTime = logEvent.getNanoTime();
            if (logEvent instanceof Log4jLogEvent) {
                Log4jLogEvent log4jLogEvent = (Log4jLogEvent)logEvent;
                this.contextData = log4jLogEvent.contextData;
                this.thrownProxy = log4jLogEvent.thrownProxy;
                this.source = log4jLogEvent.source;
                this.threadId = log4jLogEvent.threadId;
                this.threadName = log4jLogEvent.threadName;
                this.threadPriority = log4jLogEvent.threadPriority;
            } else {
                if (logEvent.getContextData() instanceof StringMap) {
                    this.contextData = (StringMap)logEvent.getContextData();
                } else {
                    if (this.contextData.isFrozen()) {
                        this.contextData = ContextDataFactory.createContextData();
                    } else {
                        this.contextData.clear();
                    }
                    this.contextData.putAll(logEvent.getContextData());
                }
                this.thrownProxy = logEvent.getThrownProxy();
                this.source = logEvent.getSource();
                this.threadId = logEvent.getThreadId();
                this.threadName = logEvent.getThreadName();
                this.threadPriority = logEvent.getThreadPriority();
            }
        }

        public Builder setLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder setLoggerFqcn(String string) {
            this.loggerFqcn = string;
            return this;
        }

        public Builder setLoggerName(String string) {
            this.loggerName = string;
            return this;
        }

        public Builder setMarker(Marker marker) {
            this.marker = marker;
            return this;
        }

        public Builder setMessage(Message message) {
            this.message = message;
            return this;
        }

        public Builder setThrown(Throwable throwable) {
            this.thrown = throwable;
            return this;
        }

        public Builder setTimeMillis(long l2) {
            this.instant.initFromEpochMilli(l2, 0);
            return this;
        }

        public Builder setInstant(Instant instant) {
            this.instant.initFrom(instant);
            return this;
        }

        public Builder setThrownProxy(ThrowableProxy throwableProxy) {
            this.thrownProxy = throwableProxy;
            return this;
        }

        @Deprecated
        public Builder setContextMap(Map<String, String> map) {
            this.contextData = ContextDataFactory.createContextData();
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.contextData.putValue(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public Builder setContextData(StringMap stringMap) {
            this.contextData = stringMap;
            return this;
        }

        public Builder setContextStack(ThreadContext.ContextStack contextStack) {
            this.contextStack = contextStack;
            return this;
        }

        public Builder setThreadId(long l2) {
            this.threadId = l2;
            return this;
        }

        public Builder setThreadName(String string) {
            this.threadName = string;
            return this;
        }

        public Builder setThreadPriority(int n2) {
            this.threadPriority = n2;
            return this;
        }

        public Builder setSource(StackTraceElement stackTraceElement) {
            this.source = stackTraceElement;
            return this;
        }

        public Builder setIncludeLocation(boolean bl2) {
            this.includeLocation = bl2;
            return this;
        }

        public Builder setEndOfBatch(boolean bl2) {
            this.endOfBatch = bl2;
            return this;
        }

        public Builder setNanoTime(long l2) {
            this.nanoTime = l2;
            return this;
        }

        @Override
        public Log4jLogEvent build() {
            this.initTimeFields();
            Log4jLogEvent log4jLogEvent = new Log4jLogEvent(this.loggerName, this.marker, this.loggerFqcn, this.level, this.message, this.thrown, this.thrownProxy, this.contextData, this.contextStack, this.threadId, this.threadName, this.threadPriority, this.source, this.instant.getEpochMillisecond(), this.instant.getNanoOfMillisecond(), this.nanoTime);
            log4jLogEvent.setIncludeLocation(this.includeLocation);
            log4jLogEvent.setEndOfBatch(this.endOfBatch);
            return log4jLogEvent;
        }

        private void initTimeFields() {
            if (this.instant.getEpochMillisecond() == 0L) {
                this.instant.initFrom(CLOCK);
            }
        }
    }
}

