/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.ssl;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.ssl.PasswordProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.ssl.StoreConfigurationException;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import java.util.Arrays;
import java.util.Objects;

public class StoreConfiguration<T> {
    static final String PKCS12 = "PKCS12";
    static final String JKS = "JKS";
    protected static final StatusLogger LOGGER = StatusLogger.getLogger();
    private String location;
    private PasswordProvider passwordProvider;

    public StoreConfiguration(String string, PasswordProvider passwordProvider) {
        this.location = string;
        this.passwordProvider = Objects.requireNonNull(passwordProvider, "passwordProvider");
    }

    @Deprecated
    public StoreConfiguration(String string, char[] cArray) {
        this(string, new MemoryPasswordProvider(cArray));
    }

    @Deprecated
    public StoreConfiguration(String string, String string2) {
        this(string, new MemoryPasswordProvider(string2 == null ? null : string2.toCharArray()));
    }

    public void clearSecrets() {
        this.location = null;
        this.passwordProvider = null;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    @Deprecated
    public String getPassword() {
        return String.valueOf(this.passwordProvider.getPassword());
    }

    public char[] getPasswordAsCharArray() {
        return this.passwordProvider.getPassword();
    }

    public void setPassword(char[] cArray) {
        this.passwordProvider = new MemoryPasswordProvider(cArray);
    }

    @Deprecated
    public void setPassword(String string) {
        this.passwordProvider = new MemoryPasswordProvider(string == null ? null : string.toCharArray());
    }

    protected T load() throws StoreConfigurationException {
        return null;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.location == null ? 0 : this.location.hashCode());
        n3 = 31 * n3 + Arrays.hashCode(this.passwordProvider.getPassword());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StoreConfiguration storeConfiguration = (StoreConfiguration)object;
        if (!Objects.equals(this.location, storeConfiguration.location)) {
            return false;
        }
        return Arrays.equals(this.passwordProvider.getPassword(), storeConfiguration.passwordProvider.getPassword());
    }
}

