/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.osgi;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.LogManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.util.PluginRegistry;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.Log4jProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.ThreadContextDataInjector;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.ThreadContextDataProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.osgi.BundleContextSelector;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.ContextDataProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.ProviderActivator;
import com.contrastsecurity.thirdparty.org.osgi.framework.Bundle;
import com.contrastsecurity.thirdparty.org.osgi.framework.BundleContext;
import com.contrastsecurity.thirdparty.org.osgi.framework.BundleEvent;
import com.contrastsecurity.thirdparty.org.osgi.framework.BundleListener;
import com.contrastsecurity.thirdparty.org.osgi.framework.InvalidSyntaxException;
import com.contrastsecurity.thirdparty.org.osgi.framework.ServiceReference;
import com.contrastsecurity.thirdparty.org.osgi.framework.ServiceRegistration;
import com.contrastsecurity.thirdparty.org.osgi.framework.SynchronousBundleListener;
import com.contrastsecurity.thirdparty.org.osgi.framework.wiring.BundleWiring;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;

public final class Activator
extends ProviderActivator
implements SynchronousBundleListener {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AtomicReference<BundleContext> contextRef = new AtomicReference();
    private ServiceRegistration<ContextDataProvider> contextDataRegistration = null;

    public Activator() {
        super(new Log4jProvider());
    }

    @Override
    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        ThreadContextDataProvider threadContextDataProvider = new ThreadContextDataProvider();
        this.contextDataRegistration = bundleContext.registerService(ContextDataProvider.class, (Object)threadContextDataProvider, null);
        Activator.loadContextProviders(bundleContext);
        if (PropertiesUtil.getProperties().getStringProperty("Log4jContextSelector") == null) {
            System.setProperty("Log4jContextSelector", BundleContextSelector.class.getName());
        }
        if (this.contextRef.compareAndSet(null, bundleContext)) {
            bundleContext.addBundleListener((BundleListener)this);
            Activator.scanInstalledBundlesForPlugins(bundleContext);
        }
    }

    private static void scanInstalledBundlesForPlugins(BundleContext bundleContext) {
        Bundle[] bundleArray;
        for (Bundle bundle : bundleArray = bundleContext.getBundles()) {
            Activator.scanBundleForPlugins(bundle);
        }
    }

    private static void scanBundleForPlugins(Bundle bundle) {
        long l2 = bundle.getBundleId();
        if (bundle.getState() == 32 && l2 != 0L) {
            LOGGER.trace("Scanning bundle [{}, id=%d] for plugins.", (Object)bundle.getSymbolicName(), (Object)l2);
            PluginRegistry.getInstance().loadFromBundle(l2, ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader());
        }
    }

    private static void loadContextProviders(BundleContext bundleContext) {
        try {
            Collection collection = bundleContext.getServiceReferences(ContextDataProvider.class, null);
            for (ServiceReference serviceReference : collection) {
                ContextDataProvider contextDataProvider = (ContextDataProvider)bundleContext.getService(serviceReference);
                ThreadContextDataInjector.contextDataProviders.add(contextDataProvider);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            LOGGER.error("Error accessing context data provider", (Throwable)invalidSyntaxException);
        }
    }

    private static void stopBundlePlugins(Bundle bundle) {
        LOGGER.trace("Stopping bundle [{}] plugins.", (Object)bundle.getSymbolicName());
        PluginRegistry.getInstance().clearBundlePlugins(bundle.getBundleId());
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
        this.contextDataRegistration.unregister();
        this.contextRef.compareAndSet(bundleContext, null);
        LogManager.shutdown();
        super.stop(bundleContext);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        switch (bundleEvent.getType()) {
            case 2: {
                Activator.scanBundleForPlugins(bundleEvent.getBundle());
                break;
            }
            case 256: {
                Activator.stopBundlePlugins(bundleEvent.getBundle());
                break;
            }
        }
    }
}

