/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.ConverterKeys;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.PatternFormatter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.PatternParser;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.EnglishEnums;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PerformanceSensitive;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.StringBuilders;
import java.util.List;

@Plugin(name="encode", category="Converter")
@ConverterKeys(value={"enc", "encode"})
@PerformanceSensitive(value={"allocation"})
public final class EncodingPatternConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final EscapeFormat escapeFormat;

    private EncodingPatternConverter(List<PatternFormatter> list, EscapeFormat escapeFormat) {
        super("encode", "encode");
        this.formatters = list;
        this.escapeFormat = escapeFormat;
    }

    @Override
    public boolean handlesThrowable() {
        return this.formatters != null && this.formatters.stream().map(PatternFormatter::getConverter).anyMatch(LogEventPatternConverter::handlesThrowable);
    }

    public static EncodingPatternConverter newInstance(Configuration configuration, String[] stringArray) {
        if (stringArray.length > 2 || stringArray.length == 0) {
            LOGGER.error("Incorrect number of options on escape. Expected 1 or 2, but received {}", (Object)stringArray.length);
            return null;
        }
        if (stringArray[0] == null) {
            LOGGER.error("No pattern supplied on escape");
            return null;
        }
        EscapeFormat escapeFormat = stringArray.length < 2 ? EscapeFormat.HTML : EnglishEnums.valueOf(EscapeFormat.class, stringArray[1], EscapeFormat.HTML);
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        List<PatternFormatter> list = patternParser.parse(stringArray[0]);
        return new EncodingPatternConverter(list, escapeFormat);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        for (int i2 = 0; i2 < this.formatters.size(); ++i2) {
            this.formatters.get(i2).format(logEvent, stringBuilder);
        }
        this.escapeFormat.escape(stringBuilder, n2);
    }

    private static enum EscapeFormat {
        HTML{

            @Override
            void escape(StringBuilder stringBuilder, int n2) {
                int n3;
                int n4;
                int n5;
                int n6 = n5 = stringBuilder.length();
                for (n4 = n5 - 1; n4 >= n2; --n4) {
                    n3 = stringBuilder.charAt(n4);
                    String string = this.escapeChar((char)n3);
                    if (string == null) continue;
                    n6 = n4;
                    for (int i2 = 0; i2 < string.length() - 1; ++i2) {
                        stringBuilder.append(' ');
                    }
                }
                n3 = stringBuilder.length();
                for (n4 = n5 - 1; n4 >= n6; --n4) {
                    char c2 = stringBuilder.charAt(n4);
                    String string = this.escapeChar(c2);
                    if (string == null) {
                        stringBuilder.setCharAt(--n3, c2);
                        continue;
                    }
                    stringBuilder.replace(n3 - string.length(), n3, string);
                    n3 -= string.length();
                }
            }

            private String escapeChar(char c2) {
                switch (c2) {
                    case '\r': {
                        return "\\r";
                    }
                    case '\n': {
                        return "\\n";
                    }
                    case '&': {
                        return "&amp;";
                    }
                    case '<': {
                        return "&lt;";
                    }
                    case '>': {
                        return "&gt;";
                    }
                    case '\"': {
                        return "&quot;";
                    }
                    case '\'': {
                        return "&apos;";
                    }
                    case '/': {
                        return "&#x2F;";
                    }
                }
                return null;
            }
        }
        ,
        JSON{

            @Override
            void escape(StringBuilder stringBuilder, int n2) {
                StringBuilders.escapeJson(stringBuilder, n2);
            }
        }
        ,
        CRLF{

            @Override
            void escape(StringBuilder stringBuilder, int n2) {
                int n3;
                int n4;
                int n5;
                int n6 = n5 = stringBuilder.length();
                for (n4 = n5 - 1; n4 >= n2; --n4) {
                    n3 = stringBuilder.charAt(n4);
                    if (n3 != 13 && n3 != 10) continue;
                    n6 = n4;
                    stringBuilder.append(' ');
                }
                n3 = stringBuilder.length();
                block5: for (n4 = n5 - 1; n4 >= n6; --n4) {
                    char c2 = stringBuilder.charAt(n4);
                    switch (c2) {
                        case '\r': {
                            stringBuilder.setCharAt(--n3, 'r');
                            stringBuilder.setCharAt(--n3, '\\');
                            continue block5;
                        }
                        case '\n': {
                            stringBuilder.setCharAt(--n3, 'n');
                            stringBuilder.setCharAt(--n3, '\\');
                            continue block5;
                        }
                        default: {
                            stringBuilder.setCharAt(--n3, c2);
                        }
                    }
                }
            }
        }
        ,
        XML{

            @Override
            void escape(StringBuilder stringBuilder, int n2) {
                StringBuilders.escapeXml(stringBuilder, n2);
            }
        };


        abstract void escape(StringBuilder var1, int var2);
    }
}

