/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.script;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.script.AbstractScript;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.script.ScriptFile;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.FileWatcher;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.WatchManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.io.File;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class ScriptManager
implements FileWatcher {
    private static final String KEY_THREADING = "THREADING";
    private static final Logger logger = StatusLogger.getLogger();
    private final Configuration configuration;
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final ConcurrentMap<String, ScriptRunner> scriptRunners = new ConcurrentHashMap<String, ScriptRunner>();
    private final String languages;
    private final Set<String> allowedLanguages;
    private final WatchManager watchManager;

    public ScriptManager(Configuration configuration, WatchManager watchManager, String string) {
        this.configuration = configuration;
        this.watchManager = watchManager;
        List<ScriptEngineFactory> list = this.manager.getEngineFactories();
        this.allowedLanguages = Arrays.stream(Strings.splitList(string)).map(String::toLowerCase).collect(Collectors.toSet());
        if (logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = list.size();
            logger.debug("Installed {} script engine{}", (Object)n2, (Object)(n2 != 1 ? "s" : ""));
            for (ScriptEngineFactory scriptEngineFactory : list) {
                String string2 = Objects.toString(scriptEngineFactory.getParameter(KEY_THREADING), null);
                if (string2 == null) {
                    string2 = "Not Thread Safe";
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                List<String> list2 = scriptEngineFactory.getNames();
                for (String string3 : list2) {
                    if (!this.allowedLanguages.contains(string3.toLowerCase(Locale.ROOT))) continue;
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(", ");
                    }
                    stringBuilder2.append(string3);
                }
                if (stringBuilder2.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                boolean bl2 = scriptEngineFactory.getScriptEngine() instanceof Compilable;
                logger.debug("{} version: {}, language: {}, threading: {}, compile: {}, names: {}, factory class: {}", (Object)scriptEngineFactory.getEngineName(), (Object)scriptEngineFactory.getEngineVersion(), (Object)scriptEngineFactory.getLanguageName(), (Object)string2, (Object)bl2, (Object)list2, (Object)scriptEngineFactory.getClass().getName());
            }
            this.languages = stringBuilder.toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (ScriptEngineFactory scriptEngineFactory : list) {
                for (String string4 : scriptEngineFactory.getNames()) {
                    if (!this.allowedLanguages.contains(string4.toLowerCase(Locale.ROOT))) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string4);
                }
            }
            this.languages = stringBuilder.toString();
        }
    }

    public Set<String> getAllowedLanguages() {
        return this.allowedLanguages;
    }

    public boolean addScript(AbstractScript abstractScript) {
        if (this.allowedLanguages.contains(abstractScript.getLanguage().toLowerCase(Locale.ROOT))) {
            ScriptEngine scriptEngine = this.manager.getEngineByName(abstractScript.getLanguage());
            if (scriptEngine == null) {
                logger.error("No ScriptEngine found for language " + abstractScript.getLanguage() + ". Available languages are: " + this.languages);
                return false;
            }
            if (scriptEngine.getFactory().getParameter(KEY_THREADING) == null) {
                this.scriptRunners.put(abstractScript.getName(), new ThreadLocalScriptRunner(abstractScript));
            } else {
                this.scriptRunners.put(abstractScript.getName(), new MainScriptRunner(scriptEngine, abstractScript));
            }
            if (abstractScript instanceof ScriptFile) {
                ScriptFile scriptFile = (ScriptFile)abstractScript;
                Path path = scriptFile.getPath();
                if (scriptFile.isWatched() && path != null) {
                    this.watchManager.watchFile(path.toFile(), this);
                }
            }
        } else {
            logger.error("Unable to add script {}, {} has not been configured as an allowed language", (Object)abstractScript.getName(), (Object)abstractScript.getLanguage());
            return false;
        }
        return true;
    }

    public Bindings createBindings(AbstractScript abstractScript) {
        return this.getScriptRunner(abstractScript).createBindings();
    }

    public AbstractScript getScript(String string) {
        ScriptRunner scriptRunner = (ScriptRunner)this.scriptRunners.get(string);
        return scriptRunner != null ? scriptRunner.getScript() : null;
    }

    @Override
    public void fileModified(File file) {
        ScriptRunner scriptRunner = (ScriptRunner)this.scriptRunners.get(file.toString());
        if (scriptRunner == null) {
            logger.info("{} is not a running script", (Object)file.getName());
            return;
        }
        ScriptEngine scriptEngine = scriptRunner.getScriptEngine();
        AbstractScript abstractScript = scriptRunner.getScript();
        if (scriptEngine.getFactory().getParameter(KEY_THREADING) == null) {
            this.scriptRunners.put(abstractScript.getName(), new ThreadLocalScriptRunner(abstractScript));
        } else {
            this.scriptRunners.put(abstractScript.getName(), new MainScriptRunner(scriptEngine, abstractScript));
        }
    }

    public Object execute(String string, Bindings bindings) {
        ScriptRunner scriptRunner = (ScriptRunner)this.scriptRunners.get(string);
        if (scriptRunner == null) {
            logger.warn("No script named {} could be found", (Object)string);
            return null;
        }
        return AccessController.doPrivileged(() -> scriptRunner.execute(bindings));
    }

    private ScriptRunner getScriptRunner(AbstractScript abstractScript) {
        return (ScriptRunner)this.scriptRunners.get(abstractScript.getName());
    }

    private class ThreadLocalScriptRunner
    extends AbstractScriptRunner {
        private final AbstractScript script;
        private final ThreadLocal<MainScriptRunner> runners;

        public ThreadLocalScriptRunner(AbstractScript abstractScript) {
            this.runners = new ThreadLocal<MainScriptRunner>(){

                @Override
                protected MainScriptRunner initialValue() {
                    ScriptEngine scriptEngine = ScriptManager.this.manager.getEngineByName(ThreadLocalScriptRunner.this.script.getLanguage());
                    return new MainScriptRunner(scriptEngine, ThreadLocalScriptRunner.this.script);
                }
            };
            this.script = abstractScript;
        }

        @Override
        public Object execute(Bindings bindings) {
            return this.runners.get().execute(bindings);
        }

        @Override
        public AbstractScript getScript() {
            return this.script;
        }

        @Override
        public ScriptEngine getScriptEngine() {
            return this.runners.get().getScriptEngine();
        }
    }

    private class MainScriptRunner
    extends AbstractScriptRunner {
        private final AbstractScript script;
        private final CompiledScript compiledScript;
        private final ScriptEngine scriptEngine;

        public MainScriptRunner(ScriptEngine scriptEngine, AbstractScript abstractScript) {
            this.script = abstractScript;
            this.scriptEngine = scriptEngine;
            CompiledScript compiledScript = null;
            if (scriptEngine instanceof Compilable) {
                logger.debug("Script {} is compilable", (Object)abstractScript.getName());
                compiledScript = AccessController.doPrivileged(() -> {
                    try {
                        return ((Compilable)((Object)scriptEngine)).compile(abstractScript.getScriptText());
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable2 = throwable;
                        logger.warn("Error compiling script", throwable2);
                        return null;
                    }
                });
            }
            this.compiledScript = compiledScript;
        }

        @Override
        public ScriptEngine getScriptEngine() {
            return this.scriptEngine;
        }

        @Override
        public Object execute(Bindings bindings) {
            if (this.compiledScript != null) {
                try {
                    return this.compiledScript.eval(bindings);
                }
                catch (ScriptException scriptException) {
                    logger.error("Error running script " + this.script.getName(), (Throwable)scriptException);
                    return null;
                }
            }
            try {
                return this.scriptEngine.eval(this.script.getScriptText(), bindings);
            }
            catch (ScriptException scriptException) {
                logger.error("Error running script " + this.script.getName(), (Throwable)scriptException);
                return null;
            }
        }

        @Override
        public AbstractScript getScript() {
            return this.script;
        }
    }

    private static interface ScriptRunner {
        public Bindings createBindings();

        public Object execute(Bindings var1);

        public AbstractScript getScript();

        public ScriptEngine getScriptEngine();
    }

    private abstract class AbstractScriptRunner
    implements ScriptRunner {
        private static final String KEY_STATUS_LOGGER = "statusLogger";
        private static final String KEY_CONFIGURATION = "configuration";

        private AbstractScriptRunner() {
        }

        @Override
        public Bindings createBindings() {
            SimpleBindings simpleBindings = new SimpleBindings();
            simpleBindings.put(KEY_CONFIGURATION, (Object)ScriptManager.this.configuration);
            simpleBindings.put(KEY_STATUS_LOGGER, (Object)logger);
            return simpleBindings;
        }
    }
}

