/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.time;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.time.Instant;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.time.PreciseClock;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Clock;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PerformanceSensitive;
import java.io.Serializable;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;

@PerformanceSensitive(value={"allocation"})
public class MutableInstant
implements Instant,
Serializable,
TemporalAccessor {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int NANOS_PER_SECOND = 1000000000;
    private long epochSecond;
    private int nanoOfSecond;

    @Override
    public long getEpochSecond() {
        return this.epochSecond;
    }

    @Override
    public int getNanoOfSecond() {
        return this.nanoOfSecond;
    }

    @Override
    public long getEpochMillisecond() {
        int n2 = this.nanoOfSecond / 1000000;
        long l2 = this.epochSecond * 1000L + (long)n2;
        return l2;
    }

    @Override
    public int getNanoOfMillisecond() {
        int n2 = this.nanoOfSecond / 1000000;
        int n3 = this.nanoOfSecond - n2 * 1000000;
        return n3;
    }

    public void initFrom(Instant instant) {
        this.epochSecond = instant.getEpochSecond();
        this.nanoOfSecond = instant.getNanoOfSecond();
    }

    public void initFromEpochMilli(long l2, int n2) {
        this.validateNanoOfMillisecond(n2);
        this.epochSecond = l2 / 1000L;
        this.nanoOfSecond = (int)(l2 - this.epochSecond * 1000L) * 1000000 + n2;
    }

    private void validateNanoOfMillisecond(int n2) {
        if (n2 < 0 || n2 >= 1000000) {
            throw new IllegalArgumentException("Invalid nanoOfMillisecond " + n2);
        }
    }

    public void initFrom(Clock clock) {
        if (clock instanceof PreciseClock) {
            ((PreciseClock)clock).init(this);
        } else {
            this.initFromEpochMilli(clock.currentTimeMillis(), 0);
        }
    }

    public void initFromEpochSecond(long l2, int n2) {
        this.validateNanoOfSecond(n2);
        this.epochSecond = l2;
        this.nanoOfSecond = n2;
    }

    private void validateNanoOfSecond(int n2) {
        if (n2 < 0 || n2 >= 1000000000) {
            throw new IllegalArgumentException("Invalid nanoOfSecond " + n2);
        }
    }

    public static void instantToMillisAndNanos(long l2, int n2, long[] lArray) {
        int n3 = n2 / 1000000;
        lArray[0] = l2 * 1000L + (long)n3;
        lArray[1] = n2 - n3 * 1000000;
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField == ChronoField.INSTANT_SECONDS || temporalField == ChronoField.NANO_OF_SECOND || temporalField == ChronoField.MICRO_OF_SECOND || temporalField == ChronoField.MILLI_OF_SECOND;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case NANO_OF_SECOND: {
                    return this.nanoOfSecond;
                }
                case MICRO_OF_SECOND: {
                    return this.nanoOfSecond / 1000;
                }
                case MILLI_OF_SECOND: {
                    return this.nanoOfSecond / 1000000;
                }
                case INSTANT_SECONDS: {
                    return this.epochSecond;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        return TemporalAccessor.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case NANO_OF_SECOND: {
                    return this.nanoOfSecond;
                }
                case MICRO_OF_SECOND: {
                    return this.nanoOfSecond / 1000;
                }
                case MILLI_OF_SECOND: {
                    return this.nanoOfSecond / 1000000;
                }
                case INSTANT_SECONDS: {
                    ChronoField.INSTANT_SECONDS.checkValidIntValue(this.epochSecond);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return this.range(temporalField).checkValidIntValue(temporalField.getFrom(this), temporalField);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        if (temporalQuery == TemporalQueries.chronology() || temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.localDate() || temporalQuery == TemporalQueries.localTime()) {
            return null;
        }
        return temporalQuery.queryFrom(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableInstant)) {
            return false;
        }
        MutableInstant mutableInstant = (MutableInstant)object;
        return this.epochSecond == mutableInstant.epochSecond && this.nanoOfSecond == mutableInstant.nanoOfSecond;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 31 * n2 + (int)(this.epochSecond ^ this.epochSecond >>> 32);
        n2 = 31 * n2 + this.nanoOfSecond;
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        this.formatTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        stringBuilder.append("MutableInstant[epochSecond=").append(this.epochSecond).append(", nano=").append(this.nanoOfSecond).append("]");
    }
}

