/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util;

import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Clock;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Log4jThread;
import java.util.concurrent.locks.LockSupport;

public final class CoarseCachedClock
implements Clock {
    private static volatile CoarseCachedClock instance;
    private static final Object INSTANCE_LOCK;
    private volatile long millis = System.currentTimeMillis();
    private final Thread updater = new Log4jThread("CoarseCachedClock Updater Thread"){

        @Override
        public void run() {
            ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
            try {
                while (true) {
                    CoarseCachedClock.this.millis = System.currentTimeMillis();
                    LockSupport.parkNanos(1000000L);
                }
            }
            catch (Throwable throwable) {
                scopeProvider.leaveScope();
                throw throwable;
            }
        }
    };

    private CoarseCachedClock() {
        this.updater.setDaemon(true);
        this.updater.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoarseCachedClock instance() {
        CoarseCachedClock coarseCachedClock = instance;
        if (coarseCachedClock == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                coarseCachedClock = instance;
                if (coarseCachedClock == null) {
                    instance = coarseCachedClock = new CoarseCachedClock();
                }
            }
        }
        return coarseCachedClock;
    }

    @Override
    public long currentTimeMillis() {
        return this.millis;
    }

    static {
        INSTANCE_LOCK = new Object();
    }
}

