/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.internal;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.ConfigurationException;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.UrlConnectionFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.ssl.SslConfigurationFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.AuthorizationProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.internal.LastModifiedSource;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.internal.Status;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public final class HttpInputStreamUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int NOT_MODIFIED = 304;
    private static final int NOT_AUTHORIZED = 401;
    private static final int NOT_FOUND = 404;
    private static final int OK = 200;
    private static final int BUF_SIZE = 1024;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result getInputStream(LastModifiedSource var0, AuthorizationProvider var1_1) {
        var2_2 = new Result();
        try {
            var3_3 = var0.getLastModified();
            var5_5 = (HttpURLConnection)UrlConnectionFactory.createConnection(var0.getURI().toURL(), var3_3, SslConfigurationFactory.getSslConfiguration(), var1_1);
            var5_5.connect();
            try {
                var6_6 = var5_5.getResponseCode();
                switch (var6_6) {
                    case 304: {
                        HttpInputStreamUtil.LOGGER.debug("Configuration not modified");
                        Result.access$002(var2_2, Status.NOT_MODIFIED);
                        var7_7 = var2_2;
                        return var7_7;
                    }
                    case 404: {
                        HttpInputStreamUtil.LOGGER.debug("Unable to access {}: Not Found", (Object)var0.toString());
                        Result.access$002(var2_2, Status.NOT_FOUND);
                        var7_8 = var2_2;
                        return var7_8;
                    }
                    case 200: {
                        var7_9 = var5_5.getInputStream();
                        var8_11 = null;
                        try {
                            var0.setLastModified(var5_5.getLastModified());
                            HttpInputStreamUtil.LOGGER.debug("Content was modified for {}. previous lastModified: {}, new lastModified: {}", (Object)var0.toString(), (Object)var3_3, (Object)var5_5.getLastModified());
                            Result.access$002(var2_2, Status.SUCCESS);
                            Result.access$102(var2_2, new ByteArrayInputStream(HttpInputStreamUtil.readStream(var7_9)));
                            var9_13 = var2_2;
                            if (var7_9 == null) return var9_13;
                            if (var8_11 != null) {
                            }
                            ** GOTO lbl105
                        }
                        catch (Throwable v0) {
                            try {
                                try {
                                    Throwables.throwIfCritical(v0);
                                    var9_14 = v0;
                                    var8_11 = var9_14;
                                    throw var9_14;
                                }
                                catch (Throwable var11_19) {
                                    if (var7_9 == null) throw var11_19;
                                    if (var8_11 == null) {
                                        var7_9.close();
                                        throw var11_19;
                                    }
                                    try {
                                        var7_9.close();
                                        throw var11_19;
                                    }
                                    catch (Throwable v1) {
                                        Throwables.throwIfCritical(v1);
                                        var12_20 = v1;
                                        var8_11.addSuppressed(var12_20);
                                        throw var11_19;
                                    }
                                }
                            }
                            catch (IOException var7_10) {
                                try {
                                    var8_11 = var5_5.getErrorStream();
                                    var9_15 = null;
                                    try {
                                        HttpInputStreamUtil.LOGGER.info("Error accessing configuration at {}: {}", (Object)var0.toString(), (Object)HttpInputStreamUtil.readStream((InputStream)var8_11));
                                        if (var8_11 == null) throw new ConfigurationException("Unable to access " + var0.toString(), var7_10);
                                        if (var9_15 != null) {
                                        }
                                        ** GOTO lbl92
                                    }
                                    catch (Throwable v2) {
                                        try {
                                            Throwables.throwIfCritical(v2);
                                            var9_15 = var10_18 = v2;
                                            throw var10_18;
                                        }
                                        catch (Throwable var13_21) {
                                            if (var8_11 == null) throw var13_21;
                                            if (var9_15 == null) {
                                                var8_11.close();
                                                throw var13_21;
                                            }
                                            try {
                                                var8_11.close();
                                                throw var13_21;
                                            }
                                            catch (Throwable v3) {
                                                Throwables.throwIfCritical(v3);
                                                var14_22 = v3;
                                                var9_15.addSuppressed(var14_22);
                                                throw var13_21;
                                            }
                                        }
                                    }
                                    try {
                                        var8_11.close();
                                        throw new ConfigurationException("Unable to access " + var0.toString(), var7_10);
                                    }
                                    catch (Throwable v4) {
                                        Throwables.throwIfCritical(v4);
                                        var10_17 = v4;
                                        var9_15.addSuppressed(var10_17);
                                        throw new ConfigurationException("Unable to access " + var0.toString(), var7_10);
                                    }
lbl92:
                                    // 1 sources

                                    var8_11.close();
                                    throw new ConfigurationException("Unable to access " + var0.toString(), var7_10);
                                }
                                catch (IOException var8_12) {
                                    HttpInputStreamUtil.LOGGER.error("Error accessing configuration at {}: {}", (Object)var0.toString(), (Object)var7_10.getMessage());
                                }
                                throw new ConfigurationException("Unable to access " + var0.toString(), var7_10);
                            }
                        }
                        try {
                            var7_9.close();
                            return var9_13;
                        }
                        catch (Throwable v5) {
                            Throwables.throwIfCritical(v5);
                            var10_16 = v5;
                            var8_11.addSuppressed(var10_16);
                            return var9_13;
                        }
lbl105:
                        // 1 sources

                        var7_9.close();
                        return var9_13;
                    }
                    case 401: {
                        throw new ConfigurationException("Authorization failed");
                    }
                }
                if (var6_6 < 0) {
                    HttpInputStreamUtil.LOGGER.info("Invalid response code returned");
                    throw new ConfigurationException("Unable to access " + var0.toString());
                }
                HttpInputStreamUtil.LOGGER.info("Unexpected response code returned {}", (Object)var6_6);
                throw new ConfigurationException("Unable to access " + var0.toString());
            }
            finally {
                var5_5.disconnect();
            }
        }
        catch (IOException var3_4) {
            HttpInputStreamUtil.LOGGER.warn("Error accessing {}: {}", (Object)var0.toString(), (Object)var3_4.getMessage());
            throw new ConfigurationException("Unable to access " + var0.toString(), var3_4);
        }
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static class Result {
        private InputStream inputStream;
        private Status status;

        public Result() {
        }

        public Result(Status status) {
            this.status = status;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public Status getStatus() {
            return this.status;
        }

        static /* synthetic */ Status access$002(Result result, Status status) {
            result.status = status;
            return result.status;
        }

        static /* synthetic */ InputStream access$102(Result result, InputStream inputStream) {
            result.inputStream = inputStream;
            return result.inputStream;
        }
    }
}

