/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.message;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.Message;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;

public class MessageFormatMessage
implements Message {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final long serialVersionUID = 1L;
    private static final int HASHVAL = 31;
    private String messagePattern;
    private transient Object[] parameters;
    private String[] serializedParameters;
    private transient String formattedMessage;
    private transient Throwable throwable;
    private final Locale locale;

    public MessageFormatMessage(Locale locale, String string, Object ... objectArray) {
        int n2;
        this.locale = locale;
        this.messagePattern = string;
        this.parameters = objectArray;
        int n3 = n2 = objectArray == null ? 0 : objectArray.length;
        if (n2 > 0 && objectArray[n2 - 1] instanceof Throwable) {
            this.throwable = (Throwable)objectArray[n2 - 1];
        }
    }

    public MessageFormatMessage(String string, Object ... objectArray) {
        this(Locale.getDefault(Locale.Category.FORMAT), string, objectArray);
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = this.formatMessage(this.messagePattern, this.parameters);
        }
        return this.formattedMessage;
    }

    @Override
    public String getFormat() {
        return this.messagePattern;
    }

    @Override
    public Object[] getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        return this.serializedParameters;
    }

    protected String formatMessage(String string, Object ... objectArray) {
        try {
            MessageFormat messageFormat = new MessageFormat(string, this.locale);
            return messageFormat.format(objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            LOGGER.error("Unable to format msg: " + string, (Throwable)illegalFormatException);
            return string;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MessageFormatMessage messageFormatMessage = (MessageFormatMessage)object;
        if (this.messagePattern != null ? !this.messagePattern.equals(messageFormatMessage.messagePattern) : messageFormatMessage.messagePattern != null) {
            return false;
        }
        return Arrays.equals(this.serializedParameters, messageFormatMessage.serializedParameters);
    }

    public int hashCode() {
        int n2 = this.messagePattern != null ? this.messagePattern.hashCode() : 0;
        n2 = 31 * n2 + (this.serializedParameters != null ? Arrays.hashCode(this.serializedParameters) : 0);
        return n2;
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getFormattedMessage();
        objectOutputStream.writeUTF(this.formattedMessage);
        objectOutputStream.writeUTF(this.messagePattern);
        int n2 = this.parameters == null ? 0 : this.parameters.length;
        objectOutputStream.writeInt(n2);
        this.serializedParameters = new String[n2];
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.serializedParameters[i2] = String.valueOf(this.parameters[i2]);
                objectOutputStream.writeUTF(this.serializedParameters[i2]);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.parameters = null;
        this.throwable = null;
        this.formattedMessage = objectInputStream.readUTF();
        this.messagePattern = objectInputStream.readUTF();
        int n2 = objectInputStream.readInt();
        this.serializedParameters = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.serializedParameters[i2] = objectInputStream.readUTF();
        }
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

