/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.ThreadContext;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.ThreadContextStack;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.StringBuilderFormattable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class MutableThreadContextStack
implements ThreadContextStack,
StringBuilderFormattable {
    private static final long serialVersionUID = 50505011L;
    private final List<String> list;
    private boolean frozen;

    public MutableThreadContextStack() {
        this(new ArrayList<String>());
    }

    public MutableThreadContextStack(List<String> list) {
        this.list = new ArrayList<String>(list);
    }

    private MutableThreadContextStack(MutableThreadContextStack mutableThreadContextStack) {
        this.list = new ArrayList<String>(mutableThreadContextStack.list);
    }

    private void checkInvariants() {
        if (this.frozen) {
            throw new UnsupportedOperationException("context stack has been frozen");
        }
    }

    @Override
    public String pop() {
        this.checkInvariants();
        if (this.list.isEmpty()) {
            return null;
        }
        int n2 = this.list.size() - 1;
        String string = this.list.remove(n2);
        return string;
    }

    @Override
    public String peek() {
        if (this.list.isEmpty()) {
            return null;
        }
        int n2 = this.list.size() - 1;
        return this.list.get(n2);
    }

    @Override
    public void push(String string) {
        this.checkInvariants();
        this.list.add(string);
    }

    @Override
    public int getDepth() {
        return this.list.size();
    }

    @Override
    public List<String> asList() {
        return this.list;
    }

    @Override
    public void trim(int n2) {
        this.checkInvariants();
        if (n2 < 0) {
            throw new IllegalArgumentException("Maximum stack depth cannot be negative");
        }
        if (this.list == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.list.size());
        int n3 = Math.min(n2, this.list.size());
        for (int i2 = 0; i2 < n3; ++i2) {
            arrayList.add(this.list.get(i2));
        }
        this.list.clear();
        this.list.addAll(arrayList);
    }

    @Override
    public ThreadContextStack copy() {
        return new MutableThreadContextStack(this);
    }

    @Override
    public void clear() {
        this.checkInvariants();
        this.list.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.list.toArray(TArray);
    }

    @Override
    public boolean add(String string) {
        this.checkInvariants();
        return this.list.add(string);
    }

    @Override
    public boolean remove(Object object) {
        this.checkInvariants();
        return this.list.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        this.checkInvariants();
        return this.list.addAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkInvariants();
        return this.list.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkInvariants();
        return this.list.retainAll(collection);
    }

    public String toString() {
        return String.valueOf(this.list);
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        stringBuilder.append('[');
        for (int i2 = 0; i2 < this.list.size(); ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(this.list.get(i2));
        }
        stringBuilder.append(']');
    }

    @Override
    public int hashCode() {
        return 31 + Objects.hashCode(this.list);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ThreadContextStack)) {
            return false;
        }
        ThreadContextStack threadContextStack = (ThreadContextStack)object;
        List<String> list = threadContextStack.asList();
        return Objects.equals(this.list, list);
    }

    @Override
    public ThreadContext.ContextStack getImmutableStackOrNull() {
        return this.copy();
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }
}

