/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FilteredObjectInputStream
extends ObjectInputStream {
    private static final Set<String> REQUIRED_JAVA_CLASSES = new HashSet<String>(Arrays.asList("java.math.BigDecimal", "java.math.BigInteger", "java.rmi.MarshalledObject", "[B"));
    private static final Set<String> REQUIRED_JAVA_PACKAGES = new HashSet<String>(Arrays.asList("java.lang.", "java.time.", "java.util.", "com.contrastsecurity.thirdparty.oa4j.logging.log4j.", "[Lorg.apache.logging.log4j."));
    private final Collection<String> allowedExtraClasses;

    public FilteredObjectInputStream() throws IOException, SecurityException {
        this.allowedExtraClasses = Collections.emptySet();
    }

    public FilteredObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.allowedExtraClasses = Collections.emptySet();
    }

    public FilteredObjectInputStream(Collection<String> collection) throws IOException, SecurityException {
        this.allowedExtraClasses = collection;
    }

    public FilteredObjectInputStream(InputStream inputStream, Collection<String> collection) throws IOException {
        super(inputStream);
        this.allowedExtraClasses = collection;
    }

    public Collection<String> getAllowedClasses() {
        return this.allowedExtraClasses;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (!FilteredObjectInputStream.isAllowedByDefault(string) && !this.allowedExtraClasses.contains(string)) {
            throw new InvalidObjectException("Class is not allowed for deserialization: " + string);
        }
        return super.resolveClass(objectStreamClass);
    }

    private static boolean isAllowedByDefault(String string) {
        return FilteredObjectInputStream.isRequiredPackage(string) || REQUIRED_JAVA_CLASSES.contains(string);
    }

    private static boolean isRequiredPackage(String string) {
        for (String string2 : REQUIRED_JAVA_PACKAGES) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

