/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ohh;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.ohh.AbstractHistogramBase;
import com.contrastsecurity.thirdparty.ohh.AllValuesIterator;
import com.contrastsecurity.thirdparty.ohh.ConcurrentHistogram;
import com.contrastsecurity.thirdparty.ohh.HistogramIterationValue;
import com.contrastsecurity.thirdparty.ohh.LinearIterator;
import com.contrastsecurity.thirdparty.ohh.LogarithmicIterator;
import com.contrastsecurity.thirdparty.ohh.PercentileIterator;
import com.contrastsecurity.thirdparty.ohh.RecordedValuesIterator;
import com.contrastsecurity.thirdparty.ohh.ValueRecorder;
import com.contrastsecurity.thirdparty.ohh.ZigZagEncoding;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public abstract class AbstractHistogram
extends AbstractHistogramBase
implements ValueRecorder,
Serializable {
    int leadingZeroCountBase;
    int subBucketHalfCountMagnitude;
    int unitMagnitude;
    int subBucketHalfCount;
    long subBucketMask;
    long unitMagnitudeMask;
    volatile long maxValue = 0L;
    volatile long minNonZeroValue = Long.MAX_VALUE;
    private static final AtomicLongFieldUpdater<AbstractHistogram> maxValueUpdater = AtomicLongFieldUpdater.newUpdater(AbstractHistogram.class, "maxValue");
    private static final AtomicLongFieldUpdater<AbstractHistogram> minNonZeroValueUpdater = AtomicLongFieldUpdater.newUpdater(AbstractHistogram.class, "minNonZeroValue");
    private static final long serialVersionUID = 478450434L;
    private static final int ENCODING_HEADER_SIZE = 40;
    private static final int V0_ENCODING_HEADER_SIZE = 32;
    private static final int V0EncodingCookieBase = 478450440;
    private static final int V0CompressedEncodingCookieBase = 478450441;
    private static final int V1EncodingCookieBase = 478450433;
    private static final int V1CompressedEncodingCookieBase = 478450434;
    private static final int V2EncodingCookieBase = 478450435;
    private static final int V2CompressedEncodingCookieBase = 478450436;
    private static final int V2maxWordSizeInBytes = 9;
    private static final int encodingCookieBase = 478450435;
    private static final int compressedEncodingCookieBase = 478450436;
    private static final Class[] constructorArgsTypes = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE};

    abstract long getCountAtIndex(int var1);

    abstract long getCountAtNormalizedIndex(int var1);

    abstract void incrementCountAtIndex(int var1);

    abstract void addToCountAtIndex(int var1, long var2);

    abstract void setCountAtIndex(int var1, long var2);

    abstract void setCountAtNormalizedIndex(int var1, long var2);

    abstract int getNormalizingIndexOffset();

    abstract void setNormalizingIndexOffset(int var1);

    abstract void shiftNormalizingIndexByOffset(int var1, boolean var2, double var3);

    abstract void setTotalCount(long var1);

    abstract void incrementTotalCount();

    abstract void addToTotalCount(long var1);

    abstract void clearCounts();

    abstract int _getEstimatedFootprintInBytes();

    abstract void resize(long var1);

    public abstract long getTotalCount();

    private void updatedMaxValue(long l2) {
        long l3;
        long l4 = l2 | this.unitMagnitudeMask;
        while (l4 > (l3 = this.maxValue)) {
            maxValueUpdater.compareAndSet(this, l3, l4);
        }
    }

    private void resetMaxValue(long l2) {
        this.maxValue = l2 | this.unitMagnitudeMask;
    }

    private void updateMinNonZeroValue(long l2) {
        long l3;
        if (l2 <= this.unitMagnitudeMask) {
            return;
        }
        long l4 = l2 & (this.unitMagnitudeMask ^ 0xFFFFFFFFFFFFFFFFL);
        while (l4 < (l3 = this.minNonZeroValue)) {
            minNonZeroValueUpdater.compareAndSet(this, l3, l4);
        }
    }

    private void resetMinNonZeroValue(long l2) {
        long l3 = l2 & (this.unitMagnitudeMask ^ 0xFFFFFFFFFFFFFFFFL);
        this.minNonZeroValue = l2 == Long.MAX_VALUE ? l2 : l3;
    }

    protected AbstractHistogram(int n2) {
        this(1L, 2L, n2);
        this.autoResize = true;
    }

    protected AbstractHistogram(long l2, long l3, int n2) {
        if (l2 < 1L) {
            throw new IllegalArgumentException("lowestDiscernibleValue must be >= 1");
        }
        if (l2 > 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("lowestDiscernibleValue must be <= Long.MAX_VALUE / 2");
        }
        if (l3 < 2L * l2) {
            throw new IllegalArgumentException("highestTrackableValue must be >= 2 * lowestDiscernibleValue");
        }
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException("numberOfSignificantValueDigits must be between 0 and 5");
        }
        this.identity = constructionIdentityCount.getAndIncrement();
        this.init(l2, l3, n2, 1.0, 0);
    }

    protected AbstractHistogram(AbstractHistogram abstractHistogram) {
        this(abstractHistogram.getLowestDiscernibleValue(), abstractHistogram.getHighestTrackableValue(), abstractHistogram.getNumberOfSignificantValueDigits());
        this.setStartTimeStamp(abstractHistogram.getStartTimeStamp());
        this.setEndTimeStamp(abstractHistogram.getEndTimeStamp());
        this.autoResize = abstractHistogram.autoResize;
    }

    private void init(long l2, long l3, int n2, double d2, int n3) {
        this.lowestDiscernibleValue = l2;
        this.highestTrackableValue = l3;
        this.numberOfSignificantValueDigits = n2;
        this.integerToDoubleValueConversionRatio = d2;
        if (n3 != 0) {
            this.setNormalizingIndexOffset(n3);
        }
        long l4 = 2L * (long)Math.pow(10.0, n2);
        this.unitMagnitude = (int)(Math.log(l2) / Math.log(2.0));
        this.unitMagnitudeMask = (1 << this.unitMagnitude) - 1;
        int n4 = (int)Math.ceil(Math.log(l4) / Math.log(2.0));
        this.subBucketHalfCountMagnitude = n4 - 1;
        this.subBucketCount = 1 << n4;
        this.subBucketHalfCount = this.subBucketCount / 2;
        this.subBucketMask = (long)this.subBucketCount - 1L << this.unitMagnitude;
        if (n4 + this.unitMagnitude > 62) {
            throw new IllegalArgumentException("Cannot represent numberOfSignificantValueDigits worth of values beyond lowestDiscernibleValue");
        }
        this.establishSize(l3);
        this.leadingZeroCountBase = 64 - this.unitMagnitude - n4;
        this.percentileIterator = new PercentileIterator(this, 1);
        this.recordedValuesIterator = new RecordedValuesIterator(this);
    }

    final void establishSize(long l2) {
        this.countsArrayLength = this.determineArrayLengthNeeded(l2);
        this.bucketCount = this.getBucketsNeededToCoverValue(l2);
        this.highestTrackableValue = l2;
    }

    final int determineArrayLengthNeeded(long l2) {
        if (l2 < 2L * this.lowestDiscernibleValue) {
            throw new IllegalArgumentException("highestTrackableValue (" + l2 + ") cannot be < (2 * lowestDiscernibleValue)");
        }
        int n2 = this.getLengthForNumberOfBuckets(this.getBucketsNeededToCoverValue(l2));
        return n2;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public boolean supportsAutoResize() {
        return true;
    }

    public void setAutoResize(boolean bl2) {
        this.autoResize = bl2;
    }

    @Override
    public void recordValue(long l2) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValue(l2);
    }

    @Override
    public void recordValueWithCount(long l2, long l3) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(l3, l2);
    }

    @Override
    public void recordValueWithExpectedInterval(long l2, long l3) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValueWithExpectedInterval(l2, l3);
    }

    void recordConvertedDoubleValue(double d2) {
        long l2 = (long)(d2 * this.doubleToIntegerValueConversionRatio);
        this.recordValue(l2);
    }

    public void recordConvertedDoubleValueWithCount(double d2, long l2) throws ArrayIndexOutOfBoundsException {
        long l3 = (long)(d2 * this.doubleToIntegerValueConversionRatio);
        this.recordCountAtValue(l2, l3);
    }

    public void recordValue(long l2, long l3) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithExpectedInterval(l2, l3);
    }

    void updateMinAndMax(long l2) {
        if (l2 > this.maxValue) {
            this.updatedMaxValue(l2);
        }
        if (l2 < this.minNonZeroValue && l2 != 0L) {
            this.updateMinNonZeroValue(l2);
        }
    }

    private void recordCountAtValue(long l2, long l3) throws ArrayIndexOutOfBoundsException {
        int n2 = this.countsArrayIndex(l3);
        try {
            this.addToCountAtIndex(n2, l2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.handleRecordException(l2, l3, indexOutOfBoundsException);
        }
        this.updateMinAndMax(l3);
        this.addToTotalCount(l2);
    }

    private void recordSingleValue(long l2) throws ArrayIndexOutOfBoundsException {
        int n2 = this.countsArrayIndex(l2);
        try {
            this.incrementCountAtIndex(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.handleRecordException(1L, l2, indexOutOfBoundsException);
        }
        this.updateMinAndMax(l2);
        this.incrementTotalCount();
    }

    private void handleRecordException(long l2, long l3, Exception exception) {
        if (!this.autoResize) {
            throw new ArrayIndexOutOfBoundsException("value " + l3 + " outside of histogram covered range. Caused by: " + exception);
        }
        this.resize(l3);
        int n2 = this.countsArrayIndex(l3);
        this.addToCountAtIndex(n2, l2);
        this.highestTrackableValue = this.highestEquivalentValue(this.valueFromIndex(this.countsArrayLength - 1));
    }

    private void recordValueWithCountAndExpectedInterval(long l2, long l3, long l4) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(l3, l2);
        if (l4 <= 0L) {
            return;
        }
        for (long i2 = l2 - l4; i2 >= l4; i2 -= l4) {
            this.recordCountAtValue(l3, i2);
        }
    }

    private void recordSingleValueWithExpectedInterval(long l2, long l3) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValue(l2);
        if (l3 <= 0L) {
            return;
        }
        for (long i2 = l2 - l3; i2 >= l3; i2 -= l3) {
            this.recordSingleValue(i2);
        }
    }

    @Override
    public void reset() {
        this.clearCounts();
        this.resetMaxValue(0L);
        this.resetMinNonZeroValue(Long.MAX_VALUE);
        this.setNormalizingIndexOffset(0);
        this.startTimeStampMsec = Long.MAX_VALUE;
        this.endTimeStampMsec = 0L;
        this.tag = null;
    }

    public abstract AbstractHistogram copy();

    public abstract AbstractHistogram copyCorrectedForCoordinatedOmission(long var1);

    public void copyInto(AbstractHistogram abstractHistogram) {
        abstractHistogram.reset();
        abstractHistogram.add(this);
        abstractHistogram.setStartTimeStamp(this.startTimeStampMsec);
        abstractHistogram.setEndTimeStamp(this.endTimeStampMsec);
    }

    public void copyIntoCorrectedForCoordinatedOmission(AbstractHistogram abstractHistogram, long l2) {
        abstractHistogram.reset();
        abstractHistogram.addWhileCorrectingForCoordinatedOmission(this, l2);
        abstractHistogram.setStartTimeStamp(this.startTimeStampMsec);
        abstractHistogram.setEndTimeStamp(this.endTimeStampMsec);
    }

    public void add(AbstractHistogram abstractHistogram) throws ArrayIndexOutOfBoundsException {
        long l2 = this.highestEquivalentValue(this.valueFromIndex(this.countsArrayLength - 1));
        if (l2 < abstractHistogram.getMaxValue()) {
            if (!this.isAutoResize()) {
                throw new ArrayIndexOutOfBoundsException("The other histogram includes values that do not fit in this histogram's range.");
            }
            this.resize(abstractHistogram.getMaxValue());
        }
        if (this.bucketCount == abstractHistogram.bucketCount && this.subBucketCount == abstractHistogram.subBucketCount && this.unitMagnitude == abstractHistogram.unitMagnitude && this.getNormalizingIndexOffset() == abstractHistogram.getNormalizingIndexOffset() && !(abstractHistogram instanceof ConcurrentHistogram)) {
            long l3 = 0L;
            for (int i2 = 0; i2 < abstractHistogram.countsArrayLength; ++i2) {
                long l4 = abstractHistogram.getCountAtIndex(i2);
                if (l4 <= 0L) continue;
                this.addToCountAtIndex(i2, l4);
                l3 += l4;
            }
            this.setTotalCount(this.getTotalCount() + l3);
            this.updatedMaxValue(Math.max(this.getMaxValue(), abstractHistogram.getMaxValue()));
            this.updateMinNonZeroValue(Math.min(this.getMinNonZeroValue(), abstractHistogram.getMinNonZeroValue()));
        } else {
            int n2 = abstractHistogram.countsArrayIndex(abstractHistogram.getMaxValue());
            long l5 = abstractHistogram.getCountAtIndex(n2);
            this.recordValueWithCount(abstractHistogram.valueFromIndex(n2), l5);
            for (int i3 = 0; i3 < n2; ++i3) {
                l5 = abstractHistogram.getCountAtIndex(i3);
                if (l5 <= 0L) continue;
                this.recordValueWithCount(abstractHistogram.valueFromIndex(i3), l5);
            }
        }
        this.setStartTimeStamp(Math.min(this.startTimeStampMsec, abstractHistogram.startTimeStampMsec));
        this.setEndTimeStamp(Math.max(this.endTimeStampMsec, abstractHistogram.endTimeStampMsec));
    }

    public void subtract(AbstractHistogram abstractHistogram) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (this.highestEquivalentValue(abstractHistogram.getMaxValue()) > this.highestEquivalentValue(this.valueFromIndex(this.countsArrayLength - 1))) {
            throw new IllegalArgumentException("The other histogram includes values that do not fit in this histogram's range.");
        }
        for (int i2 = 0; i2 < abstractHistogram.countsArrayLength; ++i2) {
            long l2 = abstractHistogram.getCountAtIndex(i2);
            if (l2 <= 0L) continue;
            long l3 = abstractHistogram.valueFromIndex(i2);
            if (this.getCountAtValue(l3) < l2) {
                throw new IllegalArgumentException("otherHistogram count (" + l2 + ") at value " + l3 + " is larger than this one's (" + this.getCountAtValue(l3) + ")");
            }
            this.recordValueWithCount(l3, -l2);
        }
        if (this.getCountAtValue(this.getMaxValue()) <= 0L || this.getCountAtValue(this.getMinNonZeroValue()) <= 0L) {
            this.establishInternalTackingValues();
        }
    }

    public void addWhileCorrectingForCoordinatedOmission(AbstractHistogram abstractHistogram, long l2) {
        AbstractHistogram abstractHistogram2 = this;
        for (HistogramIterationValue histogramIterationValue : abstractHistogram.recordedValues()) {
            abstractHistogram2.recordValueWithCountAndExpectedInterval(histogramIterationValue.getValueIteratedTo(), histogramIterationValue.getCountAtValueIteratedTo(), l2);
        }
    }

    public void shiftValuesLeft(int n2) {
        this.shiftValuesLeft(n2, this.integerToDoubleValueConversionRatio);
    }

    void shiftValuesLeft(int n2, double d2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot shift by a negative number of magnitudes");
        }
        if (n2 == 0) {
            return;
        }
        if (this.getTotalCount() == this.getCountAtIndex(0)) {
            return;
        }
        int n3 = n2 << this.subBucketHalfCountMagnitude;
        int n4 = this.countsArrayIndex(this.getMaxValue());
        if (n4 >= this.countsArrayLength - n3) {
            throw new ArrayIndexOutOfBoundsException("Operation would overflow, would discard recorded value counts");
        }
        long l2 = maxValueUpdater.getAndSet(this, 0L);
        long l3 = minNonZeroValueUpdater.getAndSet(this, Long.MAX_VALUE);
        boolean bl2 = l3 < (long)(this.subBucketHalfCount << this.unitMagnitude);
        this.shiftNormalizingIndexByOffset(n3, bl2, d2);
        this.updateMinAndMax(l2 << n2);
        if (l3 < Long.MAX_VALUE) {
            this.updateMinAndMax(l3 << n2);
        }
    }

    void nonConcurrentNormalizingIndexShift(int n2, boolean bl2) {
        long l2 = this.getCountAtIndex(0);
        this.setCountAtIndex(0, 0L);
        int n3 = this.normalizeIndex(0, this.getNormalizingIndexOffset(), this.countsArrayLength);
        this.setNormalizingIndexOffset(this.getNormalizingIndexOffset() + n2);
        if (bl2) {
            if (n2 <= 0) {
                throw new ArrayIndexOutOfBoundsException("Attempt to right-shift with already-recorded value counts that would underflow and lose precision");
            }
            this.shiftLowestHalfBucketContentsLeft(n2, n3);
        }
        this.setCountAtIndex(0, l2);
    }

    private void shiftLowestHalfBucketContentsLeft(int n2, int n3) {
        int n4 = n2 >> this.subBucketHalfCountMagnitude;
        for (int i2 = 1; i2 < this.subBucketHalfCount; ++i2) {
            long l2 = this.valueFromIndex(i2) << n4;
            int n5 = this.countsArrayIndex(l2);
            long l3 = this.getCountAtNormalizedIndex(i2 + n3);
            this.setCountAtIndex(n5, l3);
            this.setCountAtNormalizedIndex(i2 + n3, 0L);
        }
    }

    public void shiftValuesRight(int n2) {
        this.shiftValuesRight(n2, this.integerToDoubleValueConversionRatio);
    }

    void shiftValuesRight(int n2, double d2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot shift by a negative number of magnitudes");
        }
        if (n2 == 0) {
            return;
        }
        if (this.getTotalCount() == this.getCountAtIndex(0)) {
            return;
        }
        int n3 = this.subBucketHalfCount * n2;
        int n4 = this.countsArrayIndex(this.getMinNonZeroValue());
        if (n4 < n3 + this.subBucketHalfCount) {
            throw new ArrayIndexOutOfBoundsException("Operation would underflow and lose precision of already recorded value counts");
        }
        long l2 = maxValueUpdater.getAndSet(this, 0L);
        long l3 = minNonZeroValueUpdater.getAndSet(this, Long.MAX_VALUE);
        this.shiftNormalizingIndexByOffset(-n3, false, d2);
        this.updateMinAndMax(l2 >> n2);
        if (l3 < Long.MAX_VALUE) {
            this.updateMinAndMax(l3 >> n2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractHistogram)) {
            return false;
        }
        AbstractHistogram abstractHistogram = (AbstractHistogram)object;
        if (this.lowestDiscernibleValue != abstractHistogram.lowestDiscernibleValue || this.numberOfSignificantValueDigits != abstractHistogram.numberOfSignificantValueDigits || this.integerToDoubleValueConversionRatio != abstractHistogram.integerToDoubleValueConversionRatio) {
            return false;
        }
        if (this.getTotalCount() != abstractHistogram.getTotalCount()) {
            return false;
        }
        if (this.getMaxValue() != abstractHistogram.getMaxValue()) {
            return false;
        }
        if (this.getMinNonZeroValue() != abstractHistogram.getMinNonZeroValue()) {
            return false;
        }
        if (this.countsArrayLength == abstractHistogram.countsArrayLength) {
            for (int i2 = 0; i2 < this.countsArrayLength; ++i2) {
                if (this.getCountAtIndex(i2) == abstractHistogram.getCountAtIndex(i2)) continue;
                return false;
            }
        } else {
            for (HistogramIterationValue histogramIterationValue : this.recordedValues()) {
                long l2 = histogramIterationValue.getCountAtValueIteratedTo();
                long l3 = histogramIterationValue.getValueIteratedTo();
                if (abstractHistogram.getCountAtValue(l3) == l2) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        n2 = this.oneAtATimeHashStep(n2, this.unitMagnitude);
        n2 = this.oneAtATimeHashStep(n2, this.numberOfSignificantValueDigits);
        n2 = this.oneAtATimeHashStep(n2, (int)this.getTotalCount());
        n2 = this.oneAtATimeHashStep(n2, (int)this.getMaxValue());
        n2 = this.oneAtATimeHashStep(n2, (int)this.getMinNonZeroValue());
        n2 += n2 << 3;
        n2 ^= n2 >> 11;
        n2 += n2 << 15;
        return n2;
    }

    private int oneAtATimeHashStep(int n2, int n3) {
        n2 += n3;
        n2 += n2 << 10;
        n2 ^= n2 >> 6;
        return n2;
    }

    public long getLowestDiscernibleValue() {
        return this.lowestDiscernibleValue;
    }

    public long getHighestTrackableValue() {
        return this.highestTrackableValue;
    }

    public int getNumberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public long sizeOfEquivalentValueRange(long l2) {
        int n2 = this.getBucketIndex(l2);
        long l3 = 1L << this.unitMagnitude + n2;
        return l3;
    }

    public long lowestEquivalentValue(long l2) {
        int n2 = this.getBucketIndex(l2);
        int n3 = this.getSubBucketIndex(l2, n2);
        long l3 = this.valueFromIndex(n2, n3);
        return l3;
    }

    public long highestEquivalentValue(long l2) {
        return this.nextNonEquivalentValue(l2) - 1L;
    }

    public long medianEquivalentValue(long l2) {
        return this.lowestEquivalentValue(l2) + (this.sizeOfEquivalentValueRange(l2) >> 1);
    }

    public long nextNonEquivalentValue(long l2) {
        return this.lowestEquivalentValue(l2) + this.sizeOfEquivalentValueRange(l2);
    }

    public boolean valuesAreEquivalent(long l2, long l3) {
        return this.lowestEquivalentValue(l2) == this.lowestEquivalentValue(l3);
    }

    public int getEstimatedFootprintInBytes() {
        return this._getEstimatedFootprintInBytes();
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStampMsec;
    }

    @Override
    public void setStartTimeStamp(long l2) {
        this.startTimeStampMsec = l2;
    }

    @Override
    public long getEndTimeStamp() {
        return this.endTimeStampMsec;
    }

    @Override
    public void setEndTimeStamp(long l2) {
        this.endTimeStampMsec = l2;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String string) {
        this.tag = string;
    }

    public long getMinValue() {
        if (this.getCountAtIndex(0) > 0L || this.getTotalCount() == 0L) {
            return 0L;
        }
        return this.getMinNonZeroValue();
    }

    public long getMaxValue() {
        return this.maxValue == 0L ? 0L : this.highestEquivalentValue(this.maxValue);
    }

    public long getMinNonZeroValue() {
        return this.minNonZeroValue == Long.MAX_VALUE ? Long.MAX_VALUE : this.lowestEquivalentValue(this.minNonZeroValue);
    }

    @Override
    public double getMaxValueAsDouble() {
        return this.getMaxValue();
    }

    public double getMean() {
        if (this.getTotalCount() == 0L) {
            return 0.0;
        }
        this.recordedValuesIterator.reset();
        double d2 = 0.0;
        while (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue histogramIterationValue = this.recordedValuesIterator.next();
            d2 += (double)this.medianEquivalentValue(histogramIterationValue.getValueIteratedTo()) * (double)histogramIterationValue.getCountAtValueIteratedTo();
        }
        return d2 * 1.0 / (double)this.getTotalCount();
    }

    public double getStdDeviation() {
        if (this.getTotalCount() == 0L) {
            return 0.0;
        }
        double d2 = this.getMean();
        double d3 = 0.0;
        this.recordedValuesIterator.reset();
        while (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue histogramIterationValue = this.recordedValuesIterator.next();
            double d4 = (double)this.medianEquivalentValue(histogramIterationValue.getValueIteratedTo()) * 1.0 - d2;
            d3 += d4 * d4 * (double)histogramIterationValue.getCountAddedInThisIterationStep();
        }
        double d5 = Math.sqrt(d3 / (double)this.getTotalCount());
        return d5;
    }

    public long getValueAtPercentile(double d2) {
        double d3 = Math.min(Math.max(Math.nextAfter(d2, Double.NEGATIVE_INFINITY), 0.0), 100.0);
        double d4 = d3 * (double)this.getTotalCount() / 100.0;
        long l2 = (long)Math.ceil(d4);
        l2 = Math.max(l2, 1L);
        long l3 = 0L;
        for (int i2 = 0; i2 < this.countsArrayLength; ++i2) {
            if ((l3 += this.getCountAtIndex(i2)) < l2) continue;
            long l4 = this.valueFromIndex(i2);
            return d2 == 0.0 ? this.lowestEquivalentValue(l4) : this.highestEquivalentValue(l4);
        }
        return 0L;
    }

    public double getPercentileAtOrBelowValue(long l2) {
        if (this.getTotalCount() == 0L) {
            return 100.0;
        }
        int n2 = Math.min(this.countsArrayIndex(l2), this.countsArrayLength - 1);
        long l3 = 0L;
        for (int i2 = 0; i2 <= n2; ++i2) {
            l3 += this.getCountAtIndex(i2);
        }
        return 100.0 * (double)l3 / (double)this.getTotalCount();
    }

    public long getCountBetweenValues(long l2, long l3) throws ArrayIndexOutOfBoundsException {
        int n2 = Math.max(0, this.countsArrayIndex(l2));
        int n3 = Math.min(this.countsArrayIndex(l3), this.countsArrayLength - 1);
        long l4 = 0L;
        for (int i2 = n2; i2 <= n3; ++i2) {
            l4 += this.getCountAtIndex(i2);
        }
        return l4;
    }

    public long getCountAtValue(long l2) throws ArrayIndexOutOfBoundsException {
        int n2 = Math.min(Math.max(0, this.countsArrayIndex(l2)), this.countsArrayLength - 1);
        return this.getCountAtIndex(n2);
    }

    public Percentiles percentiles(int n2) {
        return new Percentiles(this, n2);
    }

    public LinearBucketValues linearBucketValues(long l2) {
        return new LinearBucketValues(this, l2);
    }

    public LogarithmicBucketValues logarithmicBucketValues(long l2, double d2) {
        return new LogarithmicBucketValues(this, l2, d2);
    }

    public RecordedValues recordedValues() {
        return new RecordedValues(this);
    }

    public AllValues allValues() {
        return new AllValues(this);
    }

    public void outputPercentileDistribution(PrintStream printStream, Double d2) {
        this.outputPercentileDistribution(printStream, 5, d2);
    }

    public void outputPercentileDistribution(PrintStream printStream, int n2, Double d2) {
        this.outputPercentileDistribution(printStream, n2, d2, false);
    }

    public void outputPercentileDistribution(PrintStream printStream, int n2, Double d2, boolean bl2) {
        String string;
        String string2;
        if (bl2) {
            printStream.format("\"Value\",\"Percentile\",\"TotalCount\",\"1/(1-Percentile)\"\n", new Object[0]);
        } else {
            printStream.format("%12s %14s %10s %14s\n\n", "Value", "Percentile", "TotalCount", "1/(1-Percentile)");
        }
        PercentileIterator percentileIterator = this.percentileIterator;
        percentileIterator.reset(n2);
        if (bl2) {
            string2 = "%." + this.numberOfSignificantValueDigits + "f,%.12f,%d,%.2f\n";
            string = "%." + this.numberOfSignificantValueDigits + "f,%.12f,%d,Infinity\n";
        } else {
            string2 = "%12." + this.numberOfSignificantValueDigits + "f %2.12f %10d %14.2f\n";
            string = "%12." + this.numberOfSignificantValueDigits + "f %2.12f %10d\n";
        }
        while (percentileIterator.hasNext()) {
            HistogramIterationValue histogramIterationValue = percentileIterator.next();
            if (histogramIterationValue.getPercentileLevelIteratedTo() != 100.0) {
                printStream.format(Locale.US, string2, (double)histogramIterationValue.getValueIteratedTo() / d2, histogramIterationValue.getPercentileLevelIteratedTo() / 100.0, histogramIterationValue.getTotalCountToThisValue(), 1.0 / (1.0 - histogramIterationValue.getPercentileLevelIteratedTo() / 100.0));
                continue;
            }
            printStream.format(Locale.US, string, (double)histogramIterationValue.getValueIteratedTo() / d2, histogramIterationValue.getPercentileLevelIteratedTo() / 100.0, histogramIterationValue.getTotalCountToThisValue());
        }
        if (!bl2) {
            double d3 = this.getMean() / d2;
            double d4 = this.getStdDeviation() / d2;
            printStream.format(Locale.US, "#[Mean    = %12." + this.numberOfSignificantValueDigits + "f, StdDeviation   = %12." + this.numberOfSignificantValueDigits + "f]\n", d3, d4);
            printStream.format(Locale.US, "#[Max     = %12." + this.numberOfSignificantValueDigits + "f, Total count    = %12d]\n", (double)this.getMaxValue() / d2, this.getTotalCount());
            printStream.format(Locale.US, "#[Buckets = %12d, SubBuckets     = %12d]\n", this.bucketCount, this.subBucketCount);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.lowestDiscernibleValue);
        objectOutputStream.writeLong(this.highestTrackableValue);
        objectOutputStream.writeInt(this.numberOfSignificantValueDigits);
        objectOutputStream.writeInt(this.getNormalizingIndexOffset());
        objectOutputStream.writeDouble(this.integerToDoubleValueConversionRatio);
        objectOutputStream.writeLong(this.getTotalCount());
        objectOutputStream.writeLong(this.maxValue);
        objectOutputStream.writeLong(this.minNonZeroValue);
        objectOutputStream.writeLong(this.startTimeStampMsec);
        objectOutputStream.writeLong(this.endTimeStampMsec);
        objectOutputStream.writeBoolean(this.autoResize);
        objectOutputStream.writeInt(this.wordSizeInBytes);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        long l2 = objectInputStream.readLong();
        long l3 = objectInputStream.readLong();
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        double d2 = objectInputStream.readDouble();
        long l4 = objectInputStream.readLong();
        long l5 = objectInputStream.readLong();
        long l6 = objectInputStream.readLong();
        long l7 = objectInputStream.readLong();
        long l8 = objectInputStream.readLong();
        boolean bl2 = objectInputStream.readBoolean();
        int n4 = objectInputStream.readInt();
        this.init(l2, l3, n2, d2, n3);
        this.setTotalCount(l4);
        this.maxValue = l5;
        this.minNonZeroValue = l6;
        this.startTimeStampMsec = l7;
        this.endTimeStampMsec = l8;
        this.autoResize = bl2;
        this.wordSizeInBytes = n4;
    }

    @Override
    public int getNeededByteBufferCapacity() {
        return this.getNeededByteBufferCapacity(this.countsArrayLength);
    }

    int getNeededByteBufferCapacity(int n2) {
        return this.getNeededPayloadByteBufferCapacity(n2) + 40;
    }

    int getNeededPayloadByteBufferCapacity(int n2) {
        return n2 * 9;
    }

    int getNeededV0PayloadByteBufferCapacity(int n2) {
        return n2 * this.wordSizeInBytes;
    }

    private int getEncodingCookie() {
        return 478450451;
    }

    private int getCompressedEncodingCookie() {
        return 478450452;
    }

    private static int getCookieBase(int n2) {
        return n2 & 0xFFFFFF0F;
    }

    private static int getWordSizeInBytesFromCookie(int n2) {
        if (AbstractHistogram.getCookieBase(n2) == 478450435 || AbstractHistogram.getCookieBase(n2) == 478450436) {
            return 9;
        }
        int n3 = (n2 & 0xF0) >> 4;
        return n3 & 0xE;
    }

    public synchronized int encodeIntoByteBuffer(ByteBuffer byteBuffer) {
        long l2 = this.getMaxValue();
        int n2 = this.countsArrayIndex(l2) + 1;
        if (byteBuffer.capacity() < this.getNeededByteBufferCapacity(n2)) {
            throw new ArrayIndexOutOfBoundsException("buffer does not have capacity for " + this.getNeededByteBufferCapacity(n2) + " bytes");
        }
        int n3 = byteBuffer.position();
        byteBuffer.putInt(this.getEncodingCookie());
        byteBuffer.putInt(0);
        byteBuffer.putInt(this.getNormalizingIndexOffset());
        byteBuffer.putInt(this.numberOfSignificantValueDigits);
        byteBuffer.putLong(this.lowestDiscernibleValue);
        byteBuffer.putLong(this.highestTrackableValue);
        byteBuffer.putDouble(this.getIntegerToDoubleValueConversionRatio());
        int n4 = byteBuffer.position();
        this.fillBufferFromCountsArray(byteBuffer);
        byteBuffer.putInt(n3 + 4, byteBuffer.position() - n4);
        return byteBuffer.position() - n3;
    }

    @Override
    public synchronized int encodeIntoCompressedByteBuffer(ByteBuffer byteBuffer, int n2) {
        byte[] byArray;
        int n3 = this.getNeededByteBufferCapacity(this.countsArrayLength);
        if (this.intermediateUncompressedByteBuffer == null || this.intermediateUncompressedByteBuffer.capacity() < n3) {
            this.intermediateUncompressedByteBuffer = ByteBuffer.allocate(n3).order(ByteOrder.BIG_ENDIAN);
        }
        this.intermediateUncompressedByteBuffer.clear();
        int n4 = byteBuffer.position();
        int n5 = this.encodeIntoByteBuffer(this.intermediateUncompressedByteBuffer);
        byteBuffer.putInt(this.getCompressedEncodingCookie());
        byteBuffer.putInt(0);
        Deflater deflater = new Deflater(n2);
        deflater.setInput(this.intermediateUncompressedByteBuffer.array(), 0, n5);
        deflater.finish();
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
        } else {
            if (this.intermediateUncompressedByteArray == null || this.intermediateUncompressedByteArray.length < byteBuffer.capacity()) {
                this.intermediateUncompressedByteArray = new byte[byteBuffer.capacity()];
            }
            byArray = this.intermediateUncompressedByteArray;
        }
        int n6 = n4 + 8;
        int n7 = deflater.deflate(byArray, n6, byArray.length - n6);
        deflater.end();
        if (!byteBuffer.hasArray()) {
            byteBuffer.put(byArray, n6, n7);
        }
        byteBuffer.putInt(n4 + 4, n7);
        int n8 = n7 + 8;
        byteBuffer.position(n4 + n8);
        return n8;
    }

    public int encodeIntoCompressedByteBuffer(ByteBuffer byteBuffer) {
        return this.encodeIntoCompressedByteBuffer(byteBuffer, -1);
    }

    static <T extends AbstractHistogram> T decodeFromByteBuffer(ByteBuffer byteBuffer, Class<T> clazz, long l2) {
        try {
            return AbstractHistogram.decodeFromByteBuffer(byteBuffer, clazz, l2, null);
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(dataFormatException);
        }
    }

    private static <T extends AbstractHistogram> T decodeFromByteBuffer(ByteBuffer byteBuffer, Class<T> clazz, long l2, Inflater inflater) throws DataFormatException {
        int n2;
        AbstractHistogram abstractHistogram;
        Object object;
        double d2;
        long l3;
        long l4;
        int n3;
        int n4;
        int n5;
        int n6 = byteBuffer.getInt();
        if (AbstractHistogram.getCookieBase(n6) == 478450435 || AbstractHistogram.getCookieBase(n6) == 478450433) {
            if (AbstractHistogram.getCookieBase(n6) == 478450435 && AbstractHistogram.getWordSizeInBytesFromCookie(n6) != 9) {
                throw new IllegalArgumentException("The buffer does not contain a Histogram (no valid cookie found)");
            }
            n5 = byteBuffer.getInt();
            n4 = byteBuffer.getInt();
            n3 = byteBuffer.getInt();
            l4 = byteBuffer.getLong();
            l3 = byteBuffer.getLong();
            d2 = byteBuffer.getDouble();
        } else if (AbstractHistogram.getCookieBase(n6) == 478450440) {
            n3 = byteBuffer.getInt();
            l4 = byteBuffer.getLong();
            l3 = byteBuffer.getLong();
            byteBuffer.getLong();
            n5 = Integer.MAX_VALUE;
            d2 = 1.0;
            n4 = 0;
        } else {
            throw new IllegalArgumentException("The buffer does not contain a Histogram (no valid cookie found)");
        }
        l3 = Math.max(l3, l2);
        try {
            object = clazz.getConstructor(constructorArgsTypes);
            abstractHistogram = (AbstractHistogram)((Constructor)object).newInstance(l4, l3, n3);
            abstractHistogram.setIntegerToDoubleValueConversionRatio(d2);
            abstractHistogram.setNormalizingIndexOffset(n4);
            try {
                abstractHistogram.setAutoResize(true);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Throwables.throwIfCritical(reflectiveOperationException);
            ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
            throw new IllegalArgumentException(reflectiveOperationException2);
        }
        int n7 = Math.min(abstractHistogram.getNeededV0PayloadByteBufferCapacity(abstractHistogram.countsArrayLength), n5);
        if (inflater == null) {
            if (n7 > byteBuffer.remaining()) {
                throw new IllegalArgumentException("The buffer does not contain the full Histogram payload");
            }
            object = byteBuffer;
        } else {
            object = ByteBuffer.allocate(n7).order(ByteOrder.BIG_ENDIAN);
            n2 = inflater.inflate(((ByteBuffer)object).array());
            if (n5 != Integer.MAX_VALUE && n2 < n5) {
                throw new IllegalArgumentException("The buffer does not contain the indicated payload amount");
            }
        }
        n2 = abstractHistogram.fillCountsArrayFromSourceBuffer((ByteBuffer)object, n7, AbstractHistogram.getWordSizeInBytesFromCookie(n6));
        abstractHistogram.establishInternalTackingValues(n2);
        return (T)abstractHistogram;
    }

    private int fillCountsArrayFromSourceBuffer(ByteBuffer byteBuffer, int n2, int n3) {
        if (n3 != 2 && n3 != 4 && n3 != 8 && n3 != 9) {
            throw new IllegalArgumentException("word size must be 2, 4, 8, or V2maxWordSizeInBytes (9) bytes");
        }
        long l2 = this.wordSizeInBytes == 2 ? 32767L : (this.wordSizeInBytes == 4 ? Integer.MAX_VALUE : Long.MAX_VALUE);
        int n4 = 0;
        int n5 = byteBuffer.position() + n2;
        while (byteBuffer.position() < n5) {
            long l3;
            int n6 = 0;
            if (n3 == 9) {
                l3 = ZigZagEncoding.getLong(byteBuffer);
                if (l3 < 0L) {
                    long l4 = -l3;
                    if (l4 > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("An encoded zero count of > Integer.MAX_VALUE was encountered in the source");
                    }
                    n6 = (int)l4;
                }
            } else {
                long l5 = n3 == 2 ? (long)byteBuffer.getShort() : (l3 = n3 == 4 ? (long)byteBuffer.getInt() : byteBuffer.getLong());
            }
            if (l3 > l2) {
                throw new IllegalArgumentException("An encoded count (" + l3 + ") does not fit in the Histogram's (" + this.wordSizeInBytes + " bytes) was encountered in the source");
            }
            if (n6 > 0) {
                n4 += n6;
                continue;
            }
            this.setCountAtIndex(n4++, l3);
        }
        return n4;
    }

    synchronized void fillBufferFromCountsArray(ByteBuffer byteBuffer) {
        int n2 = this.countsArrayIndex(this.maxValue) + 1;
        int n3 = 0;
        while (n3 < n2) {
            long l2;
            if ((l2 = this.getCountAtIndex(n3++)) < 0L) {
                throw new RuntimeException("Cannot encode histogram containing negative counts (" + l2 + ") at index " + n3 + ", corresponding the value range [" + this.lowestEquivalentValue(this.valueFromIndex(n3)) + "," + this.nextNonEquivalentValue(this.valueFromIndex(n3)) + ")");
            }
            long l3 = 0L;
            if (l2 == 0L) {
                l3 = 1L;
                while (n3 < n2 && this.getCountAtIndex(n3) == 0L) {
                    ++l3;
                    ++n3;
                }
            }
            if (l3 > 1L) {
                ZigZagEncoding.putLong(byteBuffer, -l3);
                continue;
            }
            ZigZagEncoding.putLong(byteBuffer, l2);
        }
    }

    static <T extends AbstractHistogram> T decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, Class<T> clazz, long l2) throws DataFormatException {
        Object object;
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.getInt();
        if (AbstractHistogram.getCookieBase(n4) == 478450436 || AbstractHistogram.getCookieBase(n4) == 478450434) {
            n2 = 40;
        } else if (AbstractHistogram.getCookieBase(n4) == 478450441) {
            n2 = 32;
        } else {
            throw new IllegalArgumentException("The buffer does not contain a compressed Histogram");
        }
        int n5 = byteBuffer.getInt();
        Inflater inflater = new Inflater();
        if (byteBuffer.hasArray()) {
            inflater.setInput(byteBuffer.array(), n3 + 8, n5);
        } else {
            object = new byte[n5];
            byteBuffer.get((byte[])object);
            inflater.setInput((byte[])object);
        }
        object = ByteBuffer.allocate(n2).order(ByteOrder.BIG_ENDIAN);
        inflater.inflate(((ByteBuffer)object).array());
        T t2 = AbstractHistogram.decodeFromByteBuffer((ByteBuffer)object, clazz, l2, inflater);
        inflater.end();
        return t2;
    }

    private String recordedValuesToString() {
        String string = "";
        try {
            for (int i2 = 0; i2 < this.countsArrayLength; ++i2) {
                if (this.getCountAtIndex(i2) == 0L) continue;
                string = string + String.format("[%d] : %d\n", i2, this.getCountAtIndex(i2));
            }
            return string;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            string = string + "!!! Exception thown in value iteration...\n";
            return string;
        }
    }

    public String toString() {
        String string = "AbstractHistogram:\n";
        string = string + super.toString();
        string = string + this.recordedValuesToString();
        return string;
    }

    void establishInternalTackingValues() {
        this.establishInternalTackingValues(this.countsArrayLength);
    }

    void establishInternalTackingValues(int n2) {
        this.resetMaxValue(0L);
        this.resetMinNonZeroValue(Long.MAX_VALUE);
        int n3 = -1;
        int n4 = -1;
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = this.getCountAtIndex(i2);
            if (l3 <= 0L) continue;
            l2 += l3;
            n3 = i2;
            if (n4 != -1 || i2 == 0) continue;
            n4 = i2;
        }
        if (n3 >= 0) {
            this.updatedMaxValue(this.highestEquivalentValue(this.valueFromIndex(n3)));
        }
        if (n4 >= 0) {
            this.updateMinNonZeroValue(this.valueFromIndex(n4));
        }
        this.setTotalCount(l2);
    }

    int getBucketsNeededToCoverValue(long l2) {
        long l3 = (long)this.subBucketCount << this.unitMagnitude;
        int n2 = 1;
        while (l3 <= l2) {
            if (l3 > 0x3FFFFFFFFFFFFFFFL) {
                return n2 + 1;
            }
            l3 <<= 1;
            ++n2;
        }
        return n2;
    }

    int getLengthForNumberOfBuckets(int n2) {
        int n3 = (n2 + 1) * this.subBucketHalfCount;
        return n3;
    }

    int countsArrayIndex(long l2) {
        if (l2 < 0L) {
            throw new ArrayIndexOutOfBoundsException("Histogram recorded value cannot be negative.");
        }
        int n2 = this.getBucketIndex(l2);
        int n3 = this.getSubBucketIndex(l2, n2);
        return this.countsArrayIndex(n2, n3);
    }

    private int countsArrayIndex(int n2, int n3) {
        assert (n3 < this.subBucketCount);
        assert (n2 == 0 || n3 >= this.subBucketHalfCount);
        int n4 = n2 + 1 << this.subBucketHalfCountMagnitude;
        int n5 = n3 - this.subBucketHalfCount;
        return n4 + n5;
    }

    int getBucketIndex(long l2) {
        return this.leadingZeroCountBase - Long.numberOfLeadingZeros(l2 | this.subBucketMask);
    }

    int getSubBucketIndex(long l2, int n2) {
        return (int)(l2 >>> n2 + this.unitMagnitude);
    }

    int normalizeIndex(int n2, int n3, int n4) {
        if (n3 == 0) {
            return n2;
        }
        if (n2 > n4 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("index out of covered value range");
        }
        int n5 = n2 - n3;
        if (n5 < 0) {
            n5 += n4;
        } else if (n5 >= n4) {
            n5 -= n4;
        }
        return n5;
    }

    private long valueFromIndex(int n2, int n3) {
        return (long)n3 << n2 + this.unitMagnitude;
    }

    final long valueFromIndex(int n2) {
        int n3 = (n2 >> this.subBucketHalfCountMagnitude) - 1;
        int n4 = (n2 & this.subBucketHalfCount - 1) + this.subBucketHalfCount;
        if (n3 < 0) {
            n4 -= this.subBucketHalfCount;
            n3 = 0;
        }
        return this.valueFromIndex(n3, n4);
    }

    static int numberOfSubbuckets(int n2) {
        long l2 = 2L * (long)Math.pow(10.0, n2);
        int n3 = (int)Math.ceil(Math.log(l2) / Math.log(2.0));
        int n4 = (int)Math.pow(2.0, n3);
        return n4;
    }

    public class AllValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;

        private AllValues(AbstractHistogram abstractHistogram2) {
            this.histogram = abstractHistogram2;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new AllValuesIterator(this.histogram);
        }
    }

    public class RecordedValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;

        private RecordedValues(AbstractHistogram abstractHistogram2) {
            this.histogram = abstractHistogram2;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new RecordedValuesIterator(this.histogram);
        }
    }

    public class LogarithmicBucketValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final long valueUnitsInFirstBucket;
        final double logBase;

        private LogarithmicBucketValues(AbstractHistogram abstractHistogram2, long l2, double d2) {
            this.histogram = abstractHistogram2;
            this.valueUnitsInFirstBucket = l2;
            this.logBase = d2;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new LogarithmicIterator(this.histogram, this.valueUnitsInFirstBucket, this.logBase);
        }
    }

    public class LinearBucketValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final long valueUnitsPerBucket;

        private LinearBucketValues(AbstractHistogram abstractHistogram2, long l2) {
            this.histogram = abstractHistogram2;
            this.valueUnitsPerBucket = l2;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new LinearIterator(this.histogram, this.valueUnitsPerBucket);
        }
    }

    public class Percentiles
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final int percentileTicksPerHalfDistance;

        private Percentiles(AbstractHistogram abstractHistogram2, int n2) {
            this.histogram = abstractHistogram2;
            this.percentileTicksPerHalfDistance = n2;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new PercentileIterator(this.histogram, this.percentileTicksPerHalfDistance);
        }
    }
}

