/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ohh;

import com.contrastsecurity.thirdparty.ohh.Base64Helper;
import com.contrastsecurity.thirdparty.ohh.EncodableHistogram;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HistogramLogWriter {
    private static final String HISTOGRAM_LOG_FORMAT_VERSION = "1.3";
    private static Pattern containsDelimeterPattern = Pattern.compile(".[, \\r\\n].");
    private Matcher containsDelimeterMatcher = containsDelimeterPattern.matcher("");
    private final PrintStream log;
    private ByteBuffer targetBuffer;
    private long baseTime = 0L;

    public HistogramLogWriter(String string) throws FileNotFoundException {
        this.log = new PrintStream(string);
    }

    public HistogramLogWriter(File file) throws FileNotFoundException {
        this.log = new PrintStream(file);
    }

    public HistogramLogWriter(OutputStream outputStream) {
        this.log = new PrintStream(outputStream);
    }

    public HistogramLogWriter(PrintStream printStream) {
        this.log = printStream;
    }

    public void close() {
        this.log.close();
    }

    public synchronized void outputIntervalHistogram(double d2, double d3, EncodableHistogram encodableHistogram, double d4) {
        if (this.targetBuffer == null || this.targetBuffer.capacity() < encodableHistogram.getNeededByteBufferCapacity()) {
            this.targetBuffer = ByteBuffer.allocate(encodableHistogram.getNeededByteBufferCapacity()).order(ByteOrder.BIG_ENDIAN);
        }
        this.targetBuffer.clear();
        int n2 = encodableHistogram.encodeIntoCompressedByteBuffer(this.targetBuffer, 9);
        byte[] byArray = Arrays.copyOf(this.targetBuffer.array(), n2);
        String string = encodableHistogram.getTag();
        if (string == null) {
            this.log.format(Locale.US, "%.3f,%.3f,%.3f,%s\n", d2, d3 - d2, encodableHistogram.getMaxValueAsDouble() / d4, Base64Helper.printBase64Binary(byArray));
        } else {
            this.containsDelimeterMatcher.reset(string);
            if (this.containsDelimeterMatcher.matches()) {
                throw new IllegalArgumentException("Tag string cannot contain commas, spaces, or line breaks");
            }
            this.log.format(Locale.US, "Tag=%s,%.3f,%.3f,%.3f,%s\n", string, d2, d3 - d2, encodableHistogram.getMaxValueAsDouble() / d4, Base64Helper.printBase64Binary(byArray));
        }
    }

    public void outputIntervalHistogram(double d2, double d3, EncodableHistogram encodableHistogram) {
        this.outputIntervalHistogram(d2, d3, encodableHistogram, 1000000.0);
    }

    public void outputIntervalHistogram(EncodableHistogram encodableHistogram) {
        this.outputIntervalHistogram((double)(encodableHistogram.getStartTimeStamp() - this.baseTime) / 1000.0, (double)(encodableHistogram.getEndTimeStamp() - this.baseTime) / 1000.0, encodableHistogram);
    }

    public void outputStartTime(long l2) {
        this.log.format(Locale.US, "#[StartTime: %.3f (seconds since epoch), %s]\n", (double)l2 / 1000.0, new Date(l2).toString());
    }

    public void outputBaseTime(long l2) {
        this.log.format(Locale.US, "#[BaseTime: %.3f (seconds since epoch)]\n", (double)l2 / 1000.0);
    }

    public void outputComment(String string) {
        this.log.format("#%s\n", string);
    }

    public void outputLegend() {
        this.log.println("\"StartTimestamp\",\"Interval_Length\",\"Interval_Max\",\"Interval_Compressed_Histogram\"");
    }

    public void outputLogFormatVersion() {
        this.outputComment("[Histogram log format version 1.3]");
    }

    public void setBaseTime(long l2) {
        this.baseTime = l2;
    }

    public long getBaseTime() {
        return this.baseTime;
    }
}

