/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ohh;

import com.contrastsecurity.thirdparty.ohh.AbstractHistogram;
import com.contrastsecurity.thirdparty.ohh.AbstractHistogramIterator;
import com.contrastsecurity.thirdparty.ohh.HistogramIterationValue;
import java.util.Iterator;

public class LinearIterator
extends AbstractHistogramIterator
implements Iterator<HistogramIterationValue> {
    private long valueUnitsPerBucket;
    private long currentStepHighestValueReportingLevel;
    private long currentStepLowestValueReportingLevel;

    public void reset(long l2) {
        this.reset(this.histogram, l2);
    }

    private void reset(AbstractHistogram abstractHistogram, long l2) {
        super.resetIterator(abstractHistogram);
        this.valueUnitsPerBucket = l2;
        this.currentStepHighestValueReportingLevel = l2 - 1L;
        this.currentStepLowestValueReportingLevel = abstractHistogram.lowestEquivalentValue(this.currentStepHighestValueReportingLevel);
    }

    public LinearIterator(AbstractHistogram abstractHistogram, long l2) {
        this.reset(abstractHistogram, l2);
    }

    @Override
    public boolean hasNext() {
        if (super.hasNext()) {
            return true;
        }
        return this.currentStepHighestValueReportingLevel < this.nextValueAtIndex;
    }

    @Override
    void incrementIterationLevel() {
        this.currentStepHighestValueReportingLevel += this.valueUnitsPerBucket;
        this.currentStepLowestValueReportingLevel = this.histogram.lowestEquivalentValue(this.currentStepHighestValueReportingLevel);
    }

    @Override
    long getValueIteratedTo() {
        return this.currentStepHighestValueReportingLevel;
    }

    @Override
    boolean reachedIterationLevel() {
        return this.currentValueAtIndex >= this.currentStepLowestValueReportingLevel || this.currentIndex >= this.histogram.countsArrayLength - 1;
    }
}

