/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.maps;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.ojt.maps.AbstractEntry;
import com.contrastsecurity.thirdparty.ojt.maps.ConcurrentAutoTable;
import com.contrastsecurity.thirdparty.ojt.util.RangeUtil;
import com.contrastsecurity.thirdparty.ojt.util.UnsafeAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class NonBlockingHashMap<TypeK, TypeV>
extends AbstractMap<TypeK, TypeV>
implements Serializable,
Cloneable,
ConcurrentMap<TypeK, TypeV> {
    private static final long serialVersionUID = 1234123412341234123L;
    private static final int REPROBE_LIMIT = 10;
    private static final int _Obase = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    private static final int _Oscale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
    private static final int _Olog = _Oscale == 4 ? 2 : (_Oscale == 8 ? 3 : 9999);
    private static final long _kvs_offset = UnsafeAccess.fieldOffset(NonBlockingHashMap.class, "_kvs");
    private transient Object[] _kvs;
    private transient long _last_resize_milli;
    private static final int MIN_SIZE_LOG = 3;
    private static final int MIN_SIZE = 8;
    private static final Object NO_MATCH_OLD = new Object();
    private static final Object MATCH_ANY = new Object();
    public static final Object TOMBSTONE = new Object();
    private static final Prime TOMBPRIME = new Prime(TOMBSTONE);
    private transient ConcurrentAutoTable _reprobes = new ConcurrentAutoTable();
    static volatile int DUMMY_VOLATILE;

    private static long rawIndex(Object[] objectArray, int n2) {
        assert (n2 >= 0 && n2 < objectArray.length);
        return (long)_Obase + ((long)n2 << _Olog);
    }

    private final boolean CAS_kvs(Object[] objectArray, Object[] objectArray2) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, _kvs_offset, objectArray, objectArray2);
    }

    private static final int hash(Object object) {
        int n2 = object.hashCode();
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        n2 ^= n2 >>> 7 ^ n2 >>> 4;
        n2 += n2 << 7;
        return n2;
    }

    private static final CHM chm(Object[] objectArray) {
        return (CHM)objectArray[0];
    }

    private static final int[] hashes(Object[] objectArray) {
        return (int[])objectArray[1];
    }

    private static final int len(Object[] objectArray) {
        return objectArray.length - 2 >> 1;
    }

    private static final Object key(Object[] objectArray, int n2) {
        return objectArray[(n2 << 1) + 2];
    }

    private static final Object val(Object[] objectArray, int n2) {
        return objectArray[(n2 << 1) + 3];
    }

    private static final boolean CAS_key(Object[] objectArray, int n2, Object object, Object object2) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(objectArray, NonBlockingHashMap.rawIndex(objectArray, (n2 << 1) + 2), object, object2);
    }

    private static final boolean CAS_val(Object[] objectArray, int n2, Object object, Object object2) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(objectArray, NonBlockingHashMap.rawIndex(objectArray, (n2 << 1) + 3), object, object2);
    }

    public final void print() {
        System.out.println("=========");
        this.print2(this._kvs);
        System.out.println("=========");
    }

    private final void print(Object[] objectArray) {
        for (int i2 = 0; i2 < NonBlockingHashMap.len(objectArray); ++i2) {
            Object object = NonBlockingHashMap.key(objectArray, i2);
            if (object == null) continue;
            String string = object == TOMBSTONE ? "XXX" : object.toString();
            Object object2 = NonBlockingHashMap.val(objectArray, i2);
            Object object3 = Prime.unbox(object2);
            String string2 = object2 == object3 ? "" : "prime_";
            String string3 = object3 == TOMBSTONE ? "tombstone" : object3.toString();
            System.out.println("" + i2 + " (" + string + "," + string2 + string3 + ")");
        }
        Object[] objectArray2 = NonBlockingHashMap.chm((Object[])objectArray)._newkvs;
        if (objectArray2 != null) {
            System.out.println("----");
            this.print(objectArray2);
        }
    }

    private final void print2(Object[] objectArray) {
        for (int i2 = 0; i2 < NonBlockingHashMap.len(objectArray); ++i2) {
            Object object = NonBlockingHashMap.key(objectArray, i2);
            Object object2 = NonBlockingHashMap.val(objectArray, i2);
            Object object3 = Prime.unbox(object2);
            if (object == null || object == TOMBSTONE || object2 == null || object3 == TOMBSTONE) continue;
            String string = object2 == object3 ? "" : "prime_";
            System.out.println("" + i2 + " (" + object + "," + string + object2 + ")");
        }
        Object[] objectArray2 = NonBlockingHashMap.chm((Object[])objectArray)._newkvs;
        if (objectArray2 != null) {
            System.out.println("----");
            this.print2(objectArray2);
        }
    }

    public long reprobes() {
        long l2 = this._reprobes.get();
        this._reprobes = new ConcurrentAutoTable();
        return l2;
    }

    private static int reprobe_limit(int n2) {
        return 10 + (n2 >> 4);
    }

    public NonBlockingHashMap() {
        this(8);
    }

    public NonBlockingHashMap(int n2) {
        this.initialize(n2);
    }

    private final void initialize(int n2) {
        RangeUtil.checkPositiveOrZero(n2, "initial_sz");
        if (n2 > 0x100000) {
            n2 = 0x100000;
        }
        int n3 = 3;
        while (1 << n3 < n2 << 2) {
            ++n3;
        }
        this._kvs = new Object[(1 << n3 << 1) + 2];
        this._kvs[0] = new CHM(new ConcurrentAutoTable());
        this._kvs[1] = new int[1 << n3];
        this._last_resize_milli = System.currentTimeMillis();
    }

    protected final void initialize() {
        this.initialize(8);
    }

    @Override
    public int size() {
        return NonBlockingHashMap.chm(this._kvs).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public TypeV put(TypeK TypeK, TypeV TypeV) {
        return this.putIfMatch(TypeK, TypeV, NO_MATCH_OLD);
    }

    @Override
    public TypeV putIfAbsent(TypeK TypeK, TypeV TypeV) {
        return this.putIfMatch(TypeK, TypeV, TOMBSTONE);
    }

    @Override
    public TypeV remove(Object object) {
        return this.putIfMatch(object, TOMBSTONE, NO_MATCH_OLD);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return NonBlockingHashMap.objectsEquals(this.putIfMatch(object, TOMBSTONE, object2), object2);
    }

    @Override
    public TypeV replace(TypeK TypeK, TypeV TypeV) {
        return this.putIfMatch(TypeK, TypeV, MATCH_ANY);
    }

    @Override
    public boolean replace(TypeK TypeK, TypeV TypeV, TypeV TypeV2) {
        return NonBlockingHashMap.objectsEquals(this.putIfMatch(TypeK, TypeV2, TypeV), TypeV);
    }

    private static boolean objectsEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public final TypeV putIfMatchAllowNull(Object object, Object object2, Object object3) {
        if (object3 == null) {
            object3 = TOMBSTONE;
        }
        if (object2 == null) {
            object2 = TOMBSTONE;
        }
        Object object4 = NonBlockingHashMap.putIfMatch0(this, this._kvs, object, object2, object3);
        assert (!(object4 instanceof Prime));
        return (TypeV)(object4 == TOMBSTONE ? null : object4);
    }

    public final TypeV putIfMatch(Object object, Object object2, Object object3) {
        if (object3 == null || object2 == null) {
            throw new NullPointerException();
        }
        Object object4 = NonBlockingHashMap.putIfMatch0(this, this._kvs, object, object2, object3);
        assert (!(object4 instanceof Prime));
        assert (object4 != null);
        return (TypeV)(object4 == TOMBSTONE ? null : object4);
    }

    @Override
    public void putAll(Map<? extends TypeK, ? extends TypeV> map) {
        for (Map.Entry<TypeK, TypeV> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        Object[] objectArray = new NonBlockingHashMap<TypeK, TypeV>((int)8)._kvs;
        while (!this.CAS_kvs(this._kvs, objectArray)) {
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (TypeV TypeV : this.values()) {
            if (TypeV != object && !TypeV.equals(object)) continue;
            return true;
        }
        return false;
    }

    protected void rehash() {
    }

    @Override
    public Object clone() {
        try {
            NonBlockingHashMap nonBlockingHashMap = (NonBlockingHashMap)super.clone();
            nonBlockingHashMap.clear();
            for (TypeK TypeK : this.keySet()) {
                TypeV TypeV = this.get(TypeK);
                nonBlockingHashMap.put(TypeK, TypeV);
            }
            return nonBlockingHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public String toString() {
        Iterator<Map.Entry<TypeK, TypeV>> iterator = this.entrySet().iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        while (true) {
            Map.Entry<TypeK, TypeV> entry = iterator.next();
            TypeK TypeK = entry.getKey();
            TypeV TypeV = entry.getValue();
            stringBuilder.append((Object)(TypeK == this ? "(this Map)" : TypeK));
            stringBuilder.append('=');
            stringBuilder.append((Object)(TypeV == this ? "(this Map)" : TypeV));
            if (!iterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(", ");
        }
    }

    private static boolean keyeq(Object object, Object object2, int[] nArray, int n2, int n3) {
        return object == object2 || (nArray[n2] == 0 || nArray[n2] == n3) && object != TOMBSTONE && object2.equals(object);
    }

    @Override
    public TypeV get(Object object) {
        Object object2 = NonBlockingHashMap.get_impl(this, this._kvs, object);
        assert (!(object2 instanceof Prime));
        assert (object2 != TOMBSTONE);
        return (TypeV)object2;
    }

    private static final Object get_impl(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, Object object) {
        int n2 = NonBlockingHashMap.hash(object);
        int n3 = NonBlockingHashMap.len(objectArray);
        CHM cHM = NonBlockingHashMap.chm(objectArray);
        int[] nArray = NonBlockingHashMap.hashes(objectArray);
        int n4 = n2 & n3 - 1;
        int n5 = 0;
        while (true) {
            Object object2 = NonBlockingHashMap.key(objectArray, n4);
            Object object3 = NonBlockingHashMap.val(objectArray, n4);
            if (object2 == null) {
                return null;
            }
            Object[] objectArray2 = cHM._newkvs;
            if (NonBlockingHashMap.keyeq(object2, object, nArray, n4, n2)) {
                if (!(object3 instanceof Prime)) {
                    return object3 == TOMBSTONE ? null : object3;
                }
                return NonBlockingHashMap.get_impl(nonBlockingHashMap, cHM.copy_slot_and_check(nonBlockingHashMap, objectArray, n4, object), object);
            }
            if (++n5 >= NonBlockingHashMap.reprobe_limit(n3) || object2 == TOMBSTONE) {
                return objectArray2 == null ? null : NonBlockingHashMap.get_impl(nonBlockingHashMap, nonBlockingHashMap.help_copy(objectArray2), object);
            }
            n4 = n4 + 1 & n3 - 1;
        }
    }

    public TypeK getk(TypeK TypeK) {
        return (TypeK)NonBlockingHashMap.getk_impl(this, this._kvs, TypeK);
    }

    private static final Object getk_impl(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, Object object) {
        int n2 = NonBlockingHashMap.hash(object);
        int n3 = NonBlockingHashMap.len(objectArray);
        CHM cHM = NonBlockingHashMap.chm(objectArray);
        int[] nArray = NonBlockingHashMap.hashes(objectArray);
        int n4 = n2 & n3 - 1;
        int n5 = 0;
        Object object2;
        while ((object2 = NonBlockingHashMap.key(objectArray, n4)) != null) {
            Object[] objectArray2 = cHM._newkvs;
            if (NonBlockingHashMap.keyeq(object2, object, nArray, n4, n2)) {
                return object2;
            }
            if (++n5 >= NonBlockingHashMap.reprobe_limit(n3) || object2 == TOMBSTONE) {
                return objectArray2 == null ? null : NonBlockingHashMap.getk_impl(nonBlockingHashMap, nonBlockingHashMap.help_copy(objectArray2), object);
            }
            n4 = n4 + 1 & n3 - 1;
        }
        return null;
    }

    private static final Object putIfMatch0(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, Object object, Object object2, Object object3) {
        int n2;
        assert (object2 != null);
        assert (!(object2 instanceof Prime));
        assert (!(object3 instanceof Prime));
        int n3 = NonBlockingHashMap.hash(object);
        int n4 = NonBlockingHashMap.len(objectArray);
        CHM cHM = NonBlockingHashMap.chm(objectArray);
        int[] nArray = NonBlockingHashMap.hashes(objectArray);
        int n5 = n3 & n4 - 1;
        int n6 = 0;
        Object object4 = null;
        Object object5 = null;
        Object[] objectArray2 = null;
        while (true) {
            object5 = NonBlockingHashMap.val(objectArray, n5);
            object4 = NonBlockingHashMap.key(objectArray, n5);
            if (object4 == null) {
                if (object2 == TOMBSTONE) {
                    return TOMBSTONE;
                }
                if (object3 == MATCH_ANY) {
                    return TOMBSTONE;
                }
                if (NonBlockingHashMap.CAS_key(objectArray, n5, null, object)) {
                    cHM._slots.add(1L);
                    nArray[n5] = n3;
                    break;
                }
                n2 = DUMMY_VOLATILE;
                continue;
            }
            objectArray2 = cHM._newkvs;
            if (NonBlockingHashMap.keyeq(object4, object, nArray, n5, n3)) break;
            if (++n6 >= NonBlockingHashMap.reprobe_limit(n4) || object4 == TOMBSTONE) {
                objectArray2 = cHM.resize(nonBlockingHashMap, objectArray);
                if (object3 != null) {
                    nonBlockingHashMap.help_copy(objectArray2);
                }
                return NonBlockingHashMap.putIfMatch0(nonBlockingHashMap, objectArray2, object, object2, object3);
            }
            n5 = n5 + 1 & n4 - 1;
        }
        while (true) {
            if (object2 == object5) {
                return object5;
            }
            if (objectArray2 == null && (object5 == null && cHM.tableFull(n6, n4) || object5 instanceof Prime)) {
                objectArray2 = cHM.resize(nonBlockingHashMap, objectArray);
            }
            if (objectArray2 != null) {
                return NonBlockingHashMap.putIfMatch0(nonBlockingHashMap, cHM.copy_slot_and_check(nonBlockingHashMap, objectArray, n5, object3), object, object2, object3);
            }
            assert (!(object5 instanceof Prime));
            if (!(object3 == NO_MATCH_OLD || object5 == object3 || object3 == MATCH_ANY && object5 != TOMBSTONE && object5 != null || object5 == null && object3 == TOMBSTONE || object3 != null && object3.equals(object5))) {
                return object5 == null ? TOMBSTONE : object5;
            }
            if (NonBlockingHashMap.CAS_val(objectArray, n5, object5, object2)) break;
            object5 = NonBlockingHashMap.val(objectArray, n5);
            if (object5 instanceof Prime) {
                return NonBlockingHashMap.putIfMatch0(nonBlockingHashMap, cHM.copy_slot_and_check(nonBlockingHashMap, objectArray, n5, object3), object, object2, object3);
            }
            n2 = DUMMY_VOLATILE;
        }
        if (object3 != null) {
            if ((object5 == null || object5 == TOMBSTONE) && object2 != TOMBSTONE) {
                cHM._size.add(1L);
            }
            if (object5 != null && object5 != TOMBSTONE && object2 == TOMBSTONE) {
                cHM._size.add(-1L);
            }
        }
        return object5 == null && object3 != null ? TOMBSTONE : object5;
    }

    private final Object[] help_copy(Object[] objectArray) {
        Object[] objectArray2 = this._kvs;
        CHM cHM = NonBlockingHashMap.chm(objectArray2);
        if (cHM._newkvs == null) {
            return objectArray;
        }
        cHM.help_copy_impl(this, objectArray2, false);
        return objectArray;
    }

    public Object[] raw_array() {
        return (NonBlockingHashMap)this.new SnapshotV()._sskvs;
    }

    public Enumeration<TypeV> elements() {
        return new SnapshotV();
    }

    @Override
    public Collection<TypeV> values() {
        return new AbstractCollection<TypeV>(){

            @Override
            public void clear() {
                NonBlockingHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return NonBlockingHashMap.this.containsValue(object);
            }

            @Override
            public Iterator<TypeV> iterator() {
                return new SnapshotV();
            }
        };
    }

    public Enumeration<TypeK> keys() {
        return new SnapshotK();
    }

    @Override
    public Set<TypeK> keySet() {
        return new AbstractSet<TypeK>(){

            @Override
            public void clear() {
                NonBlockingHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return NonBlockingHashMap.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                return NonBlockingHashMap.this.remove(object) != null;
            }

            @Override
            public Iterator<TypeK> iterator() {
                return new SnapshotK();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                Object[] objectArray = NonBlockingHashMap.this.raw_array();
                int n2 = this.size();
                T[] TArray2 = TArray.length >= n2 ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2);
                int n3 = 0;
                for (int i2 = 0; i2 < NonBlockingHashMap.len(objectArray); ++i2) {
                    Object object = NonBlockingHashMap.key(objectArray, i2);
                    Object object2 = Prime.unbox(NonBlockingHashMap.val(objectArray, i2));
                    if (object == null || object == TOMBSTONE || object2 == null || object2 == TOMBSTONE) continue;
                    if (n3 >= TArray2.length) {
                        int n4 = (int)Math.min(0x7FFFFFF7L, (long)n3 << 1);
                        if (n4 <= TArray2.length) {
                            throw new OutOfMemoryError("Required array size too large");
                        }
                        TArray2 = Arrays.copyOf(TArray2, n4);
                    }
                    TArray2[n3++] = object;
                }
                if (n3 <= TArray.length) {
                    if (TArray != TArray2) {
                        System.arraycopy(TArray2, 0, TArray, 0, n3);
                    }
                    if (n3 < TArray.length) {
                        TArray2[n3++] = null;
                    }
                    return TArray;
                }
                return Arrays.copyOf(TArray2, n3);
            }
        };
    }

    @Override
    public Set<Map.Entry<TypeK, TypeV>> entrySet() {
        return new AbstractSet<Map.Entry<TypeK, TypeV>>(){

            @Override
            public void clear() {
                NonBlockingHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMap.this.size();
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return NonBlockingHashMap.this.remove(entry.getKey(), entry.getValue());
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object TypeV = NonBlockingHashMap.this.get(entry.getKey());
                return TypeV != null && TypeV.equals(entry.getValue());
            }

            @Override
            public Iterator<Map.Entry<TypeK, TypeV>> iterator() {
                return new SnapshotE();
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (TypeK TypeK : this.keySet()) {
            TypeV TypeV = this.get(TypeK);
            objectOutputStream.writeObject(TypeK);
            objectOutputStream.writeObject(TypeV);
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize(8);
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put((TypeK)object, (TypeV)object2);
        }
    }

    private class SnapshotE
    implements Iterator<Map.Entry<TypeK, TypeV>> {
        final SnapshotV _ss;

        public SnapshotE() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.removeKey();
        }

        @Override
        public Map.Entry<TypeK, TypeV> next() {
            this._ss.next();
            return new NBHMEntry(this._ss._prevK, this._ss._prevV);
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }
    }

    private class NBHMEntry
    extends AbstractEntry<TypeK, TypeV> {
        NBHMEntry(TypeK TypeK, TypeV TypeV) {
            super(TypeK, TypeV);
        }

        @Override
        public TypeV setValue(TypeV TypeV) {
            if (TypeV == null) {
                throw new NullPointerException();
            }
            this._val = TypeV;
            return NonBlockingHashMap.this.put(this._key, TypeV);
        }
    }

    private class SnapshotK
    implements Enumeration<TypeK>,
    Iterator<TypeK> {
        final SnapshotV _ss;

        public SnapshotK() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.removeKey();
        }

        @Override
        public TypeK next() {
            this._ss.next();
            return this._ss._prevK;
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }

        @Override
        public TypeK nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private class SnapshotV
    implements Enumeration<TypeV>,
    Iterator<TypeV> {
        final Object[] _sskvs;
        private int _idx;
        private Object _nextK;
        private Object _prevK;
        private TypeV _nextV;
        private TypeV _prevV;

        public SnapshotV() {
            Object[] objectArray;
            while (true) {
                objectArray = NonBlockingHashMap.this._kvs;
                CHM cHM = NonBlockingHashMap.chm(objectArray);
                if (cHM._newkvs == null) break;
                cHM.help_copy_impl(NonBlockingHashMap.this, objectArray, true);
            }
            this._sskvs = objectArray;
            this.next();
        }

        int length() {
            return NonBlockingHashMap.len(this._sskvs);
        }

        Object key(int n2) {
            return NonBlockingHashMap.key(this._sskvs, n2);
        }

        @Override
        public boolean hasNext() {
            return this._nextV != null;
        }

        @Override
        public TypeV next() {
            if (this._idx != 0 && this._nextV == null) {
                throw new NoSuchElementException();
            }
            this._prevK = this._nextK;
            this._prevV = this._nextV;
            this._nextV = null;
            while (this._idx < this.length()) {
                this._nextK = this.key(this._idx++);
                if (this._nextK == null || this._nextK == TOMBSTONE || (this._nextV = NonBlockingHashMap.this.get(this._nextK)) == null) continue;
                break;
            }
            return this._prevV;
        }

        public void removeKey() {
            if (this._prevV == null) {
                throw new IllegalStateException();
            }
            NonBlockingHashMap.this.putIfMatch(this._prevK, TOMBSTONE, NO_MATCH_OLD);
            this._prevV = null;
        }

        @Override
        public void remove() {
            this.removeKey();
        }

        @Override
        public TypeV nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private static final class CHM<TypeK, TypeV> {
        private final ConcurrentAutoTable _size;
        private final ConcurrentAutoTable _slots;
        volatile Object[] _newkvs;
        private static final AtomicReferenceFieldUpdater<CHM, Object[]> _newkvsUpdater = AtomicReferenceFieldUpdater.newUpdater(CHM.class, Object[].class, "_newkvs");
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CHM> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_resizers");
        volatile long _copyIdx = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyIdxUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyIdx");
        volatile long _copyDone = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyDoneUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyDone");

        public int size() {
            return (int)this._size.get();
        }

        public int slots() {
            return (int)this._slots.get();
        }

        boolean CAS_newkvs(Object[] objectArray) {
            while (this._newkvs == null) {
                if (!_newkvsUpdater.compareAndSet(this, null, objectArray)) continue;
                return true;
            }
            return false;
        }

        CHM(ConcurrentAutoTable concurrentAutoTable) {
            this._size = concurrentAutoTable;
            this._slots = new ConcurrentAutoTable();
        }

        private final boolean tableFull(int n2, int n3) {
            return n2 >= 10 && (n2 >= NonBlockingHashMap.reprobe_limit(n3) || this._slots.estimate_get() >= (long)(n3 >> 1));
        }

        private final Object[] resize(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray) {
            int n2;
            assert (NonBlockingHashMap.chm(objectArray) == this);
            Object[] objectArray2 = this._newkvs;
            if (objectArray2 != null) {
                return objectArray2;
            }
            int n3 = NonBlockingHashMap.len(objectArray);
            int n4 = n2 = this.size();
            if (n2 >= n3 >> 2) {
                n4 = n3 << 1;
                if (4L * (long)n2 >= (n3 >> 20 != 0 ? 3L : 2L) * (long)n3) {
                    n4 = n3 << 2;
                }
            }
            long l2 = System.currentTimeMillis();
            if (n4 <= n3 && l2 <= nonBlockingHashMap._last_resize_milli + 10000L) {
                n4 = n3 << 1;
            }
            if (n4 < n3) {
                n4 = n3;
            }
            int n5 = 3;
            while (1 << n5 < n4) {
                ++n5;
            }
            long l3 = (1L << n5 << 1) + 2L;
            if ((long)((int)l3) != l3 && (long)n2 > ((l3 = (1L << (n5 = 30)) + 2L) >> 2) + (l3 >> 1)) {
                throw new RuntimeException("Table is full.");
            }
            long l4 = this._resizers;
            while (!_resizerUpdater.compareAndSet(this, l4, l4 + 1L)) {
                l4 = this._resizers;
            }
            long l5 = (1L << n5 << 1) + 8L << 3 >> 20;
            if (l4 >= 2L && l5 > 0L) {
                objectArray2 = this._newkvs;
                if (objectArray2 != null) {
                    return objectArray2;
                }
                try {
                    Thread.sleep(l5);
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                }
            }
            if ((objectArray2 = this._newkvs) != null) {
                return objectArray2;
            }
            objectArray2 = new Object[(int)l3];
            objectArray2[0] = new CHM<TypeK, TypeV>(this._size);
            objectArray2[1] = new int[1 << n5];
            if (this._newkvs != null) {
                return this._newkvs;
            }
            if (this.CAS_newkvs(objectArray2)) {
                nonBlockingHashMap.rehash();
            } else {
                objectArray2 = this._newkvs;
            }
            return objectArray2;
        }

        private final void help_copy_impl(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, boolean bl2) {
            assert (NonBlockingHashMap.chm(objectArray) == this);
            Object[] objectArray2 = this._newkvs;
            assert (objectArray2 != null);
            int n2 = NonBlockingHashMap.len(objectArray);
            int n3 = Math.min(n2, 1024);
            int n4 = -1;
            int n5 = -9999;
            while (this._copyDone < (long)n2) {
                if (n4 == -1) {
                    n5 = (int)this._copyIdx;
                    while (!_copyIdxUpdater.compareAndSet(this, n5, n5 + n3)) {
                        n5 = (int)this._copyIdx;
                    }
                    if (n5 >= n2 << 1) {
                        n4 = n5;
                    }
                }
                int n6 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (!this.copy_slot(nonBlockingHashMap, n5 + i2 & n2 - 1, objectArray, objectArray2)) continue;
                    ++n6;
                }
                if (n6 > 0) {
                    this.copy_check_and_promote(nonBlockingHashMap, objectArray, n6);
                }
                n5 += n3;
                if (bl2 || n4 != -1) continue;
                return;
            }
            this.copy_check_and_promote(nonBlockingHashMap, objectArray, 0);
        }

        private final Object[] copy_slot_and_check(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, int n2, Object object) {
            assert (NonBlockingHashMap.chm(objectArray) == this);
            Object[] objectArray2 = this._newkvs;
            assert (objectArray2 != null);
            if (this.copy_slot(nonBlockingHashMap, n2, objectArray, this._newkvs)) {
                this.copy_check_and_promote(nonBlockingHashMap, objectArray, 1);
            }
            return object == null ? objectArray2 : nonBlockingHashMap.help_copy(objectArray2);
        }

        private final void copy_check_and_promote(NonBlockingHashMap nonBlockingHashMap, Object[] objectArray, int n2) {
            assert (NonBlockingHashMap.chm(objectArray) == this);
            int n3 = NonBlockingHashMap.len(objectArray);
            long l2 = this._copyDone;
            assert (l2 + (long)n2 <= (long)n3);
            if (n2 > 0) {
                while (!_copyDoneUpdater.compareAndSet(this, l2, l2 + (long)n2)) {
                    l2 = this._copyDone;
                    assert (l2 + (long)n2 <= (long)n3);
                }
            }
            if (l2 + (long)n2 == (long)n3 && nonBlockingHashMap._kvs == objectArray && nonBlockingHashMap.CAS_kvs(objectArray, this._newkvs)) {
                nonBlockingHashMap._last_resize_milli = System.currentTimeMillis();
            }
        }

        private boolean copy_slot(NonBlockingHashMap nonBlockingHashMap, int n2, Object[] objectArray, Object[] objectArray2) {
            Object object;
            Object object2;
            while ((object2 = NonBlockingHashMap.key(objectArray, n2)) == null) {
                NonBlockingHashMap.CAS_key(objectArray, n2, null, TOMBSTONE);
            }
            Object object3 = NonBlockingHashMap.val(objectArray, n2);
            while (!(object3 instanceof Prime)) {
                Object object4 = object = object3 == null || object3 == TOMBSTONE ? TOMBPRIME : new Prime(object3);
                if (NonBlockingHashMap.CAS_val(objectArray, n2, object3, object)) {
                    if (object == TOMBPRIME) {
                        return true;
                    }
                    object3 = object;
                    break;
                }
                object3 = NonBlockingHashMap.val(objectArray, n2);
            }
            if (object3 == TOMBPRIME) {
                return false;
            }
            object = ((Prime)object3)._V;
            assert (object != TOMBSTONE);
            NonBlockingHashMap.putIfMatch0(nonBlockingHashMap, objectArray2, object2, object, null);
            while (object3 != TOMBPRIME && !NonBlockingHashMap.CAS_val(objectArray, n2, object3, TOMBPRIME)) {
                object3 = NonBlockingHashMap.val(objectArray, n2);
            }
            return object3 != TOMBPRIME;
        }
    }

    private static final class Prime {
        final Object _V;

        Prime(Object object) {
            this._V = object;
        }

        static Object unbox(Object object) {
            return object instanceof Prime ? ((Prime)object)._V : object;
        }
    }
}

