/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.queues;

import com.contrastsecurity.thirdparty.ojt.queues.BaseMpscLinkedArrayQueueColdProducerFields;
import com.contrastsecurity.thirdparty.ojt.queues.IndexedQueueSizeUtil;
import com.contrastsecurity.thirdparty.ojt.queues.LinkedArrayQueueUtil;
import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueueUtil;
import com.contrastsecurity.thirdparty.ojt.queues.QueueProgressIndicators;
import com.contrastsecurity.thirdparty.ojt.util.PortableJvmInfo;
import com.contrastsecurity.thirdparty.ojt.util.Pow2;
import com.contrastsecurity.thirdparty.ojt.util.RangeUtil;
import com.contrastsecurity.thirdparty.ojt.util.UnsafeRefArrayAccess;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class BaseMpscLinkedArrayQueue<E>
extends BaseMpscLinkedArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();
    private static final Object BUFFER_CONSUMED = new Object();
    private static final int CONTINUE_TO_P_INDEX_CAS = 0;
    private static final int RETRY = 1;
    private static final int QUEUE_FULL = 2;
    private static final int QUEUE_RESIZE = 3;

    public BaseMpscLinkedArrayQueue(int n2) {
        RangeUtil.checkGreaterThanOrEqual(n2, 2, "initialCapacity");
        int n3 = Pow2.roundToPowerOfTwo(n2);
        long l2 = n3 - 1 << 1;
        E[] EArray = UnsafeRefArrayAccess.allocateRefArray(n3 + 1);
        this.producerBuffer = EArray;
        this.producerMask = l2;
        this.consumerBuffer = EArray;
        this.consumerMask = l2;
        this.soProducerLimit(l2);
    }

    @Override
    public int size() {
        return IndexedQueueSizeUtil.size(this, 2);
    }

    @Override
    public boolean isEmpty() {
        return (this.lvConsumerIndex() - this.lvProducerIndex()) / 2L == 0L;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e2) {
        Object[] objectArray;
        long l2;
        long l3;
        long l4;
        if (null == e2) {
            throw new NullPointerException();
        }
        block6: while (true) {
            l4 = this.lvProducerLimit();
            l3 = this.lvProducerIndex();
            if ((l3 & 1L) == 1L) continue;
            l2 = this.producerMask;
            objectArray = this.producerBuffer;
            if (l4 <= l3) {
                int n2 = this.offerSlowPath(l2, l3, l4);
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l2, objectArray, l3, e2, null);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l3, l3 + 2L)) break;
        }
        l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2);
        UnsafeRefArrayAccess.soRefElement(objectArray, l4, e2);
        return true;
    }

    @Override
    public E poll() {
        long l2;
        Object[] objectArray = this.consumerBuffer;
        long l3 = this.lpConsumerIndex();
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2 = this.consumerMask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l4);
        if (object == null) {
            long l5 = this.lvProducerIndex();
            if ((l3 - l5) / 2L == 0L) {
                return null;
            }
            while ((object = UnsafeRefArrayAccess.lvRefElement(objectArray, l4)) == null) {
            }
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.nextBuffer(objectArray, l2);
            return (E)this.newBufferPoll(objectArray2, l3);
        }
        UnsafeRefArrayAccess.soRefElement(objectArray, l4, null);
        this.soConsumerIndex(l3 + 2L);
        return (E)object;
    }

    @Override
    public E peek() {
        long l2;
        Object[] objectArray = this.consumerBuffer;
        long l3 = this.lpConsumerIndex();
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2 = this.consumerMask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l4);
        if (object == null) {
            long l5 = this.lvProducerIndex();
            if ((l3 - l5) / 2L == 0L) {
                return null;
            }
            while ((object = UnsafeRefArrayAccess.lvRefElement(objectArray, l4)) == null) {
            }
        }
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.nextBuffer(objectArray, l2), l3);
        }
        return (E)object;
    }

    private int offerSlowPath(long l2, long l3, long l4) {
        long l5;
        long l6 = this.lvConsumerIndex();
        if (l6 + (l5 = this.getCurrentBufferCapacity(l2)) > l3) {
            if (!this.casProducerLimit(l4, l6 + l5)) {
                return 1;
            }
            return 0;
        }
        if (this.availableInQueue(l3, l6) <= 0L) {
            return 2;
        }
        if (this.casProducerIndex(l3, l3 + 1L)) {
            return 3;
        }
        return 1;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private E[] nextBuffer(E[] EArray, long l2) {
        long l3 = BaseMpscLinkedArrayQueue.nextArrayOffset(l2);
        Object[] objectArray = (Object[])UnsafeRefArrayAccess.lvRefElement(EArray, l3);
        this.consumerBuffer = objectArray;
        this.consumerMask = LinkedArrayQueueUtil.length(objectArray) - 2 << 1;
        UnsafeRefArrayAccess.soRefElement(EArray, l3, BUFFER_CONSUMED);
        return objectArray;
    }

    private static long nextArrayOffset(long l2) {
        return LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2 + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] EArray, long l2) {
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, this.consumerMask);
        E e2 = UnsafeRefArrayAccess.lvRefElement(EArray, l3);
        if (e2 == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soRefElement(EArray, l3, null);
        this.soConsumerIndex(l2 + 2L);
        return e2;
    }

    private E newBufferPeek(E[] EArray, long l2) {
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, this.consumerMask);
        E e2 = UnsafeRefArrayAccess.lvRefElement(EArray, l3);
        if (null == e2) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e2;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        long l2;
        Object[] objectArray = this.consumerBuffer;
        long l3 = this.lpConsumerIndex();
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2 = this.consumerMask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l4);
        if (object == null) {
            return null;
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.nextBuffer(objectArray, l2);
            return (E)this.newBufferPoll(objectArray2, l3);
        }
        UnsafeRefArrayAccess.soRefElement(objectArray, l4, null);
        this.soConsumerIndex(l3 + 2L);
        return (E)object;
    }

    @Override
    public E relaxedPeek() {
        long l2;
        Object[] objectArray = this.consumerBuffer;
        long l3 = this.lpConsumerIndex();
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2 = this.consumerMask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l4);
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.nextBuffer(objectArray, l2), l3);
        }
        return (E)object;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        int n2;
        long l2 = 0L;
        int n3 = this.capacity();
        do {
            if ((n2 = this.fill(supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l2;
        } while ((l2 += (long)n2) <= (long)n3);
        return (int)l2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n2) {
        long l2;
        Object[] objectArray;
        long l3;
        long l4;
        if (null == supplier) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("limit is negative:" + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        block5: while (true) {
            long l5 = this.lvProducerLimit();
            l4 = this.lvProducerIndex();
            if ((l4 & 1L) == 1L) continue;
            l3 = this.producerMask;
            objectArray = this.producerBuffer;
            l2 = Math.min(l5, l4 + 2L * (long)n2);
            if (l4 >= l5) {
                int n3 = this.offerSlowPath(l3, l4, l5);
                switch (n3) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l3, objectArray, l4, null, supplier);
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l4, l2)) break;
        }
        int n4 = (int)((l2 - l4) / 2L);
        for (int i2 = 0; i2 < n4; ++i2) {
            long l6 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l4 + 2L * (long)i2, l3);
            UnsafeRefArrayAccess.soRefElement(objectArray, l6, supplier.get());
        }
        return n4;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return this.drain(consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n2) {
        return MessagePassingQueueUtil.drain(this, consumer, n2);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public Iterator<E> iterator() {
        return new WeakIterator<Object>(this.consumerBuffer, this.lvConsumerIndex(), this.lvProducerIndex());
    }

    private void resize(long l2, E[] EArray, long l3, E e2, MessagePassingQueue.Supplier<E> supplier) {
        E[] EArray2;
        assert (e2 != null && supplier == null || e2 == null || supplier != null);
        int n2 = this.getNextBufferSize(EArray);
        try {
            EArray2 = UnsafeRefArrayAccess.allocateRefArray(n2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            assert (this.lvProducerIndex() == l3 + 1L);
            this.soProducerIndex(l3);
            throw outOfMemoryError;
        }
        this.producerBuffer = EArray2;
        int n3 = n2 - 2 << 1;
        this.producerMask = n3;
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2);
        long l5 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, n3);
        UnsafeRefArrayAccess.soRefElement(EArray2, l5, e2 == null ? supplier.get() : e2);
        UnsafeRefArrayAccess.soRefElement(EArray, BaseMpscLinkedArrayQueue.nextArrayOffset(l2), EArray2);
        long l6 = this.lvConsumerIndex();
        long l7 = this.availableInQueue(l3, l6);
        RangeUtil.checkPositive(l7, "availableInQueue");
        this.soProducerLimit(l3 + Math.min((long)n3, l7));
        this.soProducerIndex(l3 + 2L);
        UnsafeRefArrayAccess.soRefElement(EArray, l4, JUMP);
    }

    protected abstract int getNextBufferSize(E[] var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    private static class WeakIterator<E>
    implements Iterator<E> {
        private final long pIndex;
        private long nextIndex;
        private E nextElement;
        private E[] currentBuffer;
        private int mask;

        WeakIterator(E[] EArray, long l2, long l3) {
            this.pIndex = l3 >> 1;
            this.nextIndex = l2 >> 1;
            this.setBuffer(EArray);
            this.nextElement = this.getNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            E e2 = this.nextElement;
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return e2;
        }

        private void setBuffer(E[] EArray) {
            this.currentBuffer = EArray;
            this.mask = LinkedArrayQueueUtil.length(EArray) - 2;
        }

        private E getNext() {
            while (this.nextIndex < this.pIndex) {
                long l2;
                ++this.nextIndex;
                E e2 = UnsafeRefArrayAccess.lvRefElement(this.currentBuffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, this.mask));
                if (e2 == null) continue;
                if (e2 != JUMP) {
                    return e2;
                }
                int n2 = this.mask + 1;
                E e3 = UnsafeRefArrayAccess.lvRefElement(this.currentBuffer, UnsafeRefArrayAccess.calcRefElementOffset(n2));
                if (e3 == BUFFER_CONSUMED || e3 == null) {
                    return null;
                }
                this.setBuffer((Object[])e3);
                e2 = UnsafeRefArrayAccess.lvRefElement(this.currentBuffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, this.mask));
                if (e2 == null) continue;
                return e2;
            }
            return null;
        }
    }
}

