/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.queues;

import com.contrastsecurity.thirdparty.ojt.queues.IndexedQueueSizeUtil;
import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueueUtil;
import com.contrastsecurity.thirdparty.ojt.queues.MpUnboundedXaddArrayQueuePad5;
import com.contrastsecurity.thirdparty.ojt.queues.MpUnboundedXaddChunk;
import com.contrastsecurity.thirdparty.ojt.queues.QueueProgressIndicators;
import com.contrastsecurity.thirdparty.ojt.queues.SpscArrayQueue;
import com.contrastsecurity.thirdparty.ojt.util.PortableJvmInfo;
import com.contrastsecurity.thirdparty.ojt.util.Pow2;
import com.contrastsecurity.thirdparty.ojt.util.UnsafeAccess;
import java.util.Iterator;

abstract class MpUnboundedXaddArrayQueue<R extends MpUnboundedXaddChunk<R, E>, E>
extends MpUnboundedXaddArrayQueuePad5<R, E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final long ROTATION = -2L;
    final int chunkMask;
    final int chunkShift;
    final int maxPooledChunks;
    final SpscArrayQueue<R> freeChunksPool;

    MpUnboundedXaddArrayQueue(int n2, int n3) {
        if (!UnsafeAccess.SUPPORTS_GET_AND_ADD_LONG) {
            throw new IllegalStateException("Unsafe::getAndAddLong support (JDK 8+) is required for this queue to work");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Expecting a positive maxPooledChunks, but got:" + n3);
        }
        n2 = Pow2.roundToPowerOfTwo(n2);
        this.chunkMask = n2 - 1;
        this.chunkShift = Integer.numberOfTrailingZeros(n2);
        this.freeChunksPool = new SpscArrayQueue(n3);
        Object r2 = this.newChunk(0L, null, n2, n3 > 0);
        this.soProducerChunk(r2);
        this.soProducerChunkIndex(0L);
        this.soConsumerChunk(r2);
        for (int i2 = 1; i2 < n3; ++i2) {
            this.freeChunksPool.offer((R)this.newChunk(-1L, null, n2, true));
        }
        this.maxPooledChunks = n3;
    }

    public final int chunkSize() {
        return this.chunkMask + 1;
    }

    public final int maxPooledChunks() {
        return this.maxPooledChunks;
    }

    abstract R newChunk(long var1, R var3, int var4, boolean var5);

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    final R producerChunkForIndex(R r2, long l2) {
        long l3;
        long l4;
        Object object = r2;
        while (true) {
            if (object == null) {
                object = this.lvProducerChunk();
            }
            l4 = ((MpUnboundedXaddChunk)object).lvIndex();
            assert (l4 != -1L);
            l3 = l4 - l2;
            if (l3 >= 0L) break;
            if (this.lvProducerChunkIndex() == l4) {
                object = this.appendNextChunks(object, l4, -l3);
                continue;
            }
            object = null;
        }
        for (l4 = 0L; l4 < l3; ++l4) {
            object = (MpUnboundedXaddChunk)((MpUnboundedXaddChunk)object).lvPrev();
            assert (object != null);
        }
        assert (((MpUnboundedXaddChunk)object).lvIndex() == l2);
        return object;
    }

    protected final R appendNextChunks(R r2, long l2, long l3) {
        assert (l2 != -1L);
        if (!this.casProducerChunkIndex(l2, -2L)) {
            return null;
        }
        assert (l2 == ((MpUnboundedXaddChunk)r2).lvIndex());
        for (long i2 = 1L; i2 <= l3; ++i2) {
            R r3 = this.newOrPooledChunk(r2, l2 + i2);
            this.soProducerChunk(r3);
            ((MpUnboundedXaddChunk)r2).soNext(r3);
            r2 = r3;
        }
        this.soProducerChunkIndex(l2 + l3);
        return r2;
    }

    private R newOrPooledChunk(R r2, long l2) {
        MpUnboundedXaddChunk mpUnboundedXaddChunk = (MpUnboundedXaddChunk)this.freeChunksPool.poll();
        if (mpUnboundedXaddChunk != null) {
            assert (mpUnboundedXaddChunk.lvIndex() < ((MpUnboundedXaddChunk)r2).lvIndex());
            mpUnboundedXaddChunk.soPrev(r2);
            mpUnboundedXaddChunk.soIndex(l2);
        } else {
            mpUnboundedXaddChunk = this.newChunk(l2, r2, this.chunkMask + 1, false);
        }
        return (R)mpUnboundedXaddChunk;
    }

    final void moveToNextConsumerChunk(R object, R object2) {
        ((MpUnboundedXaddChunk)object).soNext(null);
        ((MpUnboundedXaddChunk)object2).soPrev(null);
        if (((MpUnboundedXaddChunk)object).isPooled()) {
            boolean bl2 = this.freeChunksPool.offer((R)object);
            assert (bl2);
        }
        this.soConsumerChunk(object2);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return IndexedQueueSizeUtil.size(this, 1);
    }

    @Override
    public boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return MessagePassingQueueUtil.drain(this, consumer);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        int n2 = this.chunkMask + 1;
        int n3 = Math.min(PortableJvmInfo.RECOMENDED_OFFER_BATCH, n2);
        return MessagePassingQueueUtil.fillInBatchesToLimit(this, supplier, n3, n2);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n2) {
        return MessagePassingQueueUtil.drain(this, consumer, n2);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }
}

