/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.queues;

import com.contrastsecurity.thirdparty.ojt.queues.BaseSpscLinkedArrayQueue;
import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.ojt.util.Pow2;
import com.contrastsecurity.thirdparty.ojt.util.RangeUtil;
import com.contrastsecurity.thirdparty.ojt.util.UnsafeRefArrayAccess;

public class SpscChunkedArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    private final int maxQueueCapacity;
    private long producerQueueLimit;

    public SpscChunkedArrayQueue(int n2) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(n2 / 8)), n2);
    }

    public SpscChunkedArrayQueue(int n2, int n3) {
        RangeUtil.checkGreaterThanOrEqual(n3, 16, "capacity");
        RangeUtil.checkGreaterThanOrEqual(n2, 8, "chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(n3);
        int n4 = Pow2.roundToPowerOfTwo(n2);
        RangeUtil.checkLessThan(n4, this.maxQueueCapacity, "chunkCapacity");
        long l2 = n4 - 1;
        E[] EArray = UnsafeRefArrayAccess.allocateRefArray(n4 + 1);
        this.producerBuffer = EArray;
        this.producerMask = l2;
        this.consumerBuffer = EArray;
        this.consumerMask = l2;
        this.producerBufferLimit = l2 - 1L;
        this.producerQueueLimit = this.maxQueueCapacity;
    }

    @Override
    final boolean offerColdPath(E[] EArray, long l2, long l3, long l4, E e2, MessagePassingQueue.Supplier<? extends E> supplier) {
        long l5 = (l2 + 1L) / 4L;
        long l6 = l3 + l5;
        long l7 = this.producerQueueLimit;
        if (l3 >= l7) {
            long l8 = this.lvConsumerIndex();
            this.producerQueueLimit = l7 = l8 + (long)this.maxQueueCapacity;
            if (l3 >= l7) {
                return false;
            }
        }
        if (l6 - l7 > 0L) {
            l6 = l7;
        }
        if (l6 > l3 + 1L && null == UnsafeRefArrayAccess.lvRefElement(EArray, UnsafeRefArrayAccess.calcCircularRefElementOffset(l6, l2))) {
            this.producerBufferLimit = l6 - 1L;
            this.writeToQueue(EArray, e2 == null ? supplier.get() : e2, l3, l4);
        } else if (null == UnsafeRefArrayAccess.lvRefElement(EArray, UnsafeRefArrayAccess.calcCircularRefElementOffset(l3 + 1L, l2))) {
            this.writeToQueue(EArray, e2 == null ? supplier.get() : e2, l3, l4);
        } else {
            E[] EArray2 = UnsafeRefArrayAccess.allocateRefArray((int)(l2 + 2L));
            this.producerBuffer = EArray2;
            this.linkOldToNew(l3, EArray, l4, EArray2, l4, e2 == null ? supplier.get() : e2);
        }
        return true;
    }

    @Override
    public int capacity() {
        return this.maxQueueCapacity;
    }
}

